/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.g.IGProtectiveEquipmentService;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckEditParam;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckLogListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckReturnParam;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckLogListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckOneVo;
import jakarta.validation.constraints.NotNull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/protective/equipment"})
@Validated
public class GProtectiveEquipmentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GProtectiveEquipmentController.class);
    @Autowired
    private IGProtectiveEquipmentService protectiveEquipmentService;

    @ApiEncrypt(request=true)
    @RequestLimit(second=10, maxCount=5)
    @PostMapping(value={"/addSelfCheck"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_keyFactor_protective, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u4e2a\u4eba\u9632\u62a4\u7528\u54c1-\u65b0\u589e\u81ea\u68c0\u4fe1\u606f")
    public ResponseData<String> addSelfCheck(@RequestBody @Validated GEquipmentSelfCheckEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        this.protectiveEquipmentService.addOrEditOneSelfCheck(param);
        return ResponseData.success();
    }

    @RequestLimit(second=10, maxCount=5)
    @ApiEncrypt(request=true)
    @PostMapping(value={"/editSelfCheck"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_protective, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u4e2a\u4eba\u9632\u62a4\u7528\u54c1-\u7f16\u8f91\u81ea\u68c0\u4fe1\u606f")
    public ResponseData<String> editSelfCheck(@RequestBody @Validated GEquipmentSelfCheckEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        this.protectiveEquipmentService.addOrEditOneSelfCheck(param);
        return ResponseData.success();
    }

    @RequestLimit(second=10, maxCount=5)
    @ApiEncrypt(response=true)
    @GetMapping(value={"/getSelfCheckById/{id}"})
    public ResponseData<GEquipmentSelfCheckOneVo> getSelfCheckById(@PathVariable(value="id") @NotNull(message="\u81ea\u68c0id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u81ea\u68c0id\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        return ResponseData.success((Object)this.protectiveEquipmentService.getOneById(id));
    }

    @RequestLimit(second=10, maxCount=5)
    @ApiEncrypt(response=true)
    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<GEquipmentSelfCheckListVo>> getList(@Validated GEquipmentSelfCheckListParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.protectiveEquipmentService.getSelfCheckList(param));
    }

    @RequestLimit(second=10, maxCount=5)
    @GetMapping(value={"/getSelfCheckLog"})
    public ResponseData<LayuiGridData<GEquipmentSelfCheckLogListVo>> getSelfCheckLog(@Validated GEquipmentSelfCheckLogListParam param) {
        return ResponseData.success(this.protectiveEquipmentService.getSelfCheckLog(param));
    }

    @RequestLimit(second=10, maxCount=5)
    @PostMapping(value={"/returnSelfCheck"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_protective, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u4e2a\u4eba\u9632\u62a4\u7528\u54c1-\u9000\u56de\u81ea\u68c0\u4fe1\u606f")
    public ResponseData<String> returnSelfCheck(@RequestBody @Validated GEquipmentSelfCheckReturnParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserSuperuserId());
        this.protectiveEquipmentService.returnSelfCheck(param);
        return ResponseData.success();
    }
}

