/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.utils.FieldCheckUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.f.IFProjectService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.f.FProjectDetailFillTypeEnum;
import cn.smarthse.rho.modules.sys.model.f.param.FThreeTimesProjectEditParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectDetailQueryParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectQueryParam;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectDetailVo;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectVo;
import cn.smarthse.rho.modules.sys.model.sys.param.SysBusinessOperateLogParam;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/threeProject"})
public class FThreeProjectController {
    @Autowired
    private IFProjectService projectService;
    @Autowired
    private IBCompanyService companyService;
    @DubboReference
    private ISysBusinessOperateLogProvider operateLogProvider;

    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<FThreeTimesProjectVo>> getList(ThreeProjectQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.projectService.getThreeProjectList(param));
    }

    @GetMapping(value={"/getDetail"})
    public ResponseData<FThreeTimesProjectDetailVo> getDetail(@Validated ThreeProjectDetailQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.projectService.getDetailByProjectId(param));
    }

    @GetMapping(value={"/getComBaseInfo"})
    public ResponseData<BCompany> getComBaseInfo(Long id) {
        return ResponseData.success((Object)((BCompany)this.companyService.getById(id)));
    }

    @RequestLimit(second=5, maxCount=1)
    @PostMapping(value={"/edit"})
    public ResponseData<String> edit(@RequestBody FThreeTimesProjectEditParam param) {
        if (param.getBaseInfo() == null) {
            return ResponseData.fail((String)"\u9879\u76ee\u57fa\u7840\u4fe1\u606f\u7f3a\u5931\uff01");
        }
        this.projectService.editThreeTimesProject(param);
        return ResponseData.success();
    }

    @RequestLimit(second=5, maxCount=1)
    @PostMapping(value={"/submit"})
    public ResponseData<String> submit(@RequestBody @Validated FThreeTimesProjectEditParam param) {
        if (param.getBaseInfo() == null) {
            return ResponseData.fail((String)"\u9879\u76ee\u57fa\u7840\u4fe1\u606f\u7f3a\u5931\uff01");
        }
        FieldCheckUtils.checkEmptyFields((Object)param.getBaseInfo(), (String[])new String[]{"name|\u9879\u76ee\u540d\u79f0", "raType|\u9879\u76ee\u7c7b\u578b", "occType|\u804c\u4e1a\u75c5\u5371\u5bb3\u7c7b\u522b", "beginDate|\u7acb\u9879\u65f6\u95f4", "finishDate|\u7ae3\u5de5\u65f6\u95f4"});
        if (param.getProjectDetail1() != null && Objects.equals(param.getProjectDetail1().getFillType(), FProjectDetailFillTypeEnum.TYPE_1.getValue())) {
            FieldCheckUtils.checkEmptyFields((Object)param.getProjectDetail1(), (String[])new String[]{"fillType|\u8bbe\u5907\u5bf9\u5e94\u9884\u8bc4\u63a7\u8bc4\u586b\u5199\u7c7b\u578b", "preTechName|\u9884\u8bc4\u6280\u672f\u670d\u52a1\u673a\u6784\u540d\u79f0", "preReportNo|\u9884\u8bc4\u4ef7\u62a5\u544a\u4e66\u7f16\u53f7", "preReportDate|\u9884\u8bc4\u62a5\u544a\u51fa\u5177\u65f6\u95f4"});
        } else {
            FieldCheckUtils.checkEmptyFields((Object)param.getProjectDetail1(), (String[])new String[]{"fillType|\u8bbe\u5907\u5bf9\u5e94\u9884\u8bc4\u63a7\u8bc4\u586b\u5199\u7c7b\u578b", "reason|\u5408\u7406\u7f3a\u9879\u539f\u56e0"});
        }
        if (param.getProjectDetail2() != null && Objects.equals(param.getProjectDetail2().getFillType(), FProjectDetailFillTypeEnum.TYPE_1.getValue())) {
            FieldCheckUtils.checkEmptyFields((Object)param.getProjectDetail2(), (String[])new String[]{"fillType|\u573a\u6240\u5bf9\u5e94\u9884\u8bc4\u63a7\u8bc4\u586b\u5199\u7c7b\u578b", "preTechName|\u9884\u8bc4\u6280\u672f\u670d\u52a1\u673a\u6784\u540d\u79f0", "preReportNo|\u9884\u8bc4\u4ef7\u62a5\u544a\u4e66\u7f16\u53f7", "preReportDate|\u9884\u8bc4\u62a5\u544a\u51fa\u5177\u65f6\u95f4"});
        } else {
            FieldCheckUtils.checkEmptyFields((Object)param.getProjectDetail2(), (String[])new String[]{"fillType|\u573a\u6240\u5bf9\u5e94\u9884\u8bc4\u63a7\u8bc4\u586b\u5199\u7c7b\u578b", "reason|\u5408\u7406\u7f3a\u9879\u539f\u56e0"});
        }
        this.projectService.submitThreeTimesProject(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/getOperateLogListData"})
    public ResponseData<LayuiGridData<SysBusinessOperateLog>> getOperateLogListData(SysBusinessOperateLogParam param) {
        return ResponseData.success((Object)this.operateLogProvider.getPageListData(param));
    }
}

