/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.d.IDLocationCheckDataService;
import cn.smarthse.rho.modules.company.service.d.IDLocationCheckService;
import cn.smarthse.rho.modules.sys.entity.d.DLocationCheck;
import cn.smarthse.rho.modules.sys.entity.d.DLocationCheckData;
import cn.smarthse.rho.modules.sys.model.d.param.AddLocationCheckVo;
import cn.smarthse.rho.modules.sys.model.d.param.DLocationCheckDataQueryParam;
import cn.smarthse.rho.modules.sys.model.d.param.DLocationCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.d.vo.DLocationCheckVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/locationCheck"})
public class DLocationCheckController {
    @Autowired
    private IDLocationCheckService LocationCheckService;
    @Autowired
    private IDLocationCheckDataService LocationCheckDataService;

    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<DLocationCheckVo>> getList(DLocationCheckQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.LocationCheckService.getCheckList(param));
    }

    @GetMapping(value={"/getCheckDetail"})
    public ResponseData<DLocationCheck> getCheckDetail(Long checkId) {
        return ResponseData.success((Object)this.LocationCheckService.getCheckDetail(checkId));
    }

    @GetMapping(value={"/getResultList"})
    public ResponseData<LayuiGridData<DLocationCheckData>> getResultList(DLocationCheckDataQueryParam param) {
        return ResponseData.success(this.LocationCheckDataService.getCheckDataList(param));
    }

    @PostMapping(value={"/addLocationCheckByManual"})
    public ResponseData<String> addLocationCheckByManual(@RequestBody AddLocationCheckVo param) {
        this.LocationCheckService.addLocationCheckByManual(param);
        return ResponseData.success();
    }
}

