/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.d.IDDeviceCheckDataService;
import cn.smarthse.rho.modules.company.service.d.IDDeviceCheckService;
import cn.smarthse.rho.modules.sys.entity.d.DDeviceCheck;
import cn.smarthse.rho.modules.sys.entity.d.DDeviceCheckData;
import cn.smarthse.rho.modules.sys.model.d.param.DDeviceCheckDataQueryParam;
import cn.smarthse.rho.modules.sys.model.d.param.DDeviceCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.d.vo.AddDeviceCheckVo;
import cn.smarthse.rho.modules.sys.model.d.vo.DDeviceCheckVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/deviceCheck"})
public class DDeviceCheckController {
    @Autowired
    private IDDeviceCheckService deviceCheckService;
    @Autowired
    private IDDeviceCheckDataService deviceCheckDataService;

    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<DDeviceCheckVo>> getList(DDeviceCheckQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.deviceCheckService.getCheckList(param));
    }

    @GetMapping(value={"/getCheckDetail"})
    public ResponseData<DDeviceCheck> getCheckDetail(Long checkId) {
        return ResponseData.success((Object)this.deviceCheckService.getCheckDetail(checkId));
    }

    @GetMapping(value={"/getResultList"})
    public ResponseData<LayuiGridData<DDeviceCheckData>> getResultList(DDeviceCheckDataQueryParam param) {
        return ResponseData.success(this.deviceCheckDataService.getCheckDataList(param));
    }

    @PostMapping(value={"/addDeviceCheckByManual"})
    public ResponseData<String> addDeviceCheckByManual(@RequestBody AddDeviceCheckVo param) {
        this.deviceCheckService.addDeviceCheckByManual(param);
        return ResponseData.success();
    }
}

