/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.IdParam;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.model.c.param.CTrainingCertPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCertChooseListParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffChooseListPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingCertEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingRelationshipParam;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffCertChooseListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.sys.param.SysBusinessOperateLogParam;
import cn.smarthse.rho.modules.sys.provider.c.ITrainingCertProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/trainingCert"})
public class CTrainingCertController
extends ControllerSupport {
    @Autowired
    private ICTrainingCertService trainingCertService;
    @Autowired
    private ICStaffBaseInfoService cStaffBaseInfoService;
    @DubboReference
    private ISysBusinessOperateLogProvider operateLogProvider;
    @DubboReference
    private ITrainingCertProvider trainingCertProvider;

    @ApiEncrypt(request=true, response=true)
    @PostMapping(value={"/getList"})
    public ResponseData<LayuiGridData<CTrainingCert>> getList(@RequestBody CTrainingCertPageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.trainingCertService.getListForKeyFactor(param));
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getCheckDetail"})
    public ResponseData<CTrainingCert> getTrainingCertDetail(IdParam idParam) {
        return ResponseData.success((Object)this.trainingCertService.getTrainingCertDetailById(idParam.getId()));
    }

    @GetMapping(value={"/getChooseList"})
    public ResponseData<LayuiGridData<StaffChooseListVo>> getChooseList(StaffChooseListPageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        param.setIfRaManager(Integer.valueOf(0));
        param.setStaffType(Integer.valueOf(1));
        return ResponseData.success(this.cStaffBaseInfoService.getChooseList(param));
    }

    @RequestLimit(second=5, maxCount=1)
    @ApiEncrypt(request=true)
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_train, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u653e\u5c04\u536b\u751f\u57f9\u8bad-\u65b0\u589e\u6216\u7f16\u8f91\u8bc1\u4e66\uff08\u753b\u50cf\u5ba1\u6838\u63d0\u4ea4\uff09")
    @PostMapping(value={"/edit"})
    public ResponseData<String> addOrEditCert(@RequestBody @Validated TrainingCertEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        this.trainingCertService.addOrEditCert(param);
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_train, title="\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u653e\u5c04\u536b\u751f\u57f9\u8bad-\u8bc1\u4e66\u5173\u8054\u4eba\u5458")
    @PostMapping(value={"/addRelatedRelationships"})
    public ResponseData<String> addRelatedRelationships(@RequestBody TrainingRelationshipParam param) {
        this.trainingCertProvider.addRelatedRelationships(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/getStaffCertChooseList"})
    public ResponseData<LayuiGridData<StaffCertChooseListVo>> getStaffCertChooseList(StaffCertChooseListParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.trainingCertProvider.getStaffCertChooseList(param));
    }

    @PostMapping(value={"/revoke"})
    public ResponseData<String> revoke(@RequestBody IdParam param) {
        this.trainingCertService.revokeApplication(param.getId());
        return ResponseData.success();
    }

    @PostMapping(value={"/suspend"})
    public ResponseData<String> suspend(@RequestBody IdParam param) {
        this.trainingCertService.suspendApplication(param.getId());
        return ResponseData.success();
    }

    @PostMapping(value={"/del"})
    public ResponseData<String> del(@RequestBody IdParam param) {
        this.trainingCertService.delById(param.getId());
        return ResponseData.success();
    }

    @GetMapping(value={"/getOperateLogListData"})
    public ResponseData<LayuiGridData<SysBusinessOperateLog>> getOperateLogListData(SysBusinessOperateLogParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        param.setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_1.getValue());
        return ResponseData.success((Object)this.operateLogProvider.getPageListData(param));
    }
}

