/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheck;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.model.c.param.CHealthCheckQueryParam;
import cn.smarthse.rho.modules.sys.provider.c.ICHealthCheckDataProvider;
import cn.smarthse.rho.modules.sys.provider.c.ICHealthCheckProvider;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/healCheck"})
public class CHealthCheckController {
    @DubboReference
    private ICHealthCheckProvider healthCheckProvider;
    @DubboReference
    private ICHealthCheckDataProvider healthCheckDataProvider;

    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<CHealthCheck>> getList(CHealthCheckQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.healthCheckProvider.getList(param));
    }

    @GetMapping(value={"/getCheckDetail"})
    public ResponseData<CHealthCheck> getDetail(Long baseId) {
        return ResponseData.success((Object)this.healthCheckProvider.getDetailById(baseId));
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getResultList"})
    public ResponseData<LayuiGridData<CHealthCheckData>> getResultList(CHealthCheckQueryParam param) {
        return ResponseData.success((Object)this.healthCheckDataProvider.getResultList(param));
    }
}

