/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.keyFactor;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.entity.c.CDose;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.model.c.param.CDoseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CDoseBigStatisticsVo;
import cn.smarthse.rho.modules.sys.provider.c.ICDoseDataProvider;
import cn.smarthse.rho.modules.sys.provider.c.ICDoseProvider;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dose"})
public class CDoseController {
    @DubboReference
    private ICDoseProvider doseProvider;
    @DubboReference
    private ICDoseDataProvider doseDataProvider;

    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<CDose>> getList(CDoseQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)new LayuiGridData(this.doseProvider.getMonitorList(param)));
    }

    @GetMapping(value={"/getCheckDetail"})
    public ResponseData<CDose> getCheckDetail(Long baseId) {
        return ResponseData.success((Object)this.doseProvider.getMonitorDetail(baseId));
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_keyFactor_dose_monitor)
    @PostMapping(value={"/edit"})
    public ResponseData<String> edit(CDoseData param) {
        return this.doseDataProvider.updateById(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getResultList"})
    public ResponseData<LayuiGridData<CDoseData>> getResultList(CDoseQueryParam param) {
        return ResponseData.success((Object)new LayuiGridData(this.doseDataProvider.getDoseDataList(param)));
    }

    @GetMapping(value={"/getBigDoseStatisticsData"})
    public ResponseData<CDoseBigStatisticsVo> getBigDoseStatisticsData() {
        return ResponseData.success((Object)this.doseDataProvider.getBigDoseStatisticsData(ShiroUtil.getLoginUserCid()));
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getOverDoseList"})
    public ResponseData<LayuiGridData<CDoseData>> getOverDoseList(CDoseQueryParam param) {
        return ResponseData.success((Object)new LayuiGridData(this.doseDataProvider.getOverDoseDataList(param)));
    }
}

