/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.common;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.model.sys.param.SysSettingTableEditParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysSettingTableVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysSettingTableProvider;
import jakarta.validation.constraints.NotEmpty;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/settingTable"})
@Validated
public class SysSettingTableController
extends ControllerSupport {
    @DubboReference
    private ISysSettingTableProvider sysSettingTableProvider;

    @GetMapping(value={"/getSettingTable"})
    public ResponseData<SysSettingTableVo> getSettingTable(@NotEmpty String tableCode) {
        return ResponseData.success((Object)this.sysSettingTableProvider.getSettingTable(ShiroUtil.getJWTUserId(), tableCode));
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_setting_table, title="\u4fdd\u5b58")
    @PostMapping(value={"/saveSettingTable"})
    public ResponseData<String> saveSettingTable(@RequestBody @Validated SysSettingTableEditParam param) {
        this.sysSettingTableProvider.saveSettingTable(param);
        return ResponseData.success();
    }

    @Generated
    public SysSettingTableController() {
    }
}

