/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.common;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.crypto.digest.MD5;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.entity.sys.SysFile;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import cn.smarthse.rho.modules.sys.utils.file.FileXxsUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/common/file"})
public class FileUploadController
extends ControllerSupport {
    @DubboReference
    private ISysFileProvider sysFileProvideService;
    private final OssClientBean ossClientBean;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private final SysProperties sysProperties;

    @Log(title="\u4e0a\u4f20\u9644\u4ef6", type=LogTypeEnum.type_opt_upload)
    @ResponseBody
    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseData<SysFileVo> upload(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) throws IOException {
        String type = FileTypeUtil.getType((InputStream)fileData.getInputStream(), (boolean)true);
        if (!this.sysProperties.getSupportFileTypes().contains(type)) {
            return ResponseData.fail((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff01");
        }
        long size = fileData.getSize();
        String hashCode = MD5.create().digestHex(fileData.getBytes());
        SysFileVo existSysFile = this.sysFileProvideService.getFileByHash(hashCode);
        if (existSysFile != null) {
            return new ResponseData("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f(hash\u503c\u5b58\u5728)\uff01", (Object)existSysFile);
        }
        String originalFilename = FileXxsUtil.excludeXxsFileName((String)fileData.getOriginalFilename());
        String uploadFile = UploadFileParameter.FILE_PATH + FileResourceEnum.rho_supervise.getCode() + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator + String.valueOf(UUID.randomUUID()) + "-" + originalFilename;
        String res = this.ossClientBean.OSSPutObject(uploadFile, originalFilename, fileData.getInputStream());
        SysFile file = new SysFile();
        file.setCid(ShiroUtil.getLoginUserCid());
        file.setResource(Integer.valueOf(FileResourceEnum.rho_supervise.getValue()));
        file.setFileName(originalFilename);
        file.setFileSize(Long.valueOf(size));
        file.setFileExt(FileUtil.getSuffix((String)originalFilename));
        file.setFileHash(hashCode);
        file.setCreatorIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        file.setOssUrl(res);
        SysFileVo result = this.sysFileProvideService.addSysFile(file, ShiroUtil.getJWTUserId());
        return new ResponseData("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01", (Object)result);
    }

    @ResponseBody
    @RequestMapping(value={"postSignature"}, method={RequestMethod.GET})
    public Map<String, String> postSignature() throws Exception {
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.rho_company.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.Common.getPath();
        return this.ossClientBean.getPostSignature(uploadDir);
    }

    @ResponseBody
    @RequestMapping(value={"check/{filehash}"}, method={RequestMethod.POST})
    public ResponseData<SysFileVo> checkfilemd5(@PathVariable(value="filehash") String filehash) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011->\u3010\u9a8c\u8bc1{}\u3011", (Object)filehash);
        SysFileVo record = this.sysFileProvideService.getFileByHash(filehash);
        ResponseData data = new ResponseData();
        if (record != null) {
            data.setResult((Object)record);
            data.setState(ResponseStateEnum.success.getValue());
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
        }
        return data;
    }

    @RequestMapping(value={"getFileUrl"}, method={RequestMethod.POST})
    public ResponseData<String> getFileUrl(Long fileId) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6oss\u5730\u5740, fileId={}", (Object)fileId);
        ResponseData data = new ResponseData();
        if (fileId == null) {
            data.setResult((Object)"");
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        String fileUrl = this.sysFileProvideService.getFileUrl(fileId);
        if (fileUrl != null) {
            data.setResult((Object)fileUrl);
            data.setMessage("\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6oss\u5730\u5740\u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @RequestMapping(value={"getFile"}, method={RequestMethod.POST})
    public ResponseData<SysFileVo> getFile(Long fileId) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61, fileId={}", (Object)fileId);
        ResponseData data = new ResponseData();
        if (fileId == null) {
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        SysFileVo file = this.sysFileProvideService.getFileById(fileId);
        if (file != null) {
            data.setResult((Object)file);
            data.setMessage("\u901a\u8fc7id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61\u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @RequestMapping(value={"getFileList"}, method={RequestMethod.POST})
    public ResponseData<List<SysFileVo>> getFileList(String fileIds) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61\u96c6\u5408, fileIds={}", (Object)fileIds);
        ResponseData data = new ResponseData();
        if (StringUtils.isEmpty((CharSequence)fileIds)) {
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        List list = this.sysFileProvideService.getFileVoByIds(fileIds);
        if (list != null && !list.isEmpty()) {
            data.setResult((Object)list);
            data.setMessage("\u901a\u8fc7id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61 \u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @Generated
    public FileUploadController(OssClientBean ossClientBean, ThreadPoolTaskExecutor threadPoolTaskExecutor, SysProperties sysProperties) {
        this.ossClientBean = ossClientBean;
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.sysProperties = sysProperties;
    }
}

