/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.common;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.PageParam;
import cn.smarthse.rho.core.framework.mybatis.SysChangeLog;
import cn.smarthse.rho.modules.sys.model.sys.param.SysParamQueryParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo2;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamTypeVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysCommonProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysParamProvider;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common"})
public class CommonController
extends ControllerSupport {
    @DubboReference
    private ISysAreaProvider sysAreaProvider;
    @DubboReference
    private ISysParamProvider sysParamProvider;
    @DubboReference
    private ISysCommonProvider sysCommonProvider;

    @RequestLimit(maxCount=5, expression="#id")
    @GetMapping(value={"/area/getAreaById"})
    public ResponseData<SysAreaVo> getAreaById(@NotNull Long id) {
        return ResponseData.success((Object)this.sysAreaProvider.getAreaById(id));
    }

    @GetMapping(value={"/area/getAreaV2"})
    public ResponseData<SysAreaVo2> getAreaV2(@NotNull Long id) {
        return ResponseData.success((Object)this.sysAreaProvider.getAreaByIdV2(id));
    }

    @GetMapping(value={"/area/getAreaList"})
    public ResponseData<List<SysAreaVo>> getAreaList(@NotNull Long parentId) {
        return ResponseData.success((Object)this.sysAreaProvider.getAreaList(parentId));
    }

    @RequestLimit(maxCount=5, expression="#param.page")
    @GetMapping(value={"/param/getParamTypeList"})
    public ResponseData<List<SysParamTypeVo>> getParamTypeList(PageParam param) {
        return ResponseData.success((Object)this.sysParamProvider.getParamTypeList(param));
    }

    @RequestLimit(maxCount=5, expression="#type")
    @GetMapping(value={"/param/getParamList"})
    public ResponseData<List<SysParamVo>> getParamList(@NotNull Long type) {
        return ResponseData.success((Object)this.sysParamProvider.getList(type));
    }

    @RequestLimit(maxCount=5, expression="#type")
    @GetMapping(value={"/param/getParamPageList"})
    public ResponseData<LayuiGridData<SysParamVo>> getPageList(SysParamQueryParam param) {
        return ResponseData.success((Object)this.sysParamProvider.getPageList(param));
    }

    @GetMapping(value={"/param/getChangeLogList"})
    public ResponseData<List<SysChangeLog>> getChangeLogList(@NotNull Long dataId, @NotEmpty String tableName, String fieldValue) {
        return ResponseData.success((Object)this.sysCommonProvider.getChangeLogList(dataId, tableName, fieldValue));
    }

    @GetMapping(value={"/param/getMultiFieldChangeLogList"})
    public ResponseData<List<SysChangeLog>> getMultiFieldChangeLogList(@NotNull Long dataId, @NotEmpty String tableName, String fieldValues) {
        List split = null;
        if (StrUtil.isNotEmpty((CharSequence)fieldValues)) {
            split = StrUtil.split((CharSequence)fieldValues, (CharSequence)",");
        }
        return ResponseData.success((Object)this.sysCommonProvider.getMultiFieldChangeLogList(dataId, tableName, split));
    }

    @Generated
    public CommonController() {
    }
}

