/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.cert;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.model.c.vo.rayCert.RayCertAfterGenVo;
import cn.smarthse.rho.modules.sys.provider.c.IRayCertProvider;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rc"})
public class RayCertController
extends ControllerSupport {
    @Autowired
    private ICStaffBaseInfoService staffBaseInfoService;
    @DubboReference
    private IRayCertProvider rayCertProvider;

    @GetMapping(value={"/cert"})
    @Log(type=LogTypeEnum.type_opt_ac_info, logModule=LogModuleTypeEnum.com_base_staff, title="\u673a\u6784\u7aef-\u8bc1\u4e66\u67e5\u770b")
    @ApiEncrypt(request=false, response=true)
    public ResponseData<RayCertAfterGenVo> getBaseInfo(Long sbId) {
        this.checkView(sbId);
        return ResponseData.success((Object)this.rayCertProvider.getAfterGenInfoBySbId(sbId));
    }

    private void checkView(Long sbId) {
        if (sbId == null) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b");
        }
        List<Long> cidListForView = this.staffBaseInfoService.getCidListForView(sbId);
        if (CollUtil.isNotEmpty(cidListForView) && cidListForView.contains(ShiroUtil.getLoginUserCid())) {
            return;
        }
        throw new ServiceException("\u65e0\u6743\u67e5\u770b!");
    }

    @Generated
    public RayCertController() {
    }
}

