/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.IdsParam;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffWorkExperienceEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.wordExperience.StaffWorkExperienceRecordPageParam;
import cn.smarthse.rho.modules.sys.model.c.vo.experience.StaffWorkExperienceRecordVo;
import cn.smarthse.rho.modules.sys.provider.c.IWorkExperienceProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/staffWorkExperience"})
public class StaffWorkExperienceController
extends ControllerSupport {
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffWorkExperienceService staffWorkExperienceService;
    @DubboReference
    private IWorkExperienceProvider workExperienceProvider;

    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_staff, title="\u6dfb\u52a0\u7ecf\u5386\u5217\u8868")
    @RequestLimit(second=5, maxCount=5)
    @PostMapping(value={"/add"})
    public ResponseData add(@RequestBody CStaffWorkExperienceEditParam param) {
        this.checkCidRange(param.getStaffBaseInfoId());
        param.setCid(ShiroUtil.getLoginUserCid());
        this.workExperienceProvider.add(param);
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_staff, title="\u7f16\u8f91\u7ecf\u5386\u5217\u8868")
    @PostMapping(value={"/edit"})
    @RequestLimit(second=5, maxCount=5)
    public ResponseData edit(@RequestBody CStaffWorkExperienceEditParam param) {
        CStaffWorkExperience workExperience = (CStaffWorkExperience)this.staffWorkExperienceService.getById(param.getId());
        this.checkCidRange(workExperience.getStaffBaseInfoId());
        this.workExperienceProvider.edit(param);
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_staff, title="\u7f16\u8f91\u7ecf\u5386\u5217\u8868-\u5220\u9664")
    @PostMapping(value={"/remove"})
    public ResponseData<String> remove(@RequestBody IdsParam param) {
        if (CollUtil.isNotEmpty((Collection)param.getIdList())) {
            CStaffWorkExperience workExperience = (CStaffWorkExperience)this.staffWorkExperienceService.getById((Serializable)param.getIdList().get(0));
            this.checkCidRange(workExperience.getStaffBaseInfoId());
        }
        this.workExperienceProvider.delete(param.getIdList());
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_staff, title="\u7f16\u8f91\u7ecf\u5386\u5217\u8868-\u5220\u9664")
    @GetMapping(value={"/record"})
    public ResponseData<LayuiGridData<StaffWorkExperienceRecordVo>> record(StaffWorkExperienceRecordPageParam param) {
        return ResponseData.success((Object)this.workExperienceProvider.getRecordList(param));
    }

    private void checkCidRange(Long staffBaseInfoId) {
        Long cid = ShiroUtil.getLoginUserCid();
        List<Long> cidList = this.staffBaseInfoService.getCidList(staffBaseInfoId);
        if (!CollUtil.contains(cidList, (Object)cid)) {
            throw new ServiceException("\u975e\u672c\u9662\u533a\u5458\u5de5\u4fe1\u606f\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Generated
    public StaffWorkExperienceController(ICStaffBaseInfoService staffBaseInfoService, ICStaffWorkExperienceService staffWorkExperienceService) {
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffWorkExperienceService = staffWorkExperienceService;
    }
}

