/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.easyexcel.StaffRelocationImportListener;
import cn.smarthse.rho.modules.sys.model.c.param.staff.relocation.StaffRelocateBatchParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.relocation.StaffRelocateLogQueryParam;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.StaffRelocationImportResultVo;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.StaffRelocationLogVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.staff.StaffRelocationImportDto;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.c.IStaffProvider;
import cn.smarthse.rho.modules.sys.provider.c.IStaffRelocationProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/move"})
public class StaffRelocationController
extends ControllerSupport {
    private final OssClientBean ossClientBean;
    @DubboReference
    private IStaffRelocationProvider staffRelocationProvider;
    @DubboReference
    private ISysFileProvider sysFileProvideService;
    @DubboReference
    private IStaffProvider staffProvider;

    @PostMapping(value={"/rl"})
    public ResponseData relocation(@RequestBody StaffRelocateBatchParam param) {
        param.getList().forEach(item -> item.setBeCid(ShiroUtil.getLoginUserCid()));
        this.staffRelocationProvider.relocate(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/l"})
    @ApiEncrypt(request=true)
    public ResponseData<LayuiGridData<StaffRelocationLogVo>> getStaffRelocationLogList(@RequestBody StaffRelocateLogQueryParam param) {
        param.setBeCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.staffRelocationProvider.getStaffRelocationLogList(param));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/import"})
    @Log(type=LogTypeEnum.type_opt_upload, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u8fc1\u79fb\u5bfc\u5165")
    public ResponseData<List<StaffRelocationImportResultVo>> importByCompany(Long fileId) {
        if (fileId == null) {
            throw new ServiceException("\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFileVo file = this.sysFileProvideService.getFileById(fileId);
        if (Objects.isNull(file)) {
            throw new ServiceException("\u6587\u4ef6\u7f3a\u5931");
        }
        ArrayList<StaffRelocationImportResultVo> resultInfo = null;
        try (InputStream inputStream = this.ossClientBean.getInputStreamByUrl(file.getFullOssUrl());){
            ResponseData responseData;
            block17: {
                ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();
                try {
                    resultInfo = new ArrayList<StaffRelocationImportResultVo>();
                    excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).headRowNumber(Integer.valueOf(1))).head(StaffRelocationImportDto.class)).registerReadListener((ReadListener)new StaffRelocationImportListener(this.staffRelocationProvider, resultInfo))).build()});
                    responseData = ResponseData.success(resultInfo);
                    if (excelReader == null) break block17;
                }
                catch (Throwable throwable) {
                    if (excelReader != null) {
                        try {
                            excelReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                excelReader.close();
            }
            return responseData;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (IOException e) {
            this.logger.error("\u4eba\u5458\u8fc1\u79fb\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5bfc\u5165\u5931\u8d25");
        }
    }

    @Generated
    public StaffRelocationController(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

