/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.annotation.SysExportLog;
import cn.smarthse.rho.core.framework.annotation.SysExportLogBusinessTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBOrgService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICStaffService;
import cn.smarthse.rho.modules.company.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoRangeVo;
import cn.smarthse.rho.modules.sys.model.c.param.CDoseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CHealthCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffBaseInfoEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffDeleteParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffInfoRangeParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffWorkExperiencePageParam;
import cn.smarthse.rho.modules.sys.model.c.param.CTrainingCertPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffChangeLogParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffChooseListPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCmPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffSelectInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffStatisticsParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.CheckNameParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.StaffPostEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.relocation.StaffRelocationExportParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CDoseDataVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CStaffWorkExperienceVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CertConditionVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CompanyStaffArchiveStatisticsVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveStatisticsCMVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChangeLogVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffSelectInfo;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.StaffRelocationExportVo;
import cn.smarthse.rho.modules.sys.provider.c.ICDoseDataProvider;
import cn.smarthse.rho.modules.sys.provider.c.ICHealthCheckDataProvider;
import cn.smarthse.rho.modules.sys.provider.c.IRayCertProvider;
import cn.smarthse.rho.modules.sys.provider.c.IStaffProvider;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/staff"})
public class StaffInfoController
extends ControllerSupport {
    private final ICStaffBaseInfoService cStaffBaseInfoService;
    private final ICStaffService cStaffService;
    private final ICStaffWorkExperienceService cStaffWorkExperienceService;
    private final ICTrainingCertService cTrainingCertService;
    private final IBCompanyService companyService;
    private final IBOrgService orgService;
    @DubboReference
    private IStaffProvider staffProvider;
    @DubboReference
    private ICHealthCheckDataProvider healthCheckDataService;
    @DubboReference
    private ICDoseDataProvider doseDataProvider;
    @DubboReference
    private IRayCertProvider rayCertProvider;

    @ApiEncrypt(request=true)
    @PostMapping(value={"/getStaffArchiveList"})
    public ResponseData<LayuiGridData<StaffArchiveListVo>> getStaffArchiveList(@RequestBody StaffCmPageParam param) {
        param.setCidList(Arrays.asList(ShiroUtil.getLoginUserCid()));
        LayuiGridData<StaffArchiveListVo> result = this.cStaffBaseInfoService.getStaffArchiveList(param);
        for (StaffArchiveListVo vo : result.getData()) {
            vo.genSexAndAge();
        }
        return ResponseData.success(result);
    }

    @PostMapping(value={"/export/rl"})
    @Log(type=LogTypeEnum.type_opt_ac_info, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u8fc1\u79fb\u5bfc\u51fa")
    @SysExportLog(businessType=SysExportLogBusinessTypeEnum.TYPE_2)
    public void exportRlInfo(@RequestBody StaffRelocationExportParam param, HttpServletResponse response) throws IOException {
        throw new ServiceException("\u6a21\u677f\u4e0b\u8f7d\u529f\u80fd\u505c\u7528");
    }

    private List<StaffRelocationExportVo> list2ExportData(List<StaffArchiveListVo> list) {
        List<StaffRelocationExportVo> result = list.stream().map(vo -> {
            StaffRelocationExportVo exportVo = new StaffRelocationExportVo();
            exportVo.setName(vo.getName());
            exportVo.setIdcard(vo.getIdcard());
            exportVo.setBeCompanyName(ShiroUtil.getLoginUserCompanyName());
            return exportVo;
        }).toList();
        return result;
    }

    @GetMapping(value={"/getPostStaffArchiveList"})
    public ResponseData<LayuiGridData<StaffArchiveListVo>> getPostStaffArchiveList(StaffCmPageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        LayuiGridData<StaffArchiveListVo> result = this.cStaffBaseInfoService.getPostStaffArchiveList(param);
        for (StaffArchiveListVo vo : result.getData()) {
            vo.genAll();
        }
        return ResponseData.success(result);
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getChooseList"})
    @Log(type=LogTypeEnum.type_opt_ac_info, logModule=LogModuleTypeEnum.com_base_staff, title="\u83b7\u53d6\u4eba\u5458\u9009\u62e9\u5217\u8868")
    public ResponseData<LayuiGridData<StaffChooseListVo>> getChooseList(StaffChooseListPageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.cStaffBaseInfoService.getChooseList(param));
    }

    @ApiEncrypt(request=true)
    @PostMapping(value={"/edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u7f16\u8f91")
    public ResponseData edit(@RequestBody CStaffBaseInfoEditParam param) {
        this.checkCidRange(param.getId());
        if (param.getStaffEditParam() != null) {
            this.checkStaffEdit(param.getStaffEditParam().getId());
        }
        this.staffProvider.editStaffFullInfo(param);
        return ResponseData.success();
    }

    @ApiEncrypt(request=true)
    @PostMapping(value={"/add"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u65b0\u589e")
    public ResponseData add(@RequestBody CStaffBaseInfoEditParam param) {
        param.setSource(StaffSourceEnum.UNIT.getValue());
        param.setAddApiSource(Integer.valueOf(1));
        if (param.getStaffEditParam() != null) {
            param.getStaffEditParam().setCid(ShiroUtil.getLoginUserCid());
        }
        if (param.getStaffEditParam() != null) {
            param.getStaffEditParam().setSource(StaffSourceEnum.UNIT.getValue());
        }
        this.staffProvider.addStaffFullInfo(param);
        return ResponseData.success();
    }

    @ApiEncrypt(request=true)
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_staff, title="\u65b0\u589e\u7ba1\u7406\u5458")
    @PostMapping(value={"/add/manager"})
    public ResponseData addManager(@RequestBody CStaffBaseInfoEditParam param) {
        param.getStaffEditParam().setCid(ShiroUtil.getLoginUserCid());
        this.staffProvider.addManager(param);
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_staff, title="\u6821\u9a8c\u540d\u5b57\u662f\u5426\u51b2\u7a81")
    @ApiEncrypt(request=true)
    @PostMapping(value={"/add/manager/check"})
    public ResponseData<Integer> addManager(@RequestBody CheckNameParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.staffProvider.checkName(param));
    }

    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u57fa\u7840\u4fe1\u606f\u5220\u9664")
    @PostMapping(value={"/delete"})
    public ResponseData delete(@RequestBody CStaffDeleteParam param) {
        this.checkCidRange(param.getStaffBaseInfoId());
        this.checkStaffEdit(param.getStaffId());
        this.staffProvider.deleteStaff(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/getBaseInfo"})
    public ResponseData<StaffArchiveListVo> getBaseInfo(StaffInfoParam param) {
        this.dealCidForView(param);
        this.checkCidRangeForView(param.getId());
        StaffArchiveListVo result = this.cStaffBaseInfoService.getInfo(param);
        result.genSexAndAge();
        return ResponseData.success((Object)result);
    }

    private void dealCidForView(StaffInfoParam param) {
        List<Long> cidListForView = this.cStaffBaseInfoService.getCidListForView(param.getId());
        if (CollUtil.isNotEmpty(cidListForView)) {
            if (cidListForView.contains(ShiroUtil.getLoginUserCid())) {
                param.setCid(ShiroUtil.getLoginUserCid());
            } else {
                param.setCid(this.cStaffBaseInfoService.getStaffCid(param.getId(), ShiroUtil.getLoginUserCid()));
            }
        } else {
            throw new ServiceException("\u8be5\u4eba\u5458\u975e\u672c\u533b\u9662\u5458\u5de5\uff0c\u65e0\u6cd5\u67e5\u770b!");
        }
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getBaseInfo/rayManager"})
    public ResponseData<StaffArchiveListVo> getRayManagerInfo(StaffInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        StaffArchiveListVo result = this.cStaffBaseInfoService.getRayManagerInfo(param);
        result.genAll();
        return ResponseData.success((Object)result);
    }

    @PostMapping(value={"/getSelectInfo"})
    @Log(type=LogTypeEnum.anon, logModule=LogModuleTypeEnum.com_base_staff, title="\u9009\u62e9\u4eba\u5458\u4fe1\u606f\uff08\u5355\u4e2a\uff09")
    @RequestLimit(second=10, maxCount=5, msg="\u8bf7\u52ff\u9891\u7e41\u64cd\u4f5c", expression="#param.cid")
    @ApiEncrypt(response=true, request=true)
    public ResponseData<StaffSelectInfo> getSelectInfoForAdding(@RequestBody StaffSelectInfoParam param) {
        return ResponseData.success((Object)this.staffProvider.getSelectInfoForAdding(param));
    }

    @GetMapping(value={"/getStaffArchiveStatistics"})
    public ResponseData<StaffArchiveStatisticsCMVo> getStaffArchiveStatistics(StaffStatisticsParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        if (param.getCid() == null) {
            throw new ServiceException("\u8be5\u4eba\u5458\u975e\u672c\u533b\u9662\u5458\u5de5\uff0c\u65e0\u6cd5\u67e5\u770b");
        }
        return ResponseData.success((Object)this.cStaffBaseInfoService.getStaffArchiveStatistics(param));
    }

    @GetMapping(value={"/getCMStaffArchiveStatistics"})
    public ResponseData<CompanyStaffArchiveStatisticsVo> getCMStaffArchiveStatistics(StaffStatisticsParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.cStaffBaseInfoService.getCMStaffArchiveStatistics(param));
    }

    @GetMapping(value={"/getCertCondition"})
    public ResponseData<CertConditionVo> getCertCondition(Long staffBaseInfoId) {
        return ResponseData.success((Object)this.rayCertProvider.getCertCondition(staffBaseInfoId));
    }

    @GetMapping(value={"/getList/health"})
    public ResponseData<LayuiGridData<CHealthCheckData>> getHealthList(CHealthCheckQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        CStaffInfoRangeVo rangeVo = this.staffProvider.getStaffInfoRangeForCompany(new CStaffInfoRangeParam().setStaffBaseInfoId(param.getStaffBaseInfoId()).setCid(param.getCid()));
        if (rangeVo == null) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b\u6570\u636e");
        }
        param.setOnlyHistoryStaffInfo(rangeVo.getOnlyHistoryStaffInfo());
        param.setNewestPostDepartureTime(rangeVo.getNewestPostDepartureTime());
        return ResponseData.success((Object)this.healthCheckDataService.getListForArchive(param));
    }

    @GetMapping(value={"/getList/dose"})
    public ResponseData<LayuiGridData<CDoseDataVo>> getDoseList(CDoseQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        CStaffInfoRangeVo rangeVo = this.staffProvider.getStaffInfoRangeForCompany(new CStaffInfoRangeParam().setStaffBaseInfoId(param.getStaffBaseInfoId()).setCid(param.getCid()));
        if (rangeVo == null) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b\u6570\u636e");
        }
        param.setOnlyHistoryStaffInfo(rangeVo.getOnlyHistoryStaffInfo());
        param.setNewestPostDepartureTime(rangeVo.getNewestPostDepartureTime());
        return ResponseData.success((Object)new LayuiGridData(this.doseDataProvider.getDoseListForArchive(param)));
    }

    @GetMapping(value={"/getList/workExperience"})
    public ResponseData<LayuiGridData<CStaffWorkExperienceVo>> getWorkExperienceList(CStaffWorkExperiencePageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.cStaffWorkExperienceService.getListForArchive(param));
    }

    @GetMapping(value={"/getList/getCertList"})
    public ResponseData<LayuiGridData<CTrainingCert>> getCertList(CTrainingCertPageParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        CStaffInfoRangeVo rangeVo = this.staffProvider.getStaffInfoRangeForCompany(new CStaffInfoRangeParam().setStaffBaseInfoId(param.getStaffBaseInfoId()).setCid(param.getCid()));
        if (rangeVo == null) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b\u6570\u636e");
        }
        param.setOnlyHistoryStaffInfo(rangeVo.getOnlyHistoryStaffInfo());
        param.setNewestPostDepartureTime(rangeVo.getNewestPostDepartureTime());
        return ResponseData.success(this.cTrainingCertService.getListForArchive(param));
    }

    @GetMapping(value={"/staffChangeLoge"})
    public ResponseData<LayuiGridData<StaffChangeLogVo>> getStaffChangeLog(StaffChangeLogParam param) {
        if (StrUtil.isEmpty((CharSequence)param.getFieldValuesStr())) {
            String fieldValues = "name,phone,idcard,sex,age,birthday,head_id,ra_type,cid,org_id,work_no,post,post_status,if_ra_manager,staff_type";
            param.setFieldValuesStr(fieldValues);
        }
        LayuiGridData staffChangeLog = this.staffProvider.getStaffChangeLog(param);
        return ResponseData.success((Object)staffChangeLog);
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\u5355\u4f4d\u4fe1\u606f\u7f16\u8f91")
    @PostMapping(value={"/edit/company"})
    public ResponseData editCompanyInfo(@RequestBody CStaffEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        CStaff db = (CStaff)this.cStaffService.getById(param.getId());
        if (db == null) {
            throw new ServiceException("\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.checkCidRange(db.getBaseId());
        this.checkStaffEdit(param.getId());
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        this.staffProvider.editStaffInfo(param);
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_staff, title="\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u5c97\u4f4d\u72b6\u6001\u4fee\u6539")
    @PostMapping(value={"/edit/rps"})
    public ResponseData editRayPostType(@RequestBody StaffPostEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        CStaff db = (CStaff)this.cStaffService.getById(param.getStaffId());
        if (db == null) {
            throw new ServiceException("\u65e0\u6743\u7f16\u8f91");
        }
        if (!db.getCid().equals(ShiroUtil.getLoginUserCid())) {
            throw new ServiceException("\u65e0\u6743\u7f16\u8f91");
        }
        this.staffProvider.editRayPostType(param);
        return ResponseData.success();
    }

    private void checkCidRange(Long staffBaseInfoId) {
        Long cid = ShiroUtil.getLoginUserCid();
        List<Long> cidList = this.cStaffBaseInfoService.getCidList(staffBaseInfoId);
        if (!CollUtil.contains(cidList, (Object)cid)) {
            throw new ServiceException("\u975e\u672c\u9662\u533a\u5458\u5de5\u4fe1\u606f\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
    }

    private void checkStaffEdit(Long staffId) {
        if (staffId == null) {
            throw new ServiceException("\u5173\u8054\u6570\u636e\u4f20\u9012\u9519\u8bef");
        }
        CStaff staff = (CStaff)this.cStaffService.getById(staffId);
        if (staff == null) {
            throw new ServiceException("\u9662\u533a\u5173\u8054\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (staff != null && !staff.getCid().equals(ShiroUtil.getLoginUserCid())) {
            throw new ServiceException("\u9662\u533a\u5173\u8054\u6570\u636e\u4f20\u9012\u9519\u8bef");
        }
    }

    private void checkCidRangeForView(Long staffBaseInfoId) {
        Long cid = ShiroUtil.getLoginUserCid();
        List<Long> cidList = this.cStaffBaseInfoService.getCidListForCheckRange(staffBaseInfoId);
        if (!CollUtil.contains(cidList, (Object)cid)) {
            throw new ServiceException("\u975e\u672c\u9662\u533a\u5458\u5de5\u4fe1\u606f\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Generated
    public StaffInfoController(ICStaffBaseInfoService cStaffBaseInfoService, ICStaffService cStaffService, ICStaffWorkExperienceService cStaffWorkExperienceService, ICTrainingCertService cTrainingCertService, IBCompanyService companyService, IBOrgService orgService) {
        this.cStaffBaseInfoService = cStaffBaseInfoService;
        this.cStaffService = cStaffService;
        this.cStaffWorkExperienceService = cStaffWorkExperienceService;
        this.cTrainingCertService = cTrainingCertService;
        this.companyService = companyService;
        this.orgService = orgService;
    }
}

