/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.modules.company.easyexcel.StaffImportListenerV2;
import cn.smarthse.rho.modules.sys.model.easyexcel.StaffImportDtoV2;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.c.IStaffProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/staffImport/v2"})
@Validated
public class StaffImportControllerV2
extends ControllerSupport {
    private final OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvider sysFileProvideService;
    @DubboReference
    private IStaffProvider staffProvider;

    /*
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/import/cm"})
    @Log(type=LogTypeEnum.type_opt_upload, logModule=LogModuleTypeEnum.com_base_staff, title="\u4eba\u5458\uff1a\u4fe1\u606f\u5bfc\u5165-\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4fe1\u606f\u5bfc\u5165")
    public ResponseData<String> importByCompany(Long fileId) {
        if (fileId == null) {
            throw new ServiceException("\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFileVo file = this.sysFileProvideService.getFileById(fileId);
        if (Objects.isNull(file)) {
            throw new ServiceException("\u6587\u4ef6\u7f3a\u5931");
        }
        ArrayList<String> resultInfo = null;
        try (InputStream inputStream = this.ossClientBean.getInputStreamByUrl(file.getFullOssUrl());){
            ResponseData responseData;
            block17: {
                ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();
                try {
                    resultInfo = new ArrayList<String>();
                    excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((String)"\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4fe1\u606f").headRowNumber(Integer.valueOf(3))).head(StaffImportDtoV2.class)).registerReadListener((ReadListener)new StaffImportListenerV2(this.staffProvider, resultInfo))).build()});
                    ResponseData responseData2 = responseData = CollUtil.isEmpty(resultInfo) ? ResponseData.success((String)"\u5bfc\u5165\u6210\u529f") : ResponseData.fail((String)"\u90e8\u5206\u5bfc\u5165\u5931\u8d25", (Object)((String)resultInfo.get(0)));
                    if (excelReader == null) break block17;
                }
                catch (Throwable throwable) {
                    if (excelReader != null) {
                        try {
                            excelReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                excelReader.close();
            }
            return responseData;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (IOException e) {
            this.logger.error("\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5bfc\u5165\u5931\u8d25");
        }
    }

    @Generated
    public StaffImportControllerV2(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

