/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.model.c.param.staffErr.StaffErrInfoParam;
import cn.smarthse.rho.modules.sys.model.c.vo.staffErr.StaffErrVo;
import cn.smarthse.rho.modules.sys.provider.c.IStaffErrInfoProvider;
import java.util.Collections;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/err/staff"})
public class StaffErrInfoController
extends ControllerSupport {
    private final ICStaffBaseInfoService cStaffBaseInfoService;
    @DubboReference
    private IStaffErrInfoProvider staffErrInfoProvider;

    @GetMapping(value={"/getStaffWarningInfo"})
    public ResponseData<List<StaffErrVo>> getStaffArchiveList(StaffErrInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        this.checkCidRangeForView(param.getStaffBaseInfoId());
        StaffErrVo result = this.staffErrInfoProvider.getOneCompanyStaffErrInfo(param);
        return ResponseData.success(Collections.singletonList(result));
    }

    private void checkCidRangeForView(Long staffBaseInfoId) {
        if (staffBaseInfoId == null) {
            throw new ServiceException("\u65e0\u6cd5\u83b7\u53d6,\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        Long cid = ShiroUtil.getLoginUserCid();
        List<Long> cidList = this.cStaffBaseInfoService.getCidListForCheckRange(staffBaseInfoId);
        if (!CollUtil.contains(cidList, (Object)cid)) {
            throw new ServiceException("\u975e\u672c\u9662\u533a\u5458\u5de5\u4fe1\u606f\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Generated
    public StaffErrInfoController(ICStaffBaseInfoService cStaffBaseInfoService) {
        this.cStaffBaseInfoService = cStaffBaseInfoService;
    }
}

