/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBRayManageService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.model.b.param.BRayManageEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BRayManageInfoParam;
import cn.smarthse.rho.modules.sys.model.b.param.RayStaffQueryParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BRayManageVo;
import cn.smarthse.rho.modules.sys.model.c.vo.RayStaffListVo;
import cn.smarthse.rho.modules.sys.provider.company.IRayManagerProvider;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rayGroup"})
public class RayGroupManageController {
    private final IBRayManageService bRayManageService;
    private final ICStaffBaseInfoService cStaffBaseInfoService;
    @DubboReference
    private IRayManagerProvider rayManagerProvider;

    @GetMapping(value={"/getInfo"})
    public ResponseData<BRayManageVo> getInfo(BRayManageInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.bRayManageService.getInfo(param));
    }

    @PostMapping(value={"/addInfo"})
    @RequestLimit(second=1, maxCount=1, expression="#param.cid", msg="\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4, \u8bf7\u5237\u65b0\u9875\u9762\u540e\u8bf7\u91cd\u8bd5")
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_ray_manage, title="\u533b\u9662\uff1a\u653e\u5c04\u9632\u62a4\u7ba1\u7406\u9886\u5bfc\u5c0f\u7ec4-\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u4fe1\u606f")
    public ResponseData<BRayManageVo> addInfo(@RequestBody BRayManageEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        return ResponseData.success((Object)this.rayManagerProvider.add(param));
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_ray_manage, title="\u533b\u9662\uff1a\u653e\u5c04\u9632\u62a4\u7ba1\u7406\u9886\u5bfc\u5c0f\u7ec4-\u7f16\u8f91")
    @PostMapping(value={"/editInfo"})
    public ResponseData<BRayManageVo> editInfo(@RequestBody BRayManageEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            throw new ServiceException("\u5f02\u5e38");
        }
        return ResponseData.success((Object)this.rayManagerProvider.edit(param));
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/staffList"})
    public ResponseData<LayuiGridData<RayStaffListVo>> rayStaffList(RayStaffQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.cStaffBaseInfoService.rayStaffList(param));
    }

    @Generated
    public RayGroupManageController(IBRayManageService bRayManageService, ICStaffBaseInfoService cStaffBaseInfoService) {
        this.bRayManageService = bRayManageService;
        this.cStaffBaseInfoService = cStaffBaseInfoService;
    }
}

