/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.model.b.param.BPostEditParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BPostVo;
import cn.smarthse.rho.modules.sys.model.c.param.PostInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.PostQueryParam;
import cn.smarthse.rho.modules.sys.provider.company.IPostProvider;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/post"})
public class PostInfoController {
    @DubboReference
    private IPostProvider postProvider;

    @GetMapping(value={"/getPage"})
    public ResponseData<LayuiGridData<BPostVo>> getPostPage(PostQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.postProvider.getPage(param));
    }

    @GetMapping(value={"/getInfo"})
    public ResponseData<BPostVo> getPostInfo(PostInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.postProvider.getPostInfo(param));
    }

    @PostMapping(value={"/edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_post, title="\u5c97\u4f4d\u4fe1\u606f-\u5c97\u4f4d\u4fe1\u606f\u7f16\u8f91")
    public ResponseData editPostInfo(@RequestBody BPostEditParam param) {
        param.setAfterSelectCid(ShiroUtil.getLoginUserCid());
        this.postProvider.editInfo(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/add"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_post, title="\u5c97\u4f4d\u4fe1\u606f-\u5c97\u4f4d\u4fe1\u606f\u65b0\u589e")
    public ResponseData addPostInfo(@RequestBody BPostEditParam param) {
        param.setAfterSelectCid(ShiroUtil.getLoginUserCid());
        param.setCid(ShiroUtil.getLoginUserCid());
        this.postProvider.addInfo(param);
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_base_post, title="\u5c97\u4f4d\u4fe1\u606f-\u5c97\u4f4d\u4fe1\u606f\u5220\u9664")
    @PostMapping(value={"/remove"})
    public ResponseData removePostInfo(@RequestBody BPostEditParam param) {
        param.setAfterSelectCid(ShiroUtil.getLoginUserCid());
        this.postProvider.removeInfo(param);
        return ResponseData.success();
    }

    @Generated
    public PostInfoController() {
    }
}

