/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.hutool.core.lang.tree.Tree;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBOrgService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyAddress;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgInfoParam;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgStatisticsParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BOrgStatisticsVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BOrgVo;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyAddressVo;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCmPageParam;
import cn.smarthse.rho.modules.sys.model.c.vo.OrgStaffListVo;
import cn.smarthse.rho.modules.sys.provider.company.IBCompanyAddressProvider;
import cn.smarthse.rho.modules.sys.provider.company.IOrgProvider;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/orgStructure"})
public class OrgStructureController {
    private final IBOrgService bOrgService;
    private final IBCompanyAddressProvider companyAddressProvider;
    private final IBCompanyService companyService;
    private final ICStaffBaseInfoService cStaffBaseInfoService;
    @DubboReference
    private IBCompanyAddressProvider addressProvider;
    @DubboReference
    private IOrgProvider orgProvider;

    @GetMapping(value={"/getAddress"})
    public ResponseData<List<CompanyAddressVo>> getAddress(Long cid) {
        boolean sameHospital = this.companyService.isSameHospital(cid, ShiroUtil.getLoginUserCid());
        if (!sameHospital) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b\u5176\u4ed6\u533b\u9662\u4fe1\u606f");
        }
        return ResponseData.success((Object)this.addressProvider.getAddressVoList(cid));
    }

    @GetMapping(value={"/getTree"})
    public ResponseData<List<Tree<String>>> getTree(BOrgInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        boolean sameHospital = this.companyService.isSameHospital(param.getCid(), ShiroUtil.getLoginUserCid());
        if (!sameHospital) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b\u5176\u4ed6\u533b\u9662\u4fe1\u606f");
        }
        return ResponseData.success(this.bOrgService.getTree(param));
    }

    @ApiEncrypt(request=true, response=true)
    @PostMapping(value={"/getStaffList"})
    public ResponseData<LayuiGridData<List<OrgStaffListVo>>> getStaffList(@RequestBody StaffCmPageParam param) {
        return ResponseData.success(this.cStaffBaseInfoService.getListForOrg(param));
    }

    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_org, title="\u533b\u9662\uff1a\u7ec4\u7ec7\u67b6\u6784-\u65b0\u589e")
    @PostMapping(value={"/addInfo"})
    public ResponseData<BOrgVo> addInfo(@RequestBody BOrgEditParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        if (param.getSubCid() == null) {
            throw new ServiceException("\u5730\u5740id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BCompanyAddress companyAddress = this.companyAddressProvider.getAddressById(param.getSubCid());
        if (companyAddress == null) {
            throw new ServiceException("\u5730\u5740\u4e0d\u5b58\u5728");
        }
        if (!param.getCid().equals(companyAddress.getCid())) {
            throw new ServiceException("\u8be5\u5730\u5740\u4e0e\u90e8\u95e8\u4e0d\u5339\u914d\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        return ResponseData.success((Object)this.orgProvider.addInfo(param));
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_org, title="\u533b\u9662\uff1a\u7ec4\u7ec7\u67b6\u6784-\u7f16\u8f91")
    @PostMapping(value={"/editInfo"})
    public ResponseData<BOrgVo> editInfo(@RequestBody BOrgEditParam param) {
        param.setSubCid(null);
        param.setCid(null);
        return ResponseData.success((Object)this.orgProvider.editInfo(param));
    }

    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_base_org, title="\u533b\u9662\uff1a\u7ec4\u7ec7\u67b6\u6784-\u5220\u9664")
    @PostMapping(value={"/removeInfo"})
    public ResponseData removeInfo(@RequestBody BOrgEditParam param) {
        this.orgProvider.removeInfo(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/getDepartmentNum"})
    public ResponseData<BOrgStatisticsVo> getDepartmentNum(BOrgStatisticsParam param) {
        return ResponseData.success((Object)this.bOrgService.getCountWithDepartmentNum(param));
    }

    @Generated
    public OrgStructureController(IBOrgService bOrgService, IBCompanyAddressProvider companyAddressProvider, IBCompanyService companyService, ICStaffBaseInfoService cStaffBaseInfoService) {
        this.bOrgService = bOrgService;
        this.companyAddressProvider = companyAddressProvider;
        this.companyService = companyService;
        this.cStaffBaseInfoService = cStaffBaseInfoService;
    }
}

