/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.easyexcel.MachineRoomImportListener;
import cn.smarthse.rho.modules.company.service.e.IEmachineRoomDecorationLogService;
import cn.smarthse.rho.modules.company.service.e.IEmachineRoomService;
import cn.smarthse.rho.modules.company.service.e.manage.IEMachineRoomManageService;
import cn.smarthse.rho.modules.sys.model.e.param.EMachineRoomDecorationLogDto;
import cn.smarthse.rho.modules.sys.model.e.param.EMachineRoomDto;
import cn.smarthse.rho.modules.sys.model.e.param.EMachineSearchParam;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomCheckDataVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomDecorationLogVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomDetailVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomDeviceVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomListVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.MachineRoomImportDto;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import jakarta.validation.constraints.NotNull;
import java.io.InputStream;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/machineRoom"})
public class EMachineRoomController
extends ControllerSupport {
    @Autowired
    private IEmachineRoomService machineRoomService;
    @Autowired
    private IEmachineRoomDecorationLogService decorationLogService;
    private final OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvider sysFileProvideService;
    @Autowired
    private IEMachineRoomManageService machineRoomManageService;

    @GetMapping(value={"/listMachineRoom"})
    public ResponseData<LayuiGridData<EMachineRoomListVo>> listMachineRoom(EMachineSearchParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.machineRoomService.listMachineRoom(param));
    }

    @GetMapping(value={"/getMachineRoomDetail"})
    public ResponseData<EMachineRoomDetailVo> getMachineRoomDetail(EMachineSearchParam param) {
        return ResponseData.success((Object)this.machineRoomService.getMachineRoomDetail(param));
    }

    @PostMapping(value={"/addMachineRoomDetail"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_location, title="\u673a\u623f\u4fe1\u606f-\u65b0\u589e")
    public ResponseData<Long> addMachineRoomDetail(@RequestBody EMachineRoomDto param) {
        return ResponseData.success((Object)this.machineRoomService.addMachineRoomDetail(param));
    }

    @PostMapping(value={"/editMachineRoomDetail"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_location, title="\u673a\u623f\u4fe1\u606f-\u7f16\u8f91")
    public ResponseData<String> editMachineRoomDetail(@RequestBody EMachineRoomDto param) {
        this.machineRoomService.editMachineRoomDetail(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/delMachineRoom"})
    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_base_location, title="\u673a\u623f\u4fe1\u606f-\u5220\u9664")
    public ResponseData<String> delMachineRoom(@RequestBody EMachineSearchParam param) {
        this.machineRoomService.delMachineRoom(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/listRoomDecorationLog"})
    public ResponseData<LayuiGridData<EMachineRoomDecorationLogVo>> listRoomDecorationLog(EMachineSearchParam param) {
        return ResponseData.success(this.decorationLogService.listRoomDecorationLog(param));
    }

    @ApiEncrypt(request=true)
    @PostMapping(value={"/addRoomDecorationLog"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_location, title="\u673a\u623f\u4fe1\u606f-\u88c5\u4fee\u8bb0\u5f55-\u65b0\u589e")
    public ResponseData<Long> addRoomDecorationLog(@RequestBody EMachineRoomDecorationLogDto param) {
        return ResponseData.success((Object)this.decorationLogService.addRoomDecorationLog(param));
    }

    @GetMapping(value={"/listCheckDataByRoomId"})
    public ResponseData<LayuiGridData<EMachineRoomCheckDataVo>> listCheckDataByRoomId(EMachineSearchParam param) {
        return ResponseData.success(this.machineRoomService.listCheckDataByRoomId(param));
    }

    @GetMapping(value={"/listMachineRoomForDevice"})
    public ResponseData<LayuiGridData<EMachineRoomListVo>> listMachineRoomForDevice(EMachineSearchParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.machineRoomService.listMachineRoomForDevice(param));
    }

    @GetMapping(value={"/listDeviceByRoomId"})
    public ResponseData<LayuiGridData<EMachineRoomDeviceVo>> listDeviceByRoomId(EMachineSearchParam param) {
        return ResponseData.success(this.machineRoomService.listUnselectedDeviceByRoomId(param));
    }

    @PostMapping(value={"/import"})
    @Log(type=LogTypeEnum.type_opt_import, logModule=LogModuleTypeEnum.com_base_location, title="\u5bfc\u5165\u673a\u623f\u4fe1\u606f")
    public ResponseData<String> importMachineRoom(@NotNull(message="\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a") Long fileId) {
        SysFileVo file = this.sysFileProvideService.getFileById(fileId);
        if (Objects.isNull(file)) {
            throw new ServiceException("\u6587\u4ef6\u7f3a\u5931");
        }
        try {
            InputStream inputStream = this.ossClientBean.getInputStreamByUrl(file.getFullOssUrl());
            ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();
            inputStream.close();
            MachineRoomImportListener readListener = new MachineRoomImportListener(this.machineRoomManageService);
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((String)"\u673a\u623f\u4fe1\u606f").headRowNumber(Integer.valueOf(3))).head(MachineRoomImportDto.class)).registerReadListener((ReadListener)readListener)).build()});
        }
        catch (ServiceException e) {
            this.logger.error("\u8bbe\u5907\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.logger.error("\u673a\u623f\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5bfc\u5165\u5931\u8d25");
        }
        return ResponseData.success();
    }

    @Generated
    public EMachineRoomController(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

