/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.PageParam;
import cn.smarthse.rho.core.framework.mybatis.SysChangeLog;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.easyexcel.DeviceRayImportListener;
import cn.smarthse.rho.modules.company.easyexcel.DeviceSourceImportListener;
import cn.smarthse.rho.modules.company.easyexcel.SourceNonSealedImportListener;
import cn.smarthse.rho.modules.company.easyexcel.SourceSealedImportListener;
import cn.smarthse.rho.modules.company.service.b.IBCompanyErrorDeviceService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceFactoryService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceMaintenanceRecordService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRayService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceService;
import cn.smarthse.rho.modules.company.service.e.IErelationService;
import cn.smarthse.rho.modules.company.service.e.manage.IEDeviceManageService;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceFactory;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceDetailParam;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceDto;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceListParam;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceMaintenanceRecordParam;
import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceErrorInfoVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceHistorySourceVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceLicenseOptLogVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceListDetailVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceListVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceMaintenanceRecordVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDevicePerformanceCheckVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceRoomForSealedVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceStatisticVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceThreeProjectVo;
import cn.smarthse.rho.modules.sys.model.e.vo.ERelationVo;
import cn.smarthse.rho.modules.sys.model.e.vo.ESourceBindRoomVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.DeviceRayImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.DeviceSourceImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.SourceNonSealedImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.SourceSealedImportDto;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import jakarta.validation.constraints.NotNull;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/edevice"})
public class EDeviceController
extends ControllerSupport {
    @Autowired
    private IEdeviceService deviceService;
    @Autowired
    private IEdeviceRayService deviceRayService;
    @Autowired
    private IEDeviceManageService deviceManageService;
    @Autowired
    private IEdeviceMaintenanceRecordService deviceMaintenanceRecordService;
    @Autowired
    private IErelationService relationService;
    @Autowired
    private IEdeviceFactoryService deviceFactoryService;
    @Autowired
    private IBCompanyErrorDeviceService deviceErrorService;
    private final OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvider sysFileProvideService;

    @GetMapping(value={"/getStatisticData"})
    public ResponseData<EDeviceStatisticVo> getStatisticData(EDeviceListParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.deviceService.getStatisticData(param));
    }

    @GetMapping(value={"/listDevice"})
    public ResponseData<LayuiGridData<EDeviceListVo>> listDevice(EDeviceListParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.deviceService.listDevice(param));
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getDeviceDetailById"})
    public ResponseData<EDeviceListDetailVo> getDeviceDetailById(EDeviceDetailParam param) {
        return ResponseData.success((Object)this.deviceService.getDeviceDetailById(param));
    }

    @ApiEncrypt(request=true)
    @PostMapping(value={"/addEDevice"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_device, title="\u8bbe\u5907\u6863\u6848 - \u65b0\u589e")
    @RequestLimit(second=3, maxCount=1)
    public ResponseData<Long> addEDevice(@RequestBody EDeviceDto param) {
        return ResponseData.success((Object)this.deviceService.addEDevice(param));
    }

    @ApiEncrypt(request=true)
    @PostMapping(value={"/editEDevice"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_device, title="\u8bbe\u5907\u6863\u6848 - \u7f16\u8f91")
    @RequestLimit(second=3, maxCount=1)
    public ResponseData<Long> editEDevice(@RequestBody EDeviceDto param) {
        return ResponseData.success((Object)this.deviceService.editEDevice(param));
    }

    @PostMapping(value={"/delEDevice"})
    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_base_device, title="\u8bbe\u5907\u6863\u6848 - \u5220\u9664")
    @RequestLimit(second=3, maxCount=1)
    public ResponseData<String> delEDevice(@RequestBody EDeviceDetailParam param) {
        this.deviceService.delEDevice(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/listDeviceFactory"})
    public ResponseData<LayuiGridData<EDeviceFactory>> listDeviceFactory(PageParam param) {
        return ResponseData.success(this.deviceFactoryService.listFactory(param));
    }

    @GetMapping(value={"/listErrorInfoForDevice"})
    public ResponseData<List<EDeviceErrorInfoVo>> listErrorInfoForDevice(EDeviceListParam param) {
        return ResponseData.success(this.deviceErrorService.listErrorInfoForDevice(param));
    }

    @GetMapping(value={"/listFieldChangeRecord"})
    public ResponseData<LayuiGridData<SysChangeLog>> listFieldChangeRecord(EDeviceListParam param) {
        return ResponseData.success(this.deviceService.listFieldChangeRecord(param));
    }

    @GetMapping(value={"/listParametersForRay"})
    public ResponseData<List<String>> listParametersForRay(EDeviceListParam param) {
        return ResponseData.success(this.deviceRayService.listParametersForRay(param.getKeyword()));
    }

    @PostMapping(value={"/addRelationForSource"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_device, title="\u65b0\u589e\u6838\u7d20\u4e0e\u88c5\u7f6e\u7684\u5173\u8054")
    @RequestLimit(second=3, maxCount=1)
    public ResponseData<String> addRelationForSource(@RequestBody List<ERelationDto> param) {
        this.deviceService.addRelationForSource(param);
        return ResponseData.success();
    }

    @PostMapping(value={"/delRelationForSource"})
    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.com_base_device, title="\u5220\u9664\u6838\u7d20\u4e0e\u88c5\u7f6e\u7684\u5173\u8054")
    @RequestLimit(second=3, maxCount=1)
    public ResponseData<String> delRelationForSource(@RequestBody ERelationDto param) {
        this.deviceService.delRelationForSource(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/listRoomDeviceForSource"})
    public ResponseData<List<ESourceBindRoomVo>> listRoomDeviceForSource(EDeviceDetailParam param) {
        return ResponseData.success(this.deviceService.listRoomDeviceForSource(param));
    }

    @GetMapping(value={"/listRelationChangeRecord"})
    public ResponseData<LayuiGridData<ERelationVo>> listRoomChangeRecordForDevice(EDeviceDetailParam param) {
        return ResponseData.success(this.relationService.listRoomChangeRecordForDevice(param));
    }

    @GetMapping(value={"/listSourceByDevice"})
    public ResponseData<LayuiGridData<EDeviceHistorySourceVo>> listSourceByDevice(EDeviceDetailParam param) {
        return ResponseData.success(this.deviceService.listSourceByDevice(param));
    }

    @GetMapping(value={"/listSourceHistoryByDevice"})
    public ResponseData<LayuiGridData<EDeviceHistorySourceVo>> listSourceHistoryByDevice(EDeviceDetailParam param) {
        return ResponseData.success(this.deviceService.listSourceHistoryByDevice(param));
    }

    @GetMapping(value={"/listDeviceForSealSource"})
    public ResponseData<LayuiGridData<EDeviceRoomForSealedVo>> listDeviceForSealSource(EDeviceListParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.deviceService.listDeviceForSealSource(param));
    }

    @GetMapping(value={"/listPerformanceCheckRecord"})
    public ResponseData<LayuiGridData<EDevicePerformanceCheckVo>> listPerformanceCheckRecord(EDeviceDetailParam param) {
        return ResponseData.success(this.deviceService.listPerformanceCheckRecord(param));
    }

    @GetMapping(value={"/listMaintenanceRecord"})
    public ResponseData<LayuiGridData<EDeviceMaintenanceRecordVo>> listMaintenanceRecord(EDeviceDetailParam param) {
        return ResponseData.success(this.deviceMaintenanceRecordService.listMaintenanceRecord(param));
    }

    @PostMapping(value={"/addMaintenanceRecord"})
    @RequestLimit(second=3, maxCount=1)
    public ResponseData<Long> addMaintenanceRecord(@RequestBody EDeviceMaintenanceRecordParam param) {
        return ResponseData.success((Object)this.deviceMaintenanceRecordService.addMaintenanceRecord(param));
    }

    @GetMapping(value={"/listThreeProject"})
    public ResponseData<LayuiGridData<EDeviceThreeProjectVo>> listThreeProject(EDeviceDetailParam param) {
        return ResponseData.success(this.deviceService.listThreeProject(param));
    }

    @GetMapping(value={"/listLicenseOptLog"})
    public ResponseData<LayuiGridData<EDeviceLicenseOptLogVo>> listLicenseOptLog(EDeviceDetailParam param) {
        return ResponseData.success(this.deviceService.listLicenseOptLog(param));
    }

    @PostMapping(value={"/import"})
    @Log(type=LogTypeEnum.type_opt_import, logModule=LogModuleTypeEnum.com_base_device, title="\u5bfc\u5165\u8bbe\u5907")
    public ResponseData<String> importDevice(@NotNull(message="\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") Integer type, @NotNull(message="\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a") Long fileId) {
        block8: {
            SysFileVo file = this.sysFileProvideService.getFileById(fileId);
            if (Objects.isNull(file)) {
                throw new ServiceException("\u6587\u4ef6\u7f3a\u5931");
            }
            try {
                InputStream inputStream = this.ossClientBean.getInputStreamByUrl(file.getFullOssUrl());
                ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();
                inputStream.close();
                if (type == EdeviceTypeEnum.DEVICE_RAY.getValue()) {
                    DeviceRayImportListener readListener = new DeviceRayImportListener(this.deviceManageService);
                    excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((String)"\u5c04\u7ebf\u88c5\u7f6e").headRowNumber(Integer.valueOf(3))).head(DeviceRayImportDto.class)).registerReadListener((ReadListener)readListener)).build()});
                    break block8;
                }
                if (type == EdeviceTypeEnum.DEVICE_SOURCE.getValue()) {
                    DeviceSourceImportListener readListener = new DeviceSourceImportListener(this.deviceManageService);
                    excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((String)"\u542b\u5bc6\u5c01\u6e90\u88c5\u7f6e").headRowNumber(Integer.valueOf(3))).head(DeviceSourceImportDto.class)).registerReadListener((ReadListener)readListener)).build()});
                    break block8;
                }
                if (type == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue()) {
                    SourceNonSealedImportListener readListener = new SourceNonSealedImportListener(this.deviceManageService);
                    excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((String)"\u975e\u5bc6\u5c01\u653e\u5c04\u6838\u7d20").headRowNumber(Integer.valueOf(3))).head(SourceNonSealedImportDto.class)).registerReadListener((ReadListener)readListener)).build()});
                    break block8;
                }
                if (type == EdeviceTypeEnum.SOURCE_SEALED.getValue()) {
                    SourceSealedImportListener readListener = new SourceSealedImportListener(this.deviceManageService);
                    excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((String)"\u5bc6\u5c01\u653e\u5c04\u6e90").headRowNumber(Integer.valueOf(3))).head(SourceSealedImportDto.class)).registerReadListener((ReadListener)readListener)).build()});
                    break block8;
                }
                throw new ServiceException("\u4e0d\u652f\u6301\u7684\u8bbe\u5907\u7c7b\u578b");
            }
            catch (ServiceException e) {
                this.logger.error("\u8bbe\u5907\u5bfc\u5165\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.logger.error("\u8bbe\u5907\u5bfc\u5165\u5931\u8d25", (Throwable)e);
                throw new ServiceException("\u5bfc\u5165\u5931\u8d25");
            }
        }
        return ResponseData.success();
    }

    @Generated
    public EDeviceController(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

