/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBLivenessService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRayService;
import cn.smarthse.rho.modules.company.service.e.IEsourceNonSealedService;
import cn.smarthse.rho.modules.company.service.e.IEsourceSealedService;
import cn.smarthse.rho.modules.sys.enums.company.CompanyCertCycleEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCertChangeLogQueryParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyInfoParam;
import cn.smarthse.rho.modules.sys.model.b.param.BLivenessEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.CompanyInfoChangeLogParam;
import cn.smarthse.rho.modules.sys.model.b.param.CompanyLivenessIChangeLogParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCertChangeLogVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCertVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyCampusVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyFullInfoVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanyChangeLogVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanyLivenessChangeLogVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmEDeviceRayStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmEDeviceStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmESourceNonSealedStatisticsVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamVo;
import cn.smarthse.rho.modules.sys.provider.company.IBCertChangeLogProvider;
import cn.smarthse.rho.modules.sys.provider.company.IBCertProvider;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/companyInfo"})
public class CompanyInfoController
extends ControllerSupport {
    private final IBCompanyService bCompanyService;
    private final IEdeviceRayService eDeviceRayService;
    private final IEsourceNonSealedService eSourceNonSealedService;
    private final IEsourceSealedService eSourceSealedService;
    private final IBLivenessService livenessService;
    @DubboReference
    private IBCertProvider bCertService;
    @DubboReference
    private ICompanyProvider companyProvider;
    @DubboReference
    private IBCertChangeLogProvider bCertChangeLogService;

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getBaseInfo"})
    public ResponseData<BCompanyVo> getBaseInfo(BCompanyInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.bCompanyService.getBaseInfoById(param));
    }

    @ApiEncrypt(request=true)
    @PostMapping(value={"/edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_company, title="\u533b\u9662\uff1a\u4fe1\u606f-\u7f16\u8f91\u533b\u9662\u57fa\u7840\u4fe1\u606f")
    public ResponseData<String> edit(@RequestBody BCompanyEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getId())) {
            return ResponseData.fail();
        }
        param.setMainLeaderName(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getMainLeaderName()));
        param.setMainLeaderTel(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getMainLeaderTel()));
        param.setLegalName(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getLegalName()));
        param.setLegalTel(DesensitizationUtils.ignoreSetDesensitizationField((String)param.getLegalTel()));
        this.companyProvider.editBaseInfo(param);
        return ResponseData.success();
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getFullInfo"})
    public ResponseData<BCompanyFullInfoVo> getFullInfo(BCompanyInfoParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        BCompanyFullInfoVo result = new BCompanyFullInfoVo();
        BCompanyVo baseInfo = this.bCompanyService.getBaseInfoById(param);
        List<BCompanyCampusVo> branchList = this.bCompanyService.getBranchListForCompany(param);
        BCertVo certInfo = this.bCertService.getBaseInfoForCompany(param);
        CmEDeviceRayStatisticsVo deviceRayStatisticsVo = this.eDeviceRayService.deviceRayStatisticsForCompany(param);
        CmESourceNonSealedStatisticsVo cmESourceNonSealedStatisticsVo = null;
        List<CmEDeviceStatisticsVo> sealedSourceStatisticsVo = null;
        List<CmEDeviceStatisticsVo> includeSealedSourceStatisticsVo = null;
        try {
            sealedSourceStatisticsVo = this.eSourceSealedService.sealedSourceStatistics(param);
            includeSealedSourceStatisticsVo = this.eSourceSealedService.includeSealedSourceStatistics(param);
            cmESourceNonSealedStatisticsVo = this.eSourceNonSealedService.sourceNonSealedStatisticsForCompany(param);
            CmESourceNonSealedStatisticsVo location = this.eSourceNonSealedService.sourceNonSealedStatisticsForCompanyLocation(param);
            cmESourceNonSealedStatisticsVo = cmESourceNonSealedStatisticsVo == null ? new CmESourceNonSealedStatisticsVo() : cmESourceNonSealedStatisticsVo;
            cmESourceNonSealedStatisticsVo.setALocationNum(Integer.valueOf(location == null ? 0 : location.getALocationNum()));
            cmESourceNonSealedStatisticsVo.setBLocationNum(Integer.valueOf(location == null ? 0 : location.getBLocationNum()));
            cmESourceNonSealedStatisticsVo.setCLocationNum(Integer.valueOf(location == null ? 0 : location.getCLocationNum()));
        }
        catch (Exception e) {
            this.logger.error(e.toString());
        }
        baseInfo.setMainLeaderName(DesensitizationUtils.desensitized((CharSequence)baseInfo.getMainLeaderName(), (DesensitizationType)DesensitizationType.NAME));
        baseInfo.setMainLeaderTel(DesensitizationUtils.desensitized((CharSequence)baseInfo.getMainLeaderTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        baseInfo.setLegalName(DesensitizationUtils.desensitized((CharSequence)baseInfo.getLegalName(), (DesensitizationType)DesensitizationType.NAME));
        baseInfo.setLegalTel(DesensitizationUtils.desensitized((CharSequence)baseInfo.getLegalTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        baseInfo.setRaManagerName(DesensitizationUtils.desensitized((CharSequence)baseInfo.getRaManagerName(), (DesensitizationType)DesensitizationType.NAME));
        baseInfo.setRaManagerTel(DesensitizationUtils.desensitized((CharSequence)baseInfo.getRaManagerTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        result.setBCompanyVo(baseInfo);
        result.setBranchList(branchList);
        result.setBCertVo(certInfo);
        result.setCmeDeviceRayStatisticsVo(deviceRayStatisticsVo);
        result.setCmESourceNonSealedStatisticsVo(cmESourceNonSealedStatisticsVo);
        result.setSealedSourceStatisticsVo(sealedSourceStatisticsVo);
        result.setIncludeSealedSourceStatisticsVo(includeSealedSourceStatisticsVo);
        return ResponseData.success((Object)result);
    }

    @GetMapping(value={"/certChangeLog"})
    public ResponseData<LayuiGridData<BCertChangeLogVo>> certChangeLog(BCertChangeLogQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.bCertChangeLogService.getList(param));
    }

    @GetMapping(value={"/infoChangeLog"})
    public ResponseData<LayuiGridData<CompanyChangeLogVo>> getChangeLog(CompanyInfoChangeLogParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.bCompanyService.getChangeLog(param));
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_company, title="\u533b\u9662\uff1a\u4fe1\u606f-\u6dfb\u52a0\u6d3b\u8dc3\u5ea6")
    @PostMapping(value={"/addLivenessInfo"})
    public ResponseData addLivenessInfo(@RequestBody BLivenessEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            return ResponseData.fail();
        }
        this.livenessService.addInfo(param);
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_base_company, title="\u533b\u9662\uff1a\u4fe1\u606f-\u7f16\u8f91\u6d3b\u8dc3\u5ea6")
    @PostMapping(value={"/editLivenessInfo"})
    public ResponseData editLivenessInfo(@RequestBody BLivenessEditParam param) {
        if (!ShiroUtil.getLoginUserCid().equals(param.getCid())) {
            return ResponseData.fail();
        }
        this.livenessService.editInfo(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/livenessChangeLog"})
    public ResponseData<LayuiGridData<CompanyLivenessChangeLogVo>> getLivenessChangeLog(CompanyLivenessIChangeLogParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.livenessService.getLivenessChangeLog(param));
    }

    @GetMapping(value={"/type"})
    public ResponseData<List<SysParamVo>> getParamList() {
        return ResponseData.success((Object)CompanyCertCycleEnum.getParamList());
    }

    @Generated
    public CompanyInfoController(IBCompanyService bCompanyService, IEdeviceRayService eDeviceRayService, IEsourceNonSealedService eSourceNonSealedService, IEsourceSealedService eSourceSealedService, IBLivenessService livenessService) {
        this.bCompanyService = bCompanyService;
        this.eDeviceRayService = eDeviceRayService;
        this.eSourceNonSealedService = eSourceNonSealedService;
        this.eSourceSealedService = eSourceSealedService;
        this.livenessService = livenessService;
    }
}

