/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.base;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBOrgService;
import cn.smarthse.rho.modules.company.service.e.IEmachineRoomService;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyAddress;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyAddressEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgInfoParam;
import cn.smarthse.rho.modules.sys.model.b.vo.OrgCompanyAddressVo;
import cn.smarthse.rho.modules.sys.provider.company.IBCompanyAddressProvider;
import java.util.List;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/companyAddress"})
public class CompanyAddressController
extends ControllerSupport {
    @DubboReference
    private IBCompanyAddressProvider companyAddressProvider;
    private final IEmachineRoomService emachineRoomService;
    private final IBOrgService bOrgService;

    @GetMapping(value={"/getCompanyAddressList"})
    public ResponseData<List<BCompanyAddress>> getCompanyAddressList(Long cid) {
        if (cid == null) {
            cid = ShiroUtil.getLoginUserCid();
        }
        List list = this.companyAddressProvider.getAddressListByCid(cid);
        return ResponseData.success((Object)list);
    }

    @GetMapping(value={"/getCompanyAddressOrgList"})
    public ResponseData<List<OrgCompanyAddressVo>> getOrgCompanyAddressVo(Long cid) {
        if (cid == null) {
            cid = ShiroUtil.getLoginUserCid();
        }
        List voList = this.companyAddressProvider.getOrgCompanyAddressVo(cid);
        for (OrgCompanyAddressVo vo : voList) {
            BOrgInfoParam param = new BOrgInfoParam();
            param.setCid(cid);
            param.setSubCid(vo.getId());
            vo.setOrgTree(this.bOrgService.getTree(param));
        }
        return ResponseData.success((Object)voList);
    }

    @PostMapping(value={"/editCompanyAddressById"})
    public ResponseData<String> editCompanyAddressById(@Validated @RequestBody BCompanyAddressEditParam param) {
        this.companyAddressProvider.editCompanyAddressById(param);
        return ResponseData.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/addCompanyAddress"})
    public ResponseData<String> addCompanyAddress(@Validated @RequestBody BCompanyAddressEditParam param) {
        this.companyAddressProvider.addCompanyAddress(param);
        return ResponseData.success((String)"\u65b0\u589e\u6210\u529f");
    }

    @PostMapping(value={"/removeCompanyAddress"})
    public ResponseData<String> deleteCompanyAddressById(@RequestBody BCompanyAddressEditParam param) {
        Long cid = ShiroUtil.getLoginUserCid();
        if (param.getId() == null) {
            return ResponseData.fail((String)"\u5730\u5740id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.emachineRoomService.existMachineRoomByAddrId(cid, param.getId()).booleanValue()) {
            return ResponseData.fail((String)"\u8be5\u5730\u5740\u4e0b\u6709\u673a\u623f\uff0c\u4e0d\u80fd\u76f4\u63a5\u5220\u9664");
        }
        this.companyAddressProvider.deleteCompanyAddressById(param.getId());
        return ResponseData.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Generated
    public CompanyAddressController(IEmachineRoomService emachineRoomService, IBOrgService bOrgService) {
        this.emachineRoomService = emachineRoomService;
        this.bOrgService = bOrgService;
    }
}

