/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.api;

import cn.dev33.satoken.annotation.SaIgnore;
import cn.hutool.core.util.IdUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.RedisKey;
import cn.smarthse.rho.core.framework.model.RSAVo;
import cn.smarthse.rho.core.framework.utils.RsaUtil;
import cn.smarthse.rho.modules.company.service.e.IEdeviceService;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceDetailParam;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceListDetailVo;
import jakarta.validation.constraints.NotEmpty;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@SaIgnore
@RestController
@RequestMapping(value={"/api"})
public class ApiController
extends ControllerSupport {
    @Autowired
    private IEdeviceService deviceService;

    @PostMapping(value={"/health/beat"})
    public Object healthBeat() {
        return HttpStatus.OK;
    }

    @PostMapping(value={"/getPublicKey"})
    public ResponseData<RSAVo> getPublicKey() {
        String uuid = IdUtil.simpleUUID();
        Map rsaMap = RsaUtil.genKeyPair();
        RedisUtils.setCacheObject((String)RedisKey.RSA((String)uuid), (Object)((String)rsaMap.get("privateKey")), (Duration)Duration.ofMinutes(30L));
        return ResponseData.success((Object)new RSAVo().setUuid(uuid).setPrivateKey((String)rsaMap.get("publicKey")));
    }

    @PostMapping(value={"/encrypt"})
    public ResponseData<String> encrypt(@NotEmpty String publicKey, @NotEmpty String content) {
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)RsaUtil.encrypt((String)content, (String)publicKey));
    }

    @GetMapping(value={"/getDeviceForQR"})
    public ResponseData<EDeviceListDetailVo> getDeviceForQR(EDeviceDetailParam param) {
        return ResponseData.success((Object)this.deviceService.getDeviceDetailById(param));
    }

    @Generated
    public ApiController() {
    }
}

