/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller;

import cn.dev33.satoken.session.SaSession;
import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysPermissionV3Service;
import cn.smarthse.modules.sys.enumd.OperatorDataSourceEnum;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.core.framework.model.IdParam;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.utils.AesUtil;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.model.LoginSysUser;
import cn.smarthse.rho.modules.company.bootstrap.security.service.LoginService;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.model.uc.CasToOnlineTrainLoginParam;
import cn.smarthse.rho.modules.company.model.uc.ChangeBindParam;
import cn.smarthse.rho.modules.company.model.uc.ChangePasswordByTelParam;
import cn.smarthse.rho.modules.company.model.uc.ChangePasswordParam;
import cn.smarthse.rho.modules.company.model.uc.ChangeRebindApplicationNextParam;
import cn.smarthse.rho.modules.company.model.uc.VSmsCodeParam;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.model.b.CompanyBatchVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.bind.param.ContactRebindHistoryParam;
import cn.smarthse.rho.modules.sys.model.bind.vo.ContactRebindHistoryVo;
import cn.smarthse.rho.modules.sys.provider.bind.ISysUserBindLogProvider;
import cn.smarthse.rho.modules.sys.provider.bind.ISysUserBindProvider;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import com.alibaba.fastjson2.JSONObject;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/uc"})
@Validated
public class UcController
extends ControllerSupport {
    private final SysProperties sysProperties;
    private final LoginService loginService;
    private final IBCompanyService companyService;
    private final ISysPermissionV3Service sysPermissionV3Service;
    @DubboReference
    private ICompanyProvider companyProvider;
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;
    @DubboReference
    private ISysUserBindProvider sysUserBindProvider;
    @DubboReference
    private ISysUserBindLogProvider sysUserBindLogProvider;
    @DubboReference(registry={"public_nacos"})
    private ISMSProviderWelinkService smsProviderWelinkService;

    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.LOGOUT_TYPE, businessModule=BigLogBusinessModuleEnum.module9)
    @PostMapping(value={"logout"})
    public ResponseData<Void> logout() {
        ShiroUtil.logout();
        return ResponseData.success((String)"\u9000\u51fa\u6210\u529f");
    }

    @GetMapping(value={"getCompanyBatchList"})
    public ResponseData<List<CompanyBatchVo>> getCompanyBatchList() {
        List<CompanyBatchVo> rst = this.companyService.getCompanyBatchChooseList(ShiroUtil.getLoginUserCid());
        Long loginUserCid = ShiroUtil.getLoginUserCid();
        rst.stream().peek(i -> {
            if (i.getCid().longValue() == loginUserCid.longValue()) {
                i.setIsChoose(Integer.valueOf(1));
            }
        }).collect(Collectors.toList());
        return ResponseData.success(rst);
    }

    @PostMapping(value={"reflush"})
    public ResponseData<Long> reflush(@Validated @RequestBody IdParam param) {
        if (ObjectUtils.equals((Object)param.getId(), (Object)ShiroUtil.getLoginUserCid())) {
            return ResponseData.success((Object)param.getId());
        }
        List<CompanyBatchVo> batchList = this.companyService.getCompanyBatchChooseList(ShiroUtil.getLoginUserCid());
        if (CollectionUtils.isEmpty(batchList)) {
            return ResponseData.fail((String)"\u67e5\u65e0\u5206\u9662\u4fe1\u606f\uff0c\u5207\u6362\u5931\u8d25\uff01");
        }
        Set batchIdList = batchList.stream().map(CompanyBatchVo::getCid).collect(Collectors.toSet());
        if (!batchIdList.contains(param.getId())) {
            return ResponseData.fail((String)"\u975e\u6cd5\u64cd\u4f5c\uff01");
        }
        SaSession session = StpUtil.getTokenSession();
        if (ObjectUtil.isNull((Object)session)) {
            return new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName());
        }
        LoginSysUser loginSysUser = (LoginSysUser)((Object)session.get("loginUser"));
        if (ObjectUtil.isNull((Object)((Object)loginSysUser))) {
            return new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName());
        }
        loginSysUser.setExtra("afterSelectCompanyCid", param.getId());
        BCompany afterSelectCompany = (BCompany)this.companyService.getById(param.getId());
        loginSysUser.setExtra("afterSelectCompanyName", afterSelectCompany.getName());
        loginSysUser.setAddressType(afterSelectCompany.getAddressType());
        loginSysUser.setExtra("afterSelectCompanyAddressType", loginSysUser.getAddressType());
        session.set("loginUser", (Object)loginSysUser);
        return ResponseData.success((Object)param.getId());
    }

    @GetMapping(value={"getRouters"})
    public ResponseData<List<Tree<Long>>> getRouters() {
        return ResponseData.success((Object)this.sysPermissionV3Service.getRouters(UserSystemWideEnum.RHO_COMPANY.getCode(), ShiroUtil.getJWTUserId()));
    }

    @GetMapping(value={"getPrinciple"})
    public ResponseData<LoginSysUser> getPrinciple() {
        LoginSysUser principal = ShiroUtil.getShiroPrincipalDesensitization((LoginSysUser)ShiroUtil.getShiroPrincipal());
        return ResponseData.success((Object)((Object)principal));
    }

    @ApiEncrypt(request=true)
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.LOGOUT_TYPE, businessModule=BigLogBusinessModuleEnum.module9)
    @Log(type=LogTypeEnum.type_opt_changePass, logModule=LogModuleTypeEnum.com_uc, dataOf=OperatorDataSourceEnum.RHO_COMPANY)
    @RequestLimit(maxCount=1)
    @PostMapping(value={"changePassword"})
    public ResponseData<String> changePassword(@Validated @RequestBody ChangePasswordParam param) {
        this.sysUserServiceProvider.changePassword(ShiroUtil.getJWTUserId(), param.getOldPassword(), param.getPassword());
        ShiroUtil.logout();
        return ResponseData.success((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @ApiEncrypt(request=true)
    @BigLog(userRole=UserRoleEnum.ENTERPRISE_TYPE, actionType=ActionTypeEnum.LOGOUT_TYPE, businessModule=BigLogBusinessModuleEnum.module9)
    @Log(type=LogTypeEnum.type_opt_changePass, logModule=LogModuleTypeEnum.sup_uc, dataOf=OperatorDataSourceEnum.SUPERVISE)
    @RequestLimit(maxCount=1)
    @PostMapping(value={"changePasswordByTel"})
    public ResponseData<String> changePasswordByTel(@Validated @RequestBody ChangePasswordByTelParam param) {
        String tempAuthToken = param.getTempAuthToken();
        String code = param.getCode();
        String password = param.getPassword();
        LoginSysUser loginSysUser = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (ObjectUtils.isNull((Object)((Object)loginSysUser))) {
            return new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName());
        }
        String bindTel = loginSysUser.getBindTel();
        if (StringUtils.isBlank((CharSequence)bindTel)) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (!PhoneUtil.isMobile((CharSequence)bindTel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        this.loginService.validateCaptcha(code, bindTel, tempAuthToken);
        this.sysUserServiceProvider.modifyPasswordByPhone(loginSysUser.getId(), password);
        ShiroUtil.logout();
        return ResponseData.success((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @RequestLimit(second=60, maxCount=1)
    @PostMapping(value={"vSmsCode"})
    public ResponseData<String> vSmsCode() {
        LoginSysUser loginSysUser = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (ObjectUtils.isNull((Object)((Object)loginSysUser))) {
            return new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName());
        }
        String bindTel = loginSysUser.getBindTel();
        if (StringUtils.isBlank((CharSequence)bindTel)) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (!PhoneUtil.isMobile((CharSequence)bindTel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        String vcode = StringUtils.getRandomNum((int)6);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u53d1\u9001\u77ed\u4fe1\uff08\u5df2\u767b\u5f55\uff09 \u9a8c\u8bc1\u7801\uff1a{}", (Object)vcode);
        }
        String tempAuthToken = ShiroCommonUtil.getRandomString();
        this.loginService.setCaptchaCache(vcode, bindTel, tempAuthToken);
        this.smsProviderWelinkService.singleSendSms(bindTel, String.format("\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u7684\u9a8c\u8bc1\u7801\u662f: %s\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", vcode));
        return ResponseData.success((String)"\u53d1\u9001\u6210\u529f", (Object)tempAuthToken);
    }

    @ApiEncrypt(request=true)
    @RequestLimit(second=60, maxCount=1)
    @PostMapping(value={"vSmsCodeByTel"})
    public ResponseData<String> vSmsCodeByTel(@Validated @RequestBody VSmsCodeParam param) {
        String tel = param.getTel();
        if (!PhoneUtil.isMobile((CharSequence)tel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        String vcode = StringUtils.getRandomNum((int)6);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u53d1\u9001\u77ed\u4fe1\uff08\u5df2\u767b\u5f55\uff09\u81ea\u884c\u8f93\u5165\u624b\u673a\u53f7 \u9a8c\u8bc1\u7801\uff1a{}", (Object)vcode);
        }
        String tempAuthToken = ShiroCommonUtil.getRandomString();
        this.loginService.setCaptchaCache(vcode, tel, tempAuthToken);
        this.smsProviderWelinkService.singleSendSms(tel, String.format("\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u8fdb\u884c\u624b\u673a\u53f7\u6362\u7ed1\uff0c\u6362\u7ed1\u9a8c\u8bc1\u7801\u4e3a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", vcode));
        return ResponseData.success((String)"\u53d1\u9001\u6210\u529f", (Object)tempAuthToken);
    }

    @RequestLimit
    @PostMapping(value={"checkSmsCode"})
    public ResponseData<String> checkSmsCode(@NotBlank(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") String tempAuthToken) {
        LoginSysUser loginSysUser = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (ObjectUtils.isNull((Object)((Object)loginSysUser))) {
            return new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName());
        }
        String bindTel = loginSysUser.getBindTel();
        if (StringUtils.isBlank((CharSequence)bindTel)) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (!PhoneUtil.isMobile((CharSequence)bindTel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        this.loginService.validateCaptcha(code, bindTel, tempAuthToken);
        return ResponseData.success((String)"\u6821\u9a8c\u901a\u8fc7");
    }

    @Log(type=LogTypeEnum.type_cas_login, logModule=LogModuleTypeEnum.com_uc, title="\u653e\u5c04\u8bca\u7597\u673a\u6784\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u5728\u7ebf\u57f9\u8bad\u4f01\u4e1a\u7aef")
    @PostMapping(value={"casToOnlineTrain"})
    public ResponseData<String> casToOnlineTrain(@Validated @RequestBody CasToOnlineTrainLoginParam param) {
        String redirectUrl = param.getRedirectUrl();
        Integer loginUserType = param.getLoginUserType();
        Long cid = ShiroUtil.getLoginUserCid();
        BCompanyVo company = this.companyProvider.getCompany(cid);
        if (ObjectUtils.isNull((Object)company)) {
            return ResponseData.fail((String)"\u627e\u4e0d\u5230\u8be5\u533b\u9662\u76f8\u5173\u4fe1\u606f");
        }
        if (ObjectUtils.isNull((Object)loginUserType)) {
            loginUserType = 0;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"time", (Object)System.currentTimeMillis());
        jsonObject.put((Object)"redirectUrl", (Object)(StringUtils.isNotBlank((CharSequence)redirectUrl) ? redirectUrl : this.sysProperties.healthOnlineTrainingRedirectUrl));
        jsonObject.put((Object)"username", (Object)ShiroUtil.getJWTUsername());
        jsonObject.put((Object)"token", (Object)cid);
        jsonObject.put((Object)"name", (Object)company.getName());
        jsonObject.put((Object)"creditCode", (Object)company.getCreditCode());
        jsonObject.put((Object)"areaId", (Object)company.getAreaId());
        jsonObject.put((Object)"isTest", (Object)company.getIsTest());
        String sign = AesUtil.encrypt((String)jsonObject.toString(), (String)this.sysProperties.healthOnlineTrainingAesKey);
        return ResponseData.success((String)ResponseStateEnum.success.getName(), (Object)(this.sysProperties.healthOnlineTrainingUrl + "?sign=" + sign + "&type=4&loginUserType=" + loginUserType));
    }

    @RequestLimit(second=60, maxCount=1, expression="#tel")
    @PostMapping(value={"vSmsCodeByTelForBindApplication"})
    public ResponseData<String> vSmsCodeByTelForBindApplication(@NotBlank(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String tel, @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") String tempAuthToken) {
        if (!PhoneUtil.isMobile((CharSequence)tel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        LoginSysUser loginSysUser = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (ObjectUtils.isNull((Object)((Object)loginSysUser))) {
            return new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName());
        }
        if (StringUtils.isBlank((CharSequence)loginSysUser.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (loginSysUser.getBindTel().equals(tel)) {
            return ResponseData.fail((String)"\u6362\u7ed1\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u7ed1\u5b9a\u624b\u673a\u53f7\u76f8\u540c");
        }
        String vcode = StringUtils.getRandomNum((int)6);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u53d1\u9001\u77ed\u4fe1\uff08\u5df2\u767b\u5f55\uff09\u6839\u636e\u7528\u6237\u540d \u91cd\u65b0\u7ed1\u5b9a\u7533\u8bf7 \u9a8c\u8bc1\u7801\uff1a{}", (Object)vcode);
        }
        this.loginService.setCaptchaCache(vcode, tel, tempAuthToken);
        this.smsProviderWelinkService.singleSendSms(tel, String.format("\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u8fdb\u884c\u624b\u673a\u53f7\u6362\u7ed1\uff0c\u6362\u7ed1\u9a8c\u8bc1\u7801\u4e3a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", vcode));
        return ResponseData.success((String)"\u53d1\u9001\u6210\u529f", (Object)tempAuthToken);
    }

    @ApiEncrypt(request=true)
    @RequestLimit(maxCount=1, expression="#param.bindTel")
    @PostMapping(value={"rebindApplicationNext"})
    public ResponseData<String> rebindApplicationNext(@Validated @RequestBody ChangeRebindApplicationNextParam param) {
        String tempAuthToken = param.getTempAuthToken();
        String code = param.getCode();
        Long fileId = param.getFileId();
        String bindTel = param.getBindTel();
        String bindName = param.getBindName();
        if (!PhoneUtil.isMobile((CharSequence)bindTel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        this.loginService.validateCaptcha(code, bindTel, tempAuthToken);
        LoginSysUser loginSysUser = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (ObjectUtils.isNull((Object)((Object)loginSysUser))) {
            return new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName());
        }
        if (StringUtils.isBlank((CharSequence)loginSysUser.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (loginSysUser.getBindTel().equals(bindTel)) {
            return ResponseData.fail((String)"\u6362\u7ed1\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u7ed1\u5b9a\u624b\u673a\u53f7\u76f8\u540c");
        }
        this.sysUserBindProvider.bindApplication(loginSysUser.getId(), bindName, bindTel, fileId);
        return ResponseData.success((String)"\u91cd\u65b0\u7ed1\u5b9a\u7533\u8bf7\u63d0\u4ea4\u6210\u529f");
    }

    @ApiEncrypt(request=true)
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.com_uc, title="\u624b\u673a\u53f7\u7801\u6362\u7ed1")
    @RequestLimit(maxCount=1, expression="#param.bindTel")
    @PostMapping(value={"rebind"})
    public ResponseData<String> rebind(@Validated @RequestBody ChangeBindParam param) {
        String tempAuthToken = param.getTempAuthToken();
        String code = param.getCode();
        String bindTel = param.getBindTel();
        String bindName = param.getBindName();
        if (!PhoneUtil.isMobile((CharSequence)bindTel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        this.loginService.validateCaptcha(code, bindTel, tempAuthToken);
        LoginSysUser loginSysUser = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (ObjectUtils.isNull((Object)((Object)loginSysUser))) {
            return new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName());
        }
        if (StringUtils.isBlank((CharSequence)loginSysUser.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (loginSysUser.getBindTel().equals(bindTel)) {
            return ResponseData.fail((String)"\u6362\u7ed1\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u7ed1\u5b9a\u624b\u673a\u53f7\u76f8\u540c");
        }
        this.sysUserBindProvider.bind(ShiroUtil.getJWTUserId(), bindName, bindTel);
        SaSession session = StpUtil.getTokenSession();
        if (ObjectUtil.isNull((Object)session)) {
            return new ResponseData(ResponseStateEnum.INVALID_TOKEN.getValue(), ResponseStateEnum.INVALID_TOKEN.getName());
        }
        loginSysUser.setBindName(bindName);
        loginSysUser.setBindTel(bindTel);
        session.set("loginUser", (Object)loginSysUser);
        return ResponseData.success((String)"\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u6362\u7ed1\u6210\u529f", (Object)DesensitizationUtils.desensitized((CharSequence)bindTel, (DesensitizationType)DesensitizationType.MOBILE_PHONE));
    }

    @GetMapping(value={"getRebindHistory"})
    public ResponseData<LayuiGridData<ContactRebindHistoryVo>> getRebindHistory(@Validated ContactRebindHistoryParam param) {
        param.setUserId(ShiroUtil.getJWTUserId());
        return ResponseData.success((Object)this.sysUserBindLogProvider.getRebindHistory(param));
    }

    @Generated
    public UcController(SysProperties sysProperties, LoginService loginService, IBCompanyService companyService, ISysPermissionV3Service sysPermissionV3Service) {
        this.sysProperties = sysProperties;
        this.loginService = loginService;
        this.companyService = companyService;
        this.sysPermissionV3Service = sysPermissionV3Service;
    }
}

