/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller;

import cn.dev33.satoken.annotation.SaIgnore;
import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.smarthse.framework.core.captcha.RandomNumberGenerator;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProviderWelinkService;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.CaptchaVo;
import cn.smarthse.rho.modules.company.bootstrap.security.service.LoginService;
import cn.smarthse.rho.modules.sys.entity.bind.SysUserBind;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.provider.bind.ISysUserBindProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import jakarta.validation.constraints.NotBlank;
import java.awt.Font;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@SaIgnore
@RestController
@RequestMapping(value={"/captcha"})
@Validated
public class CaptchaController
extends ControllerSupport {
    private final LoginService loginService;
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;
    @DubboReference
    private ISysUserBindProvider sysUserBindProvider;
    @DubboReference(registry={"public_nacos"})
    private ISMSProviderWelinkService smsProviderWelinkService;

    @RequestLimit(maxCount=3)
    @GetMapping(value={"code"})
    public ResponseData<CaptchaVo> getCode() {
        String uuid = IdUtil.simpleUUID();
        RandomNumberGenerator codeGenerator = new RandomNumberGenerator("0123456789", 4);
        LineCaptcha captcha = CaptchaUtil.createLineCaptcha((int)130, (int)48, (CodeGenerator)codeGenerator, (int)9);
        captcha.setFont(new Font("SansSerif", 1, 43));
        this.loginService.setCaptchaCache(captcha.getCode(), uuid);
        CaptchaVo captchaVo = new CaptchaVo();
        captchaVo.setUuid(uuid);
        captchaVo.setImg(captcha.getImageBase64Data());
        return ResponseData.success((Object)captchaVo);
    }

    @RequestLimit(second=60, maxCount=1, expression="#tel")
    @PostMapping(value={"vSmsCodeByTel"})
    public ResponseData<String> vSmsCodeByTel(@NotBlank(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String tel, @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") String tempAuthToken) {
        if (!PhoneUtil.isMobile((CharSequence)tel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        this.loginService.getTempLoginInformationCache(tempAuthToken);
        String vcode = StringUtils.getRandomNum((int)6);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u6839\u636e\u624b\u673a\u53f7\u53d1\u9001\u77ed\u4fe1\uff08\u672a\u767b\u5f55\uff09\u767b\u5f55\u7b2c\u4e8c\u6b65 \u9a8c\u8bc1\u7801\uff1a{}", (Object)vcode);
        }
        this.loginService.setCaptchaCache(vcode, tel, tempAuthToken);
        this.smsProviderWelinkService.singleSendSms(tel, String.format("\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u8fdb\u884c\u7ed1\u5b9a\u624b\u673a\u53f7\u7684\u64cd\u4f5c\uff0c\u9a8c\u8bc1\u7801\u4e3a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", vcode));
        return ResponseData.success((String)"\u53d1\u9001\u6210\u529f", (Object)tempAuthToken);
    }

    @RequestLimit(second=60, maxCount=1, expression="#username")
    @PostMapping(value={"vSmsCodeByUsername"})
    public ResponseData<String> vSmsCodeByUsername(@NotBlank(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a") String username, @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") String tempAuthToken) {
        SysUser user = this.loginService.getTempLoginInformationCache(tempAuthToken);
        SysUserBind sysUserBind = this.sysUserBindProvider.getByUserId(user.getId(), UserSystemWideEnum.RHO_COMPANY.getCode());
        if (ObjectUtils.isNull((Object)sysUserBind) || StringUtils.isBlank((CharSequence)sysUserBind.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (!PhoneUtil.isMobile((CharSequence)sysUserBind.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        String vcode = StringUtils.getRandomNum((int)6);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u6839\u636e\u7528\u6237\u540d\u53d1\u9001\u77ed\u4fe1\uff08\u672a\u767b\u5f55\uff09\u767b\u5f55\u7b2c\u4e8c\u6b65 \u9a8c\u8bc1\u7801\uff1a{}", (Object)vcode);
        }
        this.loginService.setCaptchaCache(vcode, sysUserBind.getBindTel(), tempAuthToken);
        this.smsProviderWelinkService.singleSendSms(sysUserBind.getBindTel(), String.format("\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u767b\u5f55\u201d\u653e\u5c04\u536b\u751f\u5728\u7ebf\u00b7\u653e\u5c04\u8bca\u7597\u673a\u6784\u7aef\u201c\uff0c\u767b\u5f55\u9a8c\u8bc1\u7801\u4e3a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", vcode));
        return ResponseData.success((String)String.format("\u5df2\u5411\u5f53\u524d\u8d26\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7%s\uff0c\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536", DesensitizationUtils.desensitized((CharSequence)sysUserBind.getBindTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE)), (Object)tempAuthToken);
    }

    @RequestLimit(second=60, maxCount=1)
    @PostMapping(value={"vSmsCodeByUsernameForForgetPwd"})
    public ResponseData<String> vSmsCodeByUsernameForForgetPwd(String username, Long cid) {
        if (StringUtils.isBlank((CharSequence)username) && ObjectUtils.isNull((Object)cid)) {
            return ResponseData.fail();
        }
        SysUser user = StringUtils.isNotBlank((CharSequence)username) ? this.sysUserServiceProvider.getUserByUsername(username) : this.sysUserServiceProvider.getManagerUserByCid(cid);
        if (ObjectUtils.isNull((Object)user)) {
            return ResponseData.fail((String)ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        }
        SysUserBind sysUserBind = this.sysUserBindProvider.getByUserId(user.getId(), UserSystemWideEnum.RHO_COMPANY.getCode());
        if (ObjectUtils.isNull((Object)sysUserBind) || StringUtils.isBlank((CharSequence)sysUserBind.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u901a\u8fc7\u6280\u672f\u652f\u6301\u7fa4\u8054\u7cfb\u5ba2\u670d\u91cd\u7f6e\u5bc6\u7801");
        }
        if (!PhoneUtil.isMobile((CharSequence)sysUserBind.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        String vcode = StringUtils.getRandomNum((int)6);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u53d1\u9001\u77ed\u4fe1\uff08\u672a\u767b\u5f55\uff09\u6839\u636e\u7528\u6237\u540d \u5fd8\u8bb0\u5bc6\u7801 \u9a8c\u8bc1\u7801\uff1a{}", (Object)vcode);
        }
        String tempAuthToken = ShiroCommonUtil.getRandomString();
        this.loginService.setCaptchaCache(vcode, sysUserBind.getBindTel(), tempAuthToken);
        this.smsProviderWelinkService.singleSendSms(sysUserBind.getBindTel(), String.format("\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u91cd\u7f6e\u201c\u653e\u5c04\u536b\u751f\u5728\u7ebf\u00b7\u653e\u5c04\u8bca\u7597\u673a\u6784\u7aef\u201d\u5bc6\u7801\uff0c\u9a8c\u8bc1\u7801\u4e3a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", vcode));
        return ResponseData.success((String)String.format("\u5df2\u5411\u5f53\u524d\u8d26\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7%s\uff0c\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536", DesensitizationUtils.desensitized((CharSequence)sysUserBind.getBindTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE)), (Object)tempAuthToken);
    }

    @RequestLimit(second=60, maxCount=1, expression="#tel")
    @PostMapping(value={"vSmsCodeByTelForBindApplication"})
    public ResponseData<String> vSmsCodeByTelForBindApplication(@NotBlank(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String tel, @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") String tempAuthToken) {
        if (!PhoneUtil.isMobile((CharSequence)tel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        SysUser user = this.loginService.getTempLoginInformationCache(tempAuthToken);
        SysUserBind sysUserBind = this.sysUserBindProvider.getByUserId(user.getId(), UserSystemWideEnum.RHO_COMPANY.getCode());
        if (ObjectUtils.isNull((Object)sysUserBind) || StringUtils.isBlank((CharSequence)sysUserBind.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (sysUserBind.getBindTel().equals(tel)) {
            return ResponseData.fail((String)"\u6362\u7ed1\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u7ed1\u5b9a\u624b\u673a\u53f7\u76f8\u540c");
        }
        String vcode = StringUtils.getRandomNum((int)6);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u53d1\u9001\u77ed\u4fe1\uff08\u672a\u767b\u5f55\uff09\u81ea\u884c\u8f93\u5165\u624b\u673a\u53f7 \u91cd\u65b0\u7ed1\u5b9a\u7533\u8bf7 \u9a8c\u8bc1\u7801\uff1a{}", (Object)vcode);
        }
        this.loginService.setCaptchaCache(vcode, tel, tempAuthToken);
        this.smsProviderWelinkService.singleSendSms(tel, String.format("\u3010\u6d59\u6c5f\u7701\u75be\u63a7\u5c40\u3011\u60a8\u6b63\u5728\u8fdb\u884c\u624b\u673a\u53f7\u6362\u7ed1\uff0c\u6362\u7ed1\u9a8c\u8bc1\u7801\u4e3a %s \uff08\u5207\u52ff\u544a\u77e5\u4ed6\u4eba\uff09\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u5c3d\u5feb\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", vcode));
        return ResponseData.success((String)"\u53d1\u9001\u6210\u529f", (Object)tempAuthToken);
    }

    @Generated
    public CaptchaController(LoginService loginService) {
        this.loginService = loginService;
    }
}

