/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller;

import cn.dev33.satoken.annotation.SaIgnore;
import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.hutool.crypto.digest.MD5;
import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.core.utils.ValidatorUtils;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.json.utils.JsonUtils;
import cn.smarthse.framework.limit.annotaion.RequestLimit;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.provider.log.ISysOperLogProviderService;
import cn.smarthse.modules.sys.entity.SysOperLog;
import cn.smarthse.modules.sys.enumd.BusinessStatusEnum;
import cn.smarthse.modules.sys.enumd.BusinessTypeEnum;
import cn.smarthse.modules.sys.enumd.OperatorDataSourceEnum;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.modules.uploader.FileResourceEnum;
import cn.smarthse.modules.uploader.FileUploadSimple;
import cn.smarthse.modules.uploader.UploadFileParameter;
import cn.smarthse.modules.uploader.UploadFilePathEnum;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.core.framework.constant.GrantTypeEnum;
import cn.smarthse.rho.core.framework.constant.VerifySituationEnum;
import cn.smarthse.rho.modules.company.bootstrap.security.model.dto.LoginBodyDTO;
import cn.smarthse.rho.modules.company.bootstrap.security.model.dto.LoginNextBodyDTO;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.LoginByCreditCodeVo;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.LoginVo;
import cn.smarthse.rho.modules.company.bootstrap.security.service.LoginService;
import cn.smarthse.rho.modules.company.model.uc.ChangeRebindApplicationNextParam;
import cn.smarthse.rho.modules.company.model.uc.ChangeRebindApplicationParam;
import cn.smarthse.rho.modules.company.model.uc.ForgetResetPwdNextParam;
import cn.smarthse.rho.modules.company.model.uc.ForgetResetPwdParam;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.entity.bind.SysUserBind;
import cn.smarthse.rho.modules.sys.entity.sys.SysFile;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.bind.ISysUserBindProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import cn.smarthse.rho.modules.sys.utils.file.FileXxsUtil;
import com.alibaba.fastjson2.JSON;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.constraints.NotBlank;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@SaIgnore
@RestController
@RequestMapping(value={"/auth"})
@Validated
public class AuthController
extends ControllerSupport {
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private final SysProperties sysProperties;
    private final OssClientBean ossClientBean;
    private final LoginService loginService;
    private final IBCompanyService companyService;
    @DubboReference
    private ISysFileProvider sysFileProvider;
    @DubboReference
    private ISysUserBindProvider sysUserBindProvider;
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;
    @DubboReference(registry={"public_nacos"})
    private ISysOperLogProviderService sysOperLogProviderService;

    @ApiEncrypt(request=true, response=true)
    @PostMapping(value={"login"})
    public ResponseData<LoginVo> login(@RequestBody String body) {
        LoginBodyDTO loginBody = (LoginBodyDTO)JsonUtils.parseObject((String)body, LoginBodyDTO.class);
        ValidatorUtils.validate((Object)loginBody, (Class[])new Class[0]);
        return ResponseData.success((String)"\u6821\u9a8c\u5b8c\u6bd5", (Object)this.loginService.login(body, loginBody.getGrantType()));
    }

    @ApiEncrypt(request=true, response=true)
    @PostMapping(value={"loginNext"})
    public ResponseData<LoginVo> loginNext(@RequestBody String body) {
        LoginNextBodyDTO loginBody = (LoginNextBodyDTO)JsonUtils.parseObject((String)body, LoginNextBodyDTO.class);
        ValidatorUtils.validate((Object)loginBody, (Class[])new Class[0]);
        return ResponseData.success((String)"\u767b\u5f55\u6210\u529f", (Object)this.loginService.loginNext(body, loginBody.getGrantType()));
    }

    @RequestLimit(expression="#creditCode")
    @PostMapping(value={"getByCreditCode"})
    public ResponseData<List<LoginByCreditCodeVo>> getByCreditCode(@NotBlank(message="\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a") String creditCode) {
        return ResponseData.success(this.companyService.getLoginByCreditCode(creditCode));
    }

    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module9)
    @Log(type=LogTypeEnum.type_cas_login, logModule=LogModuleTypeEnum.com_uc, title="\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u653e\u5c04\u8bca\u7597\u673a\u6784\u7aef")
    @PostMapping(value={"cas"})
    public ResponseData<LoginVo> loginByCas(@NotBlank(message="sign\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="sign\u4e0d\u80fd\u4e3a\u7a7a") String sign) {
        return ResponseData.success((String)"\u767b\u5f55\u6210\u529f", (Object)this.loginService.login(sign, GrantTypeEnum.CAS.getCode()));
    }

    @RequestLimit(maxCount=1, expression="#param.username + '_' + #param.cid")
    @PostMapping(value={"forgetPwd"})
    public ResponseData<String> forgetPwd(@Validated @RequestBody ForgetResetPwdParam param) {
        String code = param.getCode();
        String tempAuthToken = param.getTempAuthToken();
        String username = param.getUsername();
        Long cid = param.getCid();
        if (StringUtils.isBlank((CharSequence)username) && ObjectUtils.isNull((Object)cid)) {
            return ResponseData.fail();
        }
        SysUser user = StringUtils.isNotBlank((CharSequence)username) ? this.sysUserServiceProvider.getUserByUsername(username) : this.sysUserServiceProvider.getManagerUserByCid(cid);
        if (ObjectUtils.isNull((Object)user)) {
            return ResponseData.fail((String)ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        }
        SysUserBind sysUserBind = this.sysUserBindProvider.getByUserId(user.getId(), UserSystemWideEnum.RHO_COMPANY.getCode());
        if (ObjectUtils.isNull((Object)sysUserBind) || StringUtils.isBlank((CharSequence)sysUserBind.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u901a\u8fc7\u6280\u672f\u652f\u6301\u7fa4\u8054\u7cfb\u5ba2\u670d\u91cd\u7f6e\u5bc6\u7801");
        }
        if (!PhoneUtil.isMobile((CharSequence)sysUserBind.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        this.loginService.validateCaptcha(code, sysUserBind.getBindTel(), tempAuthToken);
        tempAuthToken = this.loginService.setTempLoginInformationCache(user);
        return ResponseData.success((String)"\u6821\u9a8c\u5b8c\u6bd5", (Object)tempAuthToken);
    }

    @ApiEncrypt(request=true)
    @RequestLimit(maxCount=1, expression="#param.tempAuthToken")
    @PostMapping(value={"forgetPwdCodeNext"})
    public ResponseData<String> forgetPwdCodeNext(HttpServletRequest request, @Validated @RequestBody ForgetResetPwdNextParam param) {
        boolean exception = false;
        SysUser user = null;
        try {
            user = this.loginService.getTempLoginInformationCache(param.getTempAuthToken());
            this.sysUserServiceProvider.modifyPasswordByPhone(user.getId(), param.getPassword());
        }
        catch (Exception e) {
            exception = true;
            throw e;
        }
        finally {
            if (!exception && user != null) {
                this.addPassLog(request, user, param);
            }
        }
        return ResponseData.success((String)"\u4fee\u6539\u6210\u529f");
    }

    private void addPassLog(HttpServletRequest request, SysUser user, ForgetResetPwdNextParam param) {
        Date date = new Date();
        SysOperLog passLog = new SysOperLog();
        passLog.setTitle("\u5bc6\u7801\u53d8\u66f4");
        passLog.setBusinessType(BusinessTypeEnum.CHANGEPASSWORD.getValue());
        passLog.setCid(user.getCid());
        passLog.setUserName(user.getUsername());
        passLog.setOperName(user.getUsername());
        passLog.setMethod(StringUtils.substring((String)"cn.smarthse.rho.modules.company.controller.AuthController.forgetPwdCodeNext()", (int)0, (int)255));
        passLog.setRequestMethod(request.getMethod());
        passLog.setOperUrl(ServletUtils.getRequestUri((HttpServletRequest)request));
        passLog.setOperIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        passLog.setOperParam(StringUtils.substring((String)JSON.toJSONString((Object)param), (int)0, (int)255));
        passLog.setJsonResult(null);
        passLog.setStatus(BusinessStatusEnum.SUCCESS.getValue());
        passLog.setErrorMsg(null);
        passLog.setIsValid(Boolean.valueOf(true));
        passLog.setCreateBy(user.getId());
        passLog.setCreateDate(date);
        passLog.setUpdateBy(user.getId());
        passLog.setUpdateDate(date);
        passLog.setPassword(user.getPassword());
        passLog.setDataOf(OperatorDataSourceEnum.RHO_COMPANY.getValue());
        passLog.setDataSource(OperatorDataSourceEnum.RHO_COMPANY.getValue());
        this.threadPoolTaskExecutor.execute(() -> this.sysOperLogProviderService.insertOperlog(passLog));
    }

    @ResponseBody
    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseData<SysFileVo> upload(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData, @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="tempAuthToken\u4e0d\u80fd\u4e3a\u7a7a") String tempAuthToken) throws IOException {
        SysUser user = this.loginService.getTempLoginInformationCache(tempAuthToken);
        String type = FileTypeUtil.getType((InputStream)fileData.getInputStream(), (boolean)true);
        if (!this.sysProperties.getSupportFileTypes().contains(type)) {
            return ResponseData.fail((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff01");
        }
        long size = fileData.getSize();
        String hashCode = MD5.create().digestHex(fileData.getBytes());
        SysFileVo existSysFile = this.sysFileProvider.getFileByHash(hashCode);
        if (existSysFile != null) {
            return ResponseData.success((String)"\u6587\u4ef6\u4e0a\u4f20\u6210\u529f(hash\u503c\u5b58\u5728)\uff01", (Object)existSysFile);
        }
        String originalFilename = FileXxsUtil.excludeXxsFileName((String)fileData.getOriginalFilename());
        String uploadFile = UploadFileParameter.FILE_PATH + FileResourceEnum.rho_supervise.getCode() + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator + String.valueOf(UUID.randomUUID()) + "-" + originalFilename;
        SysFile file = new SysFile();
        file.setCid(user.getCid());
        file.setResource(Integer.valueOf(FileResourceEnum.rho_supervise.getValue()));
        file.setFileName(originalFilename);
        file.setFileSize(Long.valueOf(size));
        file.setFileExt(FileUtil.getSuffix((String)originalFilename));
        file.setFileHash(hashCode);
        file.setCreatorIp(ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]));
        file.setOssUrl(this.ossClientBean.OSSPutObject(uploadFile, originalFilename, fileData.getInputStream()));
        return ResponseData.success((String)"\u4e0a\u4f20\u6210\u529f\uff01", (Object)this.sysFileProvider.addSysFile(file, user.getId()));
    }

    @RequestLimit(maxCount=1, expression="#param.username + '_' + #param.cid")
    @PostMapping(value={"rebindApplication"})
    public ResponseData<LoginVo> rebindApplication(@Validated @RequestBody ChangeRebindApplicationParam param) {
        String code = param.getCode();
        String tempAuthToken = param.getTempAuthToken();
        String username = param.getUsername();
        Long cid = param.getCid();
        this.loginService.validateCaptcha(code, tempAuthToken);
        if (StringUtils.isBlank((CharSequence)username) && ObjectUtils.isNull((Object)cid)) {
            return ResponseData.fail(null);
        }
        SysUser user = StringUtils.isNotBlank((CharSequence)username) ? this.sysUserServiceProvider.getUserByUsername(username) : this.sysUserServiceProvider.getManagerUserByCid(cid);
        if (ObjectUtils.isNull((Object)user)) {
            return ResponseData.fail((String)ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        }
        SysUserBind sysUserBind = this.sysUserBindProvider.getByUserId(user.getId(), UserSystemWideEnum.RHO_COMPANY.getCode());
        if (ObjectUtils.isNull((Object)sysUserBind) || StringUtils.isBlank((CharSequence)sysUserBind.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        tempAuthToken = this.loginService.setTempLoginInformationCache(user);
        return ResponseData.success((String)"\u6821\u9a8c\u5b8c\u6bd5", (Object)new LoginVo(StringUtils.isBlank((CharSequence)sysUserBind.getBindTel()) ? VerifySituationEnum.PASSWORD_UNVERIFIED_NO_PHONE : VerifySituationEnum.PASSWORD_UNVERIFIED_WITH_PHONE, user.getUsername(), sysUserBind.getBindTel(), tempAuthToken, null));
    }

    @ApiEncrypt(request=true)
    @RequestLimit(maxCount=1, expression="#param.bindTel")
    @PostMapping(value={"rebindApplicationNext"})
    public ResponseData<String> rebindApplicationNext(@Validated @RequestBody ChangeRebindApplicationNextParam param) {
        String tempAuthToken = param.getTempAuthToken();
        String code = param.getCode();
        Long fileId = param.getFileId();
        String bindTel = param.getBindTel();
        String bindName = param.getBindName();
        if (!PhoneUtil.isMobile((CharSequence)bindTel)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        this.loginService.validateCaptcha(code, bindTel, tempAuthToken);
        SysUser user = this.loginService.getTempLoginInformationCache(tempAuthToken);
        SysUserBind sysUserBind = this.sysUserBindProvider.getByUserId(user.getId(), UserSystemWideEnum.RHO_COMPANY.getCode());
        if (ObjectUtils.isNull((Object)sysUserBind) || StringUtils.isBlank((CharSequence)sysUserBind.getBindTel())) {
            return ResponseData.fail((String)"\u5f53\u524d\u8d26\u53f7\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (sysUserBind.getBindTel().equals(bindTel)) {
            return ResponseData.fail((String)"\u6362\u7ed1\u624b\u673a\u53f7\u4e0e\u5f53\u524d\u7ed1\u5b9a\u624b\u673a\u53f7\u76f8\u540c");
        }
        this.sysUserBindProvider.bindApplication(user.getId(), bindName, bindTel, fileId);
        return ResponseData.success((String)"\u91cd\u65b0\u7ed1\u5b9a\u7533\u8bf7\u63d0\u4ea4\u6210\u529f");
    }

    @Generated
    public AuthController(ThreadPoolTaskExecutor threadPoolTaskExecutor, SysProperties sysProperties, OssClientBean ossClientBean, LoginService loginService, IBCompanyService companyService) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
        this.sysProperties = sysProperties;
        this.ossClientBean = ossClientBean;
        this.loginService = loginService;
        this.companyService = companyService;
    }
}

