/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.security.utils;

import cn.dev33.satoken.exception.NotLoginException;
import cn.dev33.satoken.stp.StpUtil;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.modules.company.bootstrap.security.model.LoginSysUser;
import java.util.Map;
import lombok.Generated;

public class ShiroUtil
extends ShiroCommonUtil {
    public static final String SUPERVISE_AREA_KEY = "superviseArea";
    public static final String SUPERVISE_USERID_KEY = "superviseUserId";
    public static final String SUPERVISE_USERNAME_KEY = "superviseUsername";
    public static final String AFTER_SELECT_COMPANY_CID_KEY = "afterSelectCompanyCid";
    public static final String AFTER_SELECT_COMPANY_NAME_KEY = "afterSelectCompanyName";
    public static final String AFTER_SELECT_COMPANY_ADDRESS_TYPE_KEY = "afterSelectCompanyAddressType";

    public static LoginSysUser getShiroPrincipalDesensitization(LoginSysUser principal) {
        if (ObjectUtils.isNull((Object)((Object)principal))) {
            return null;
        }
        principal.setUsername(DesensitizationUtils.desensitized((CharSequence)principal.getUsername(), (DesensitizationType)DesensitizationType.NAME));
        principal.setFullName(DesensitizationUtils.desensitized((CharSequence)principal.getFullName(), (DesensitizationType)DesensitizationType.NAME));
        principal.setBindName(DesensitizationUtils.desensitized((CharSequence)principal.getBindName(), (DesensitizationType)DesensitizationType.NAME));
        principal.setBindTel(DesensitizationUtils.desensitized((CharSequence)principal.getBindTel(), (DesensitizationType)DesensitizationType.MOBILE_PHONE));
        return principal;
    }

    public static LoginSysUser getLoginUser() {
        return (LoginSysUser)ShiroUtil.getShiroPrincipal();
    }

    public static Object getLoginId(Long userId) {
        return ShiroUtil.getLoginId((String)"company", (Long)userId);
    }

    public static void logout() {
        try {
            LoginSysUser loginUser = (LoginSysUser)ShiroUtil.getShiroPrincipal();
            if (ObjectUtils.isNull((Object)((Object)loginUser))) {
                // empty if block
            }
        }
        catch (NotLoginException notLoginException) {
        }
        finally {
            try {
                StpUtil.logout();
            }
            catch (NotLoginException notLoginException) {}
        }
    }

    public static void logout(Long userId) {
        try {
            StpUtil.logout((Object)ShiroUtil.getLoginId(userId));
        }
        catch (NotLoginException notLoginException) {
            // empty catch block
        }
    }

    public static Long getLoginUserCid() {
        LoginSysUser principal = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (principal == null) {
            return ShiroUtil.getJWTOidOrCid();
        }
        Map extraData = principal.getExtraData();
        if (extraData == null) {
            return ShiroUtil.getJWTOidOrCid();
        }
        Long afterSelectCompanyCid = (Long)principal.getExtraData().get(AFTER_SELECT_COMPANY_CID_KEY);
        return afterSelectCompanyCid != null ? afterSelectCompanyCid : ShiroUtil.getJWTOidOrCid();
    }

    public static String getLoginUserCompanyName() {
        LoginSysUser principal = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (principal == null) {
            return null;
        }
        Map extraData = principal.getExtraData();
        if (extraData == null) {
            return principal.getCompanyName();
        }
        String afterSelectCompanyName = (String)principal.getExtraData().get(AFTER_SELECT_COMPANY_NAME_KEY);
        return afterSelectCompanyName != null ? afterSelectCompanyName : principal.getCompanyName();
    }

    public static String getLoginMedicalNucode() {
        LoginSysUser user = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        return user != null ? user.getMedicalNucode() : null;
    }

    public static SysAreaV3OneVo getLoginUserArea() {
        LoginSysUser user = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        return user != null ? user.getSysArea() : null;
    }

    public static Long getLoginUserSuperuserId() {
        LoginSysUser principal = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (principal == null) {
            return ShiroUtil.getJWTUserId();
        }
        Map extraData = principal.getExtraData();
        if (extraData == null) {
            return ShiroUtil.getJWTUserId();
        }
        Long superuserId = (Long)principal.getExtraData().get(SUPERVISE_USERID_KEY);
        return superuserId != null ? superuserId : ShiroUtil.getJWTUserId();
    }

    public static String getLoginUserSuperuserName() {
        LoginSysUser principal = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (principal == null) {
            return ShiroUtil.getJWTUsername();
        }
        Map extraData = principal.getExtraData();
        if (extraData == null) {
            return ShiroUtil.getJWTUsername();
        }
        String superuserName = (String)principal.getExtraData().get(SUPERVISE_USERNAME_KEY);
        return superuserName != null ? superuserName : ShiroUtil.getJWTUsername();
    }

    @Generated
    private ShiroUtil() {
    }
}

