/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.security.service;

import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.stp.parameter.SaLoginParameter;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.service.PermissionService;
import cn.smarthse.framework.core.utils.ObjectUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.framework.core.utils.ValidatorUtils;
import cn.smarthse.framework.json.utils.JsonUtils;
import cn.smarthse.framework.redis.utils.RedisUtils;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.modules.sys.enumd.UserSystemWideEnum;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.LoginUser;
import cn.smarthse.rho.core.framework.ShiroCommonUtil;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.core.framework.constant.GrantTypeEnum;
import cn.smarthse.rho.core.framework.constant.LoginMethodEnum;
import cn.smarthse.rho.core.framework.constant.VerifySituationEnum;
import cn.smarthse.rho.core.framework.utils.AesUtil;
import cn.smarthse.rho.core.framework.utils.CommonsUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.model.LoginSysUser;
import cn.smarthse.rho.modules.company.bootstrap.security.model.dto.CidLoginBodyDTO;
import cn.smarthse.rho.modules.company.bootstrap.security.model.dto.CidNextLoginBodyDTO;
import cn.smarthse.rho.modules.company.bootstrap.security.model.dto.PasswordLoginBodyDTO;
import cn.smarthse.rho.modules.company.bootstrap.security.model.dto.PasswordNextLoginBodyDTO;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.LoginVo;
import cn.smarthse.rho.modules.company.bootstrap.security.service.PasswordMatcher;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.bind.SysUserBind;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.enums.user.UserResourceEnum;
import cn.smarthse.rho.modules.sys.provider.bind.ISysUserBindProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysRoleServiceProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    private static final String deviceType = "pc";
    private final SysProperties sysProperties;
    private final PermissionService permissionService;
    private final IBCompanyService companyService;
    @DubboReference
    private ISysUserBindProvider sysUserBindProvider;
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;
    @DubboReference
    private ISysRoleServiceProvider sysRoleServiceProvider;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;

    public LoginVo loginFinal(SysUser user, Integer loginMethod, String redirectUrl) {
        return this.loginFinal(user, loginMethod, redirectUrl, null);
    }

    public LoginVo loginFinal(SysUser user, Integer loginMethod, String redirectUrl, Map<String, Object> extraData) {
        LoginSysUser loginUser = this.buildLoginUser(user);
        loginUser.setExtra("afterSelectCompanyCid", loginUser.getCid());
        loginUser.setExtra("afterSelectCompanyName", loginUser.getCompanyName());
        loginUser.setExtra("afterSelectCompanyAddressType", loginUser.getAddressType());
        loginUser.setUserType("company");
        loginUser.setLoginMethod(loginMethod);
        loginUser.setTwoFactorCheck((byte)0);
        loginUser.setExtras(extraData);
        loginUser.setOidOrcid(loginUser.getCid());
        SaLoginParameter model = new SaLoginParameter();
        model.setDeviceType(deviceType);
        model.setTimeout(this.sysProperties.getLogin().getTimeout().longValue());
        model.setActiveTimeout(this.sysProperties.getLogin().getActiveTimeout().longValue());
        ShiroUtil.login((LoginUser)loginUser, (SaLoginParameter)model);
        return new LoginVo(VerifySituationEnum.VERIFIED, loginUser.getUsername(), loginUser.getBindTel(), StpUtil.getTokenValue(), redirectUrl);
    }

    public LoginVo login(String body, String grantType) {
        GrantTypeEnum grantTypeEnum = GrantTypeEnum.fromCode((String)grantType);
        if (ObjectUtils.isNull((Object)grantTypeEnum)) {
            throw new ServiceException(ResponseStateEnum.BAD_REQUEST.getValue(), ResponseStateEnum.BAD_REQUEST.getName());
        }
        return switch (grantTypeEnum) {
            case GrantTypeEnum.PASSWORD -> this.loginByPassword((PasswordLoginBodyDTO)JsonUtils.parseObject((String)body, PasswordLoginBodyDTO.class));
            case GrantTypeEnum.CID -> this.loginByCid((CidLoginBodyDTO)JsonUtils.parseObject((String)body, CidLoginBodyDTO.class));
            case GrantTypeEnum.CAS -> this.loginByCas(body);
            default -> throw new ServiceException(ResponseStateEnum.BAD_REQUEST.getValue(), ResponseStateEnum.BAD_REQUEST.getName());
        };
    }

    public LoginVo loginByPassword(PasswordLoginBodyDTO loginBody) {
        ValidatorUtils.validate((Object)loginBody, (Class[])new Class[0]);
        String username = loginBody.getUsername();
        String password = loginBody.getPassword();
        String code = loginBody.getCode();
        String uuid = loginBody.getUuid();
        String redirectUrl = loginBody.getRedirectUrl();
        this.validateCaptcha(code, uuid);
        SysUser user = this.loadUserByUsername(username);
        this.checkLogin(username, () -> !PasswordMatcher.matchPassword(password, user.getPassword(), user.getSalt()));
        if (user.getTwoFactorCheck() == 0) {
            return this.loginFinal(user, LoginMethodEnum.LOGIN_USERNAME_PASSWORD.getCode(), redirectUrl);
        }
        String tempAuthToken = ShiroCommonUtil.getRandomString();
        String verifyKey = "global:temp:login:information:" + StringUtils.blankToDefault((String)tempAuthToken, (String)"");
        RedisUtils.setCacheObject((String)verifyKey, (Object)user, (Duration)Constant.TEMP_EXPIRATION);
        String bindTel = user.getBindTel();
        return new LoginVo(StringUtils.isBlank((CharSequence)bindTel) ? VerifySituationEnum.PASSWORD_UNVERIFIED_NO_PHONE : VerifySituationEnum.PASSWORD_UNVERIFIED_WITH_PHONE, user.getUsername(), bindTel, tempAuthToken, redirectUrl);
    }

    public LoginVo loginByCid(CidLoginBodyDTO loginBody) {
        ValidatorUtils.validate((Object)loginBody, (Class[])new Class[0]);
        Long cid = loginBody.getCid();
        String password = loginBody.getPassword();
        String code = loginBody.getCode();
        String uuid = loginBody.getUuid();
        String redirectUrl = loginBody.getRedirectUrl();
        this.validateCaptcha(code, uuid);
        SysUser user = this.loadUserByCid(cid);
        this.checkLogin(user.getUsername(), () -> !PasswordMatcher.matchPassword(password, user.getPassword(), user.getSalt()));
        if (user.getTwoFactorCheck() == 0) {
            return this.loginFinal(user, LoginMethodEnum.LOGIN_USERNAME_PASSWORD.getCode(), redirectUrl);
        }
        String tempAuthToken = ShiroCommonUtil.getRandomString();
        String verifyKey = "global:temp:login:information:" + StringUtils.blankToDefault((String)tempAuthToken, (String)"");
        RedisUtils.setCacheObject((String)verifyKey, (Object)user, (Duration)Constant.TEMP_EXPIRATION);
        String bindTel = user.getBindTel();
        return new LoginVo(StringUtils.isBlank((CharSequence)bindTel) ? VerifySituationEnum.PASSWORD_UNVERIFIED_NO_PHONE : VerifySituationEnum.PASSWORD_UNVERIFIED_WITH_PHONE, user.getUsername(), bindTel, tempAuthToken, redirectUrl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LoginVo loginByCas(String tempAuthToken) {
        OrganizationUser orgUser;
        String decrypt = AesUtil.decrypt((String)tempAuthToken, (String)this.sysProperties.healthOnlineTrainingAesKey);
        if (StringUtils.isBlank((CharSequence)decrypt)) {
            throw new ServiceException(ResponseStateEnum.CREDENTIALS_EXPIRED.getValue(), "sign\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)decrypt);
        Long time = (Long)jsonObject.getObject("time", Long.class, new JSONReader.Feature[0]);
        String redirectUrl = (String)jsonObject.getObject("redirectUrl", String.class, new JSONReader.Feature[0]);
        Long cid = (Long)jsonObject.getObject("cid", Long.class, new JSONReader.Feature[0]);
        Long superuserId = (Long)jsonObject.getObject("superuserId", Long.class, new JSONReader.Feature[0]);
        Integer userResource = (Integer)jsonObject.getObject("userResource", Integer.class, new JSONReader.Feature[0]);
        if (ObjectUtils.isNull((Object)time) || System.currentTimeMillis() - time > Constant.TEMP_TOKEN_TIMEOUT) {
            throw new ServiceException(ResponseStateEnum.ACCOUNT_EXPIRED.getValue(), "sign\u5931\u6548\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7");
        }
        if (ObjectUtils.isNull((Object)UserResourceEnum.getName((Integer)userResource))) {
            throw new ServiceException(ResponseStateEnum.CREDENTIALS_EXPIRED.getValue(), "\u5355\u70b9\u7528\u6237\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7");
        }
        String username = UserResourceEnum.getState((Integer)userResource).getMark() + ":" + cid + ":" + superuserId;
        SysUser user = this.sysUserServiceProvider.getUserByUsername(username);
        if (ObjectUtils.isNull((Object)user)) {
            log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u4e0d\u5b58\u5728.", (Object)username);
            if (!UserResourceEnum.SUPERVISE_SINGLE_ADD.getValue().equals(userResource)) throw new ServiceException(ResponseStateEnum.CREDENTIALS_EXPIRED.getValue(), "\u5355\u70b9\u7528\u6237\u7c7b\u578b\u4e0d\u5b58\u5728");
            orgUser = this.organizationUserService.getUserInfoById(superuserId);
            if (ObjectUtils.isNull((Object)orgUser)) {
                throw new ServiceException(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getValue(), ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
            }
            user = this.sysUserServiceProvider.addUserForSuperCas(cid, username, orgUser.getUsername(), (Long)orgUser.getRoleList().iterator().next());
        } else {
            orgUser = this.organizationUserService.getUserInfoById(superuserId);
            if (ObjectUtils.isNull((Object)orgUser)) {
                throw new ServiceException(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getValue(), ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
            }
        }
        if (Constant.ACTIVE_YES.equals(user.getIsForbidden())) {
            throw new ServiceException(ResponseStateEnum.ACCOUNT_DISABLED.getValue(), ResponseStateEnum.ACCOUNT_DISABLED.getName());
        }
        HashMap<String, Object> extraData = new HashMap<String, Object>();
        extraData.put("superviseUserId", superuserId);
        extraData.put("superviseUsername", orgUser.getUsername());
        extraData.put("superviseArea", this.sysAreaProvideService.getAreaByIdV3(orgUser.getOrganization().getAreaId()));
        return this.loginFinal(user, LoginMethodEnum.LOGIN_CAS.getCode(), redirectUrl, extraData);
    }

    public LoginVo loginNext(String body, String grantType) {
        GrantTypeEnum grantTypeEnum = GrantTypeEnum.fromCode((String)grantType);
        if (ObjectUtils.isNull((Object)grantTypeEnum)) {
            throw new ServiceException(ResponseStateEnum.BAD_REQUEST.getValue(), ResponseStateEnum.BAD_REQUEST.getName());
        }
        return switch (grantTypeEnum) {
            case GrantTypeEnum.PASSWORD -> this.loginNextByPassword((PasswordNextLoginBodyDTO)JsonUtils.parseObject((String)body, PasswordNextLoginBodyDTO.class));
            case GrantTypeEnum.CID -> this.loginNextByCid((CidNextLoginBodyDTO)JsonUtils.parseObject((String)body, CidNextLoginBodyDTO.class));
            default -> throw new ServiceException(ResponseStateEnum.BAD_REQUEST.getValue(), ResponseStateEnum.BAD_REQUEST.getName());
        };
    }

    public LoginVo loginNextByPassword(PasswordNextLoginBodyDTO loginBody) {
        ValidatorUtils.validate((Object)loginBody, (Class[])new Class[0]);
        String tempAuthToken = loginBody.getTempAuthToken();
        String code = loginBody.getCode();
        String redirectUrl = loginBody.getRedirectUrl();
        String bindTel = loginBody.getBindTel();
        String bindName = loginBody.getBindName();
        String verifyKey = "global:temp:login:information:" + StringUtils.blankToDefault((String)tempAuthToken, (String)"");
        SysUser user = (SysUser)RedisUtils.getCacheObject((String)verifyKey);
        if (ObjectUtils.isNull((Object)user)) {
            throw new ServiceException(ResponseStateEnum.CREDENTIALS_EXPIRED.getValue(), ResponseStateEnum.CREDENTIALS_EXPIRED.getName());
        }
        if (StringUtils.isBlank((CharSequence)user.getBindTel())) {
            if (StringUtils.isBlank((CharSequence)bindTel)) {
                throw new ServiceException("\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.validateCaptcha(code, bindTel, tempAuthToken);
            if (!PhoneUtil.isMobile((CharSequence)bindTel)) {
                throw new ServiceException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
            }
            if (!CommonsUtils.isValidBindName((String)bindName)) {
                throw new ServiceException("\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u59d3\u540d\u683c\u5f0f\uff1a\u4e2d\u6587\u6216\u82f1\u6587\uff0c\u4e0d\u5141\u8bb8\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u3001\u4e2d\u95f4\u7a7a\u683c");
            }
            this.sysUserBindProvider.bind(user.getId(), bindName, bindTel);
            user.setBindName(bindName);
            user.setBindTel(bindTel);
        } else {
            this.validateCaptcha(code, user.getBindTel(), tempAuthToken);
        }
        return this.loginFinal(user, LoginMethodEnum.LOGIN_USERNAME_PASSWORD.getCode(), redirectUrl);
    }

    public LoginVo loginNextByCid(CidNextLoginBodyDTO loginBody) {
        ValidatorUtils.validate((Object)loginBody, (Class[])new Class[0]);
        String tempAuthToken = loginBody.getTempAuthToken();
        String code = loginBody.getCode();
        String redirectUrl = loginBody.getRedirectUrl();
        String bindTel = loginBody.getBindTel();
        String bindName = loginBody.getBindName();
        String verifyKey = "global:temp:login:information:" + StringUtils.blankToDefault((String)tempAuthToken, (String)"");
        SysUser user = (SysUser)RedisUtils.getCacheObject((String)verifyKey);
        if (ObjectUtils.isNull((Object)user)) {
            throw new ServiceException(ResponseStateEnum.CREDENTIALS_EXPIRED.getValue(), ResponseStateEnum.CREDENTIALS_EXPIRED.getName());
        }
        if (StringUtils.isBlank((CharSequence)user.getBindTel())) {
            if (StringUtils.isBlank((CharSequence)bindTel)) {
                throw new ServiceException("\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.validateCaptcha(code, bindTel, tempAuthToken);
            if (!PhoneUtil.isMobile((CharSequence)bindTel)) {
                throw new ServiceException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
            }
            if (!CommonsUtils.isValidBindName((String)bindName)) {
                throw new ServiceException("\u653e\u5c04\u8bca\u7597\u673a\u6784\u8054\u7cfb\u4eba\u59d3\u540d\u683c\u5f0f\uff1a\u4e2d\u6587\u6216\u82f1\u6587\uff0c\u4e0d\u5141\u8bb8\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u3001\u4e2d\u95f4\u7a7a\u683c");
            }
            this.sysUserBindProvider.bind(user.getId(), bindName, bindTel);
            user.setBindName(bindName);
            user.setBindTel(bindTel);
        } else {
            this.validateCaptcha(code, user.getBindTel(), tempAuthToken);
        }
        return this.loginFinal(user, LoginMethodEnum.LOGIN_USERNAME_PASSWORD.getCode(), redirectUrl);
    }

    public void setCaptchaCache(String code, String ... uuids) {
        if (uuids.length == 0) {
            throw new ServiceException("\u81f3\u5c11\u9700\u8981\u4e00\u4e2auuid");
        }
        String combinedUuid = String.join((CharSequence)":", uuids);
        String verifyKey = "global:captcha_codes:" + StringUtils.blankToDefault((String)combinedUuid, (String)"");
        RedisUtils.setCacheObject((String)verifyKey, (Object)code, (Duration)Duration.ofMinutes(5L));
    }

    public void validateCaptcha(String code, String ... uuids) {
        if (uuids.length == 0) {
            throw new ServiceException("\u81f3\u5c11\u9700\u8981\u4e00\u4e2auuid");
        }
        String combinedUuid = String.join((CharSequence)":", uuids);
        String verifyKey = "global:captcha_codes:" + StringUtils.blankToDefault((String)combinedUuid, (String)"");
        String captcha = (String)RedisUtils.getCacheObject((String)verifyKey);
        if (ObjectUtils.isNull((Object)captcha)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5df2\u5931\u6548");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)code, (CharSequence)captcha)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }

    public String setTempLoginInformationCache(SysUser user) {
        if (ObjectUtils.isNull((Object)user)) {
            throw new ServiceException(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        }
        String tempAuthToken = ShiroCommonUtil.getRandomString();
        String verifyKey = "global:temp:login:information:" + StringUtils.blankToDefault((String)tempAuthToken, (String)"");
        RedisUtils.setCacheObject((String)verifyKey, (Object)user, (Duration)Constant.TEMP_EXPIRATION);
        return tempAuthToken;
    }

    public SysUser getTempLoginInformationCache(String tempAuthToken) {
        String verifyKey = "global:temp:login:information:" + StringUtils.blankToDefault((String)tempAuthToken, (String)"");
        SysUser user = (SysUser)RedisUtils.getCacheObject((String)verifyKey);
        if (ObjectUtils.isNull((Object)user)) {
            throw new ServiceException(ResponseStateEnum.CREDENTIALS_EXPIRED.getValue(), ResponseStateEnum.CREDENTIALS_EXPIRED.getName());
        }
        return user;
    }

    private SysUser loadUserByUsername(String username) {
        SysUserBind sysUserBind;
        SysUser user = this.sysUserServiceProvider.getUserByUsername(username);
        if (ObjectUtils.isNull((Object)user)) {
            log.info("\u767b\u5f55\u7528\u6237\uff1a{} \u4e0d\u5b58\u5728.", (Object)username);
            throw new ServiceException(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getValue(), ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        }
        if (Constant.ACTIVE_YES.equals(user.getIsForbidden())) {
            throw new ServiceException(ResponseStateEnum.ACCOUNT_DISABLED.getValue(), ResponseStateEnum.ACCOUNT_DISABLED.getName());
        }
        if (!this.sysProperties.getLogin().isTwoFactorCheck()) {
            user.setTwoFactorCheck(Byte.valueOf((byte)0));
        }
        if (Objects.nonNull(sysUserBind = this.sysUserBindProvider.getByUserId(user.getId(), UserSystemWideEnum.RHO_COMPANY.getCode()))) {
            user.setBindName(sysUserBind.getBindName());
            user.setBindTel(sysUserBind.getBindTel());
        }
        return user;
    }

    private SysUser loadUserByCid(Long cid) {
        SysUserBind sysUserBind;
        SysUser user = this.sysUserServiceProvider.getManagerUserByCid(cid);
        if (ObjectUtils.isNull((Object)user)) {
            log.info("\u767b\u5f55cid\uff1a{}\uff0c\u5bf9\u5e94\u7528\u6237\u4e0d\u5b58\u5728.", (Object)cid);
            throw new ServiceException(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getValue(), ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        }
        if (Constant.ACTIVE_YES.equals(user.getIsForbidden())) {
            throw new ServiceException(ResponseStateEnum.ACCOUNT_DISABLED.getValue(), ResponseStateEnum.ACCOUNT_DISABLED.getName());
        }
        if (!this.sysProperties.getLogin().isTwoFactorCheck()) {
            user.setTwoFactorCheck(Byte.valueOf((byte)0));
        }
        if (Objects.nonNull(sysUserBind = this.sysUserBindProvider.getByUserId(user.getId(), UserSystemWideEnum.RHO_COMPANY.getCode()))) {
            user.setBindName(sysUserBind.getBindName());
            user.setBindTel(sysUserBind.getBindTel());
        }
        return user;
    }

    private void checkLogin(String username, Supplier<Boolean> supplier) {
        String errorKey = "global:pwd_err_cnt:" + username;
        int errorNumber = (Integer)ObjectUtils.defaultIfNull((Object)((Integer)RedisUtils.getCacheObject((String)errorKey)), (Object)0);
        Integer maxRetryCount = this.sysProperties.getLogin().getRetryCount();
        Integer lockTime = this.sysProperties.getLogin().getRetryLockTime();
        if (errorNumber >= maxRetryCount) {
            throw new ServiceException(String.format("\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef%s\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7b49\u5f85%s\u5206\u949f\u518d\u5c1d\u8bd5\u767b\u5f55\uff0c\u5982\u6709\u7591\u95ee\u53ef\u8054\u7cfb\u5ba2\u670d\uff1a0571-89978771/89978775", maxRetryCount, lockTime));
        }
        if (supplier.get().booleanValue()) {
            RedisUtils.setCacheObject((String)errorKey, (Object)(++errorNumber), (Duration)Duration.ofMinutes(lockTime.intValue()));
            if (errorNumber == 3) {
                throw new ServiceException("\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef3\u6b21\uff0c\u82e5\u518d\u9519\u8bef2\u6b21\uff0c\u60a8\u7684\u8d26\u53f7\u5c06\u4f1a\u88ab\u9501\u5b9a30\u5206\u949f\uff0c\u5efa\u8bae\u60a8\u8054\u7cfb\u5ba2\u670d(0571-89978771/89978775)\u8fdb\u884c\u5bc6\u7801\u91cd\u7f6e");
            }
            if (errorNumber >= maxRetryCount) {
                throw new ServiceException(String.format("\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef%s\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7b49\u5f85%s\u5206\u949f\u518d\u5c1d\u8bd5\u767b\u5f55\uff0c\u5982\u6709\u7591\u95ee\u53ef\u8054\u7cfb\u5ba2\u670d\uff1a0571-89978771/89978775", maxRetryCount, lockTime));
            }
            throw new ServiceException(ResponseStateEnum.USERNAME_OR_PASSWORD_ERROR.getName());
        }
        RedisUtils.deleteObject((String)errorKey);
    }

    private LoginSysUser buildLoginUser(SysUser user) {
        Long userId = user.getId();
        if (ObjectUtils.isNull((Object)user) || ObjectUtils.isNull((Object)userId)) {
            throw new ServiceException(ResponseStateEnum.UNAUTHORIZED.getValue(), ResponseStateEnum.UNAUTHORIZED.getName());
        }
        LoginSysUser loginUser = new LoginSysUser();
        Set rolePermission = this.permissionService.getRolePermission(userId);
        if (CollUtil.isEmpty((Collection)rolePermission)) {
            throw new ServiceException(ResponseStateEnum.FORBIDDEN.getValue(), ResponseStateEnum.FORBIDDEN.getName());
        }
        loginUser.setRoleSet(rolePermission);
        Set menuPermission = this.permissionService.getMenuPermission(userId);
        if (CollUtil.isEmpty((Collection)menuPermission)) {
            throw new ServiceException(ResponseStateEnum.FORBIDDEN.getValue(), ResponseStateEnum.FORBIDDEN.getName());
        }
        loginUser.setPermissionsSet(menuPermission);
        BCompany company = (BCompany)this.companyService.getById(user.getCid());
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(company.getAreaId());
        if (ObjectUtils.isNull((Object)company) || ObjectUtils.isNull((Object)area)) {
            throw new ServiceException(ResponseStateEnum.FORBIDDEN.getValue(), ResponseStateEnum.FORBIDDEN.getName());
        }
        loginUser.setId(user.getId());
        loginUser.setUsername(user.getUsername());
        loginUser.setFullName(user.getNickname());
        loginUser.setCid(user.getCid());
        loginUser.setCompanyName(company.getName());
        loginUser.setAreaId(area.getId());
        loginUser.setAreaLevel(area.getLevel());
        loginUser.setIsTest(company.getIsTest());
        loginUser.setAddressType(company.getAddressType());
        loginUser.setMedicalNucode(company.getMedicalNucode());
        loginUser.setIsDefaultPwd(user.getIsDefaultPwd());
        loginUser.setChangePwDate(user.getChangePwDate());
        loginUser.setTwoFactorCheck(user.getTwoFactorCheck());
        loginUser.setRoleList(this.sysRoleServiceProvider.getRoleListByUserId(user.getId()));
        loginUser.setSysArea(area);
        loginUser.setBindName(user.getBindName());
        loginUser.setBindTel(user.getBindTel());
        return loginUser;
    }

    @Generated
    public LoginService(SysProperties sysProperties, PermissionService permissionService, IBCompanyService companyService) {
        this.sysProperties = sysProperties;
        this.permissionService = permissionService;
        this.companyService = companyService;
    }
}

