/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.config;

import cn.smarthse.framework.oss.config.properties.OssClientProperties;
import cn.smarthse.modules.datacentre.provider.bigdata.IBigDataLogProviderService;
import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.core.framework.filter.CommonFilter;
import cn.smarthse.rho.modules.company.bootstrap.interceptor.BigDataLogInterceptor;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class MvcConfig
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MvcConfig.class);
    private final OssClientProperties ossClientProperties;
    private final SysProperties sysProperties;
    @DubboReference(registry={"public_nacos"})
    private IBigDataLogProviderService bigDataLogProviderService;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"classpath:/static/"}).setCachePeriod(Integer.valueOf(3600)).resourceChain(true);
        registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:" + this.ossClientProperties.getLocal() + "upload/"});
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new BigDataLogInterceptor(this.sysProperties, this.bigDataLogProviderService)).addPathPatterns(new String[]{"/**"});
    }

    @Bean
    public FilterRegistrationBean<Filter> filterRegistrationCommon() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new CommonFilter());
        ArrayList<String> urlList = new ArrayList<String>();
        urlList.add("/*");
        registration.setUrlPatterns(urlList);
        registration.setName("CommonFilter");
        registration.setOrder(-2147483646);
        return registration;
    }

    @Generated
    public MvcConfig(OssClientProperties ossClientProperties, SysProperties sysProperties) {
        this.ossClientProperties = ossClientProperties;
        this.sysProperties = sysProperties;
    }
}

