/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.bootstrap.aop;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.core.utils.ServletUtils;
import cn.smarthse.framework.core.utils.SpringUtils;
import cn.smarthse.framework.core.utils.StringUtils;
import cn.smarthse.modules.datacentre.provider.log.ISysOperLogProviderService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.modules.sys.entity.SysOperLog;
import cn.smarthse.modules.sys.enumd.BusinessStatusEnum;
import cn.smarthse.modules.sys.enumd.BusinessTypeEnum;
import cn.smarthse.modules.sys.enumd.OperatorDataSourceEnum;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogResourceEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.IdParam;
import cn.smarthse.rho.modules.company.bootstrap.security.model.LoginSysUser;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.entity.sys.SysUser;
import cn.smarthse.rho.modules.sys.model.sys.param.SysLogAddParam;
import cn.smarthse.rho.modules.sys.provider.sys.ISysLogProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import com.alibaba.fastjson2.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Aspect
public class LogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @DubboReference
    private ISysLogProvider sysLogProvider;
    @DubboReference(registry={"public_nacos"})
    private ISysOperLogProviderService sysOperLogProviderService;

    @Pointcut(value="@annotation(cn.smarthse.rho.core.framework.annotation.Log)")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void doBefore(JoinPoint joinPoint) {
    }

    @AfterThrowing(value="pointcut()")
    public void doAfterThrowing(JoinPoint joinPoint) {
    }

    @AfterReturning(value="pointcut()", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, Object jsonResult) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Object[] args = joinPoint.getArgs();
        String[] paramNames = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof MultipartFile || args[i] instanceof HttpServletRequest || args[i] instanceof HttpServletResponse) continue;
                map.put(paramNames[i], args[i]);
            }
        }
        map.put("jsonResult", jsonResult);
        map.put("className", joinPoint.getTarget().getClass().getName());
        map.put("methodName", signature.getName());
        try {
            this.addLog(args, signature.getMethod().getAnnotation(Log.class), map);
        }
        catch (Exception e) {
            log.error("Exception: ", (Throwable)e);
        }
    }

    private void addLog(Object[] args, Log logAnno, Map<String, Object> map) {
        LoginSysUser principal = (LoginSysUser)ShiroUtil.getShiroPrincipal();
        if (principal == null) {
            return;
        }
        if (logAnno != null) {
            Long userId = principal.getId();
            String username = principal.getUsername();
            String fullName = principal.getFullName();
            SysAreaV3OneVo area = principal.getSysArea();
            Long cid = principal.getCid();
            HttpServletRequest request = ServletUtils.getRequest();
            String ip = ServletUtils.getClientIP((HttpServletRequest)request, (String[])new String[0]);
            String uri = ServletUtils.getRequestUri((HttpServletRequest)request);
            String userAgent = ServletUtils.getUserAgent((HttpServletRequest)request);
            if (logAnno.type() == LogTypeEnum.type_opt_reset || logAnno.type() == LogTypeEnum.type_opt_changePass) {
                Object object;
                Date date = new Date();
                SysOperLog passLog = new SysOperLog();
                passLog.setTitle("\u5bc6\u7801\u53d8\u66f4");
                if (logAnno.type() == LogTypeEnum.type_opt_reset) {
                    passLog.setBusinessType(BusinessTypeEnum.RESETPASSWORD.getValue());
                } else if (logAnno.type() == LogTypeEnum.type_opt_changePass) {
                    passLog.setBusinessType(BusinessTypeEnum.CHANGEPASSWORD.getValue());
                    passLog.setPassword((String)map.get("oldPassword"));
                }
                passLog.setOperName(username);
                passLog.setMethod(StringUtils.substring((String)(String.valueOf(map.get("className")) + "." + String.valueOf(map.get("methodName")) + "()"), (int)0, (int)255));
                passLog.setRequestMethod(request.getMethod());
                passLog.setOperUrl(uri);
                passLog.setOperIp(ip);
                if (map.containsKey("param")) {
                    passLog.setOperParam(StringUtils.substring((String)JSON.toJSONString((Object)map.get("param")), (int)0, (int)255));
                } else {
                    passLog.setOperParam(StringUtils.substring((String)JSON.toJSONString((Object)args), (int)0, (int)255));
                }
                String jsonResult = JSON.toJSONString((Object)map.get("jsonResult"));
                passLog.setJsonResult(StringUtils.substring((String)jsonResult, (int)0, (int)255));
                passLog.setStatus(Objects.equals(((ResponseData)JSON.parseObject((String)jsonResult, ResponseData.class)).getState(), ResponseStateEnum.success.getValue()) ? BusinessStatusEnum.SUCCESS.getValue() : BusinessStatusEnum.FAIL.getValue());
                passLog.setErrorMsg(null);
                passLog.setIsValid(Boolean.valueOf(true));
                passLog.setCreateBy(userId);
                passLog.setCreateDate(date);
                passLog.setUpdateBy(userId);
                passLog.setUpdateDate(date);
                passLog.setDataOf(OperatorDataSourceEnum.RHO_COMPANY.getValue());
                passLog.setDataSource(OperatorDataSourceEnum.RHO_COMPANY.getValue());
                if (map.containsKey("param") && (object = map.get("param")) instanceof IdParam) {
                    IdParam param = (IdParam)object;
                    SysUser user = ((ISysUserServiceProvider)SpringUtils.getBean(ISysUserServiceProvider.class)).getUserById(param.getId());
                    passLog.setCid(user.getCid());
                    passLog.setUserName(user.getUsername());
                } else {
                    passLog.setCid(cid);
                    passLog.setUserName(username);
                }
                if (this.threadPoolTaskExecutor != null) {
                    this.threadPoolTaskExecutor.execute(() -> this.sysOperLogProviderService.insertOperlog(passLog));
                } else {
                    this.sysOperLogProviderService.insertOperlog(passLog);
                }
            } else {
                LocalDateTime now = LocalDateTime.now();
                SysLogAddParam syslog = new SysLogAddParam();
                syslog.setUserId(userId);
                syslog.setUsername(username);
                syslog.setFullname(fullName);
                syslog.setProvinceId(area.getProvinceId());
                syslog.setCityId(area.getCityId());
                syslog.setAreaId(area.getAreaId());
                syslog.setStreetId(area.getStreetId());
                syslog.setDetailAreaId(area.getId());
                syslog.setCid(cid);
                syslog.setTitle(StringUtils.isBlank((CharSequence)logAnno.title()) ? logAnno.logModule().moduleName : logAnno.title());
                syslog.setResource(LogResourceEnum.company.value);
                syslog.setModuleType(logAnno.logModule().moduleType);
                syslog.setType(logAnno.type().value);
                syslog.setRemoteIp(ip);
                syslog.setUserAgent(userAgent);
                syslog.setRequestUri(uri);
                syslog.setRequestMethod(request.getMethod());
                syslog.setParams(StringUtils.substring((String)JSON.toJSONString(map), (int)0, (int)255));
                syslog.setCreateBy(userId);
                syslog.setCreateDate(now);
                syslog.setUpdateBy(userId);
                syslog.setUpdateDate(now);
                if (log.isDebugEnabled()) {
                    log.debug("LogAspect.addLog: [{}: {}]: {}, {}, {}, {}", new Object[]{userId, username, syslog.getTitle(), syslog.getRequestUri(), syslog.getRemoteIp(), syslog.getParams()});
                }
                if (this.threadPoolTaskExecutor != null) {
                    this.threadPoolTaskExecutor.execute(() -> this.sysLogProvider.addLog(syslog));
                } else {
                    this.sysLogProvider.addLog(syslog);
                }
            }
        }
    }

    private String invokeExpression(Method method, Object[] args, String expression) {
        if (StringUtils.isEmpty((String)expression)) {
            return null;
        }
        StandardEvaluationContext context = new StandardEvaluationContext();
        StandardReflectionParameterNameDiscoverer discoverer = new StandardReflectionParameterNameDiscoverer();
        String[] parameterNames = discoverer.getParameterNames(method);
        try {
            if (parameterNames != null) {
                for (int i = 0; i < parameterNames.length; ++i) {
                    context.setVariable(parameterNames[i], args[i]);
                }
            }
        }
        catch (Exception e) {
            log.error("invokeExpression\uff1a", (Throwable)e);
        }
        return String.valueOf(new SpelExpressionParser().parseExpression(expression).getValue((EvaluationContext)context));
    }

    @Generated
    public LogAspect(ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }
}

