/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.r;

import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.company.dao.r.RRiskBasicMapper;
import cn.smarthse.rho.modules.company.model.r.param.RiskQueryParam;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailListItemVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailSourceVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailStatisticDataVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskResolutionListItemVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskResolutionStatisticsVo;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.sys.entity.f.FProjectDetail;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasic;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class RRiskBasicServiceImpl
extends ServiceImpl<RRiskBasicMapper, RRiskBasic>
implements IRRiskBasicService {
    @Override
    public LayuiGridData<RiskResolutionListItemVo> getRiskListData(RiskQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((RRiskBasicMapper)this.baseMapper).getRiskListData(param), (LayuiGridParam)param);
    }

    @Override
    public RiskResolutionStatisticsVo getRiskResolutionStatisticsData(Long cid) {
        return ((RRiskBasicMapper)this.baseMapper).getRiskResolutionStatisticsData(cid);
    }

    @Override
    public List<RiskDetailListItemVo> getRiskDetailListData(Long riskBasicId, Integer riskType) {
        ArrayList<RiskDetailListItemVo> result = new ArrayList();
        result = ((RRiskBasicMapper)this.baseMapper).getRiskDetailListData(riskBasicId);
        return result;
    }

    @Override
    public LayuiGridData<RiskDetailSourceVo> listSourceByRiskId(RiskQueryParam param) {
        if (param.getBasicId() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RiskDetailSourceVo> rst = ((RRiskBasicMapper)this.baseMapper).listSourceByRiskId(param);
        for (RiskDetailSourceVo sourceVo : rst) {
            List<FProjectDetail> fProjectDetailList;
            if (sourceVo.getType() != RiskTypeEnum.THREE.getValue() || CollectionUtils.isEmpty(fProjectDetailList = ((RRiskBasicMapper)this.baseMapper).getFProjectDetailByProjectId(sourceVo.getBusinessId()))) continue;
            for (FProjectDetail fProjectDetail : fProjectDetailList) {
                if (fProjectDetail.getType() == 1) {
                    sourceVo.setProjectDetail1Id(fProjectDetail.getId());
                    continue;
                }
                if (fProjectDetail.getType() != 2) continue;
                sourceVo.setProjectDetail2Id(fProjectDetail.getId());
            }
        }
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public RiskDetailStatisticDataVo getRiskStatisticData(RiskQueryParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getRiskskStatisticData(param);
    }
}

