/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.r;

import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.converter.RRiskAcceptanceRecordConverter;
import cn.smarthse.rho.modules.company.dao.r.RRiskAcceptanceRecordMapper;
import cn.smarthse.rho.modules.company.model.r.param.RiskAcceptRecordSubmitParam;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailAcceptRecordVo;
import cn.smarthse.rho.modules.company.service.r.IRRiskAcceptanceRecordService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasic;
import cn.smarthse.rho.modules.sys.enums.risk.BasicRiskStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskAcceptanceStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskUnresolvedTypeEnum;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RRiskAcceptanceRecordServiceImpl
extends ServiceImpl<RRiskAcceptanceRecordMapper, RRiskAcceptanceRecord>
implements IRRiskAcceptanceRecordService {
    @Autowired
    private IRRiskBasicService riskBasicService;
    @Autowired
    private IRRiskBasicSourceService riskBasicSourceService;
    @Autowired
    private RRiskAcceptanceRecordConverter converter;

    @Override
    public List<RiskDetailAcceptRecordVo> getRiskDetailAcceptRecordListData(Long riskBasicId) {
        return ((RRiskAcceptanceRecordMapper)this.baseMapper).getRiskDetailAcceptRecordListData(riskBasicId);
    }

    @Override
    public void rectificationDraftSave(RiskAcceptRecordSubmitParam param) {
        RRiskAcceptanceRecord record = this.converter.SubmitParam2entity(param);
        if (param.getId() == null) {
            record.setCreateBy(param.getLoginUserId());
            record.setCreateDate(LocalDateTime.now());
        } else {
            record.setUpdateBy(param.getLoginUserId());
            record.setUpdateDate(LocalDateTime.now());
        }
        record.setStatus(RiskAcceptanceStatusEnum.DRAFT.getValue());
        this.saveOrUpdate(record);
    }

    @Override
    @Transactional
    public void acceptRecordSubmit(RiskAcceptRecordSubmitParam param) {
        RRiskAcceptanceRecord record = this.converter.SubmitParam2entity(param);
        record.setCid(param.getLoginCid());
        record.setActualFinishTime(LocalDate.now());
        if (param.getId() == null) {
            record.setCreateBy(param.getLoginUserId());
            record.setCreateDate(LocalDateTime.now());
        } else {
            record.setUpdateBy(param.getLoginUserId());
            record.setUpdateDate(LocalDateTime.now());
        }
        record.setStatus(RiskAcceptanceStatusEnum.PENDING_AUDIT.getValue());
        this.saveOrUpdate(record);
        if (param.getStatus().equals(RiskAcceptanceStatusEnum.PENDING_AUDIT.getValue())) {
            if (param.getRequireFinishTime() == null) {
                throw new ServiceException("\u8981\u6c42\u5b8c\u6210\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)param.getReformMeasure())) {
                throw new ServiceException("\u6574\u6539\u63aa\u65bd\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)param.getReformFinishedFiles())) {
                throw new ServiceException("\u6574\u6539\u4f50\u8bc1\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a");
            }
            RRiskBasic riskBasic = (RRiskBasic)this.riskBasicService.getById(param.getRiskId());
            riskBasic.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
            riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_ACCEPT.getValue());
            riskBasic.setUpdateBy(param.getLoginUserId());
            riskBasic.setUpdateDate(LocalDateTime.now());
            this.riskBasicService.updateById(riskBasic);
            this.riskBasicSourceService.updateBatchByAcceptRecordSubmit(param);
        }
    }
}

