/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.p;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.dao.b.BCompanyMapper;
import cn.smarthse.rho.modules.company.dao.d.DDeviceCheckDataMapper;
import cn.smarthse.rho.modules.company.dao.d.DLocationCheckDataMapper;
import cn.smarthse.rho.modules.company.dao.e.EdeviceMapper;
import cn.smarthse.rho.modules.company.dao.e.EdeviceRayMapper;
import cn.smarthse.rho.modules.company.dao.e.EmachineRoomMapper;
import cn.smarthse.rho.modules.company.dao.sys.SysBusinessOperateLogMapper;
import cn.smarthse.rho.modules.company.dao.x.XPDDMapper;
import cn.smarthse.rho.modules.company.dao.x.XPDDStaDayMapper;
import cn.smarthse.rho.modules.company.dao.x.XPDDStaMapper;
import cn.smarthse.rho.modules.company.dao.x.XPGatewayMapper;
import cn.smarthse.rho.modules.company.dao.x.XTagInfoMapper;
import cn.smarthse.rho.modules.company.model.p.param.ProtectEqCoordinateParam;
import cn.smarthse.rho.modules.company.model.p.param.ProtectEqDayListParam;
import cn.smarthse.rho.modules.company.model.p.param.ProtectEqExceptionDateListParam;
import cn.smarthse.rho.modules.company.model.p.param.ProtectEqExceptionDateLogParam;
import cn.smarthse.rho.modules.company.model.p.param.ProtectEqReturnParam;
import cn.smarthse.rho.modules.company.model.p.param.ProtectEqRoomDeviceInfoParam;
import cn.smarthse.rho.modules.company.model.p.param.ProtectEqSetWorkTimeParam;
import cn.smarthse.rho.modules.company.model.p.param.ProtectEqUploadParam;
import cn.smarthse.rho.modules.company.model.p.vo.ProtectEqCoordinateVo;
import cn.smarthse.rho.modules.company.model.p.vo.ProtectEqDayListVo;
import cn.smarthse.rho.modules.company.model.p.vo.ProtectEqExceptionDateListVo;
import cn.smarthse.rho.modules.company.model.p.vo.ProtectEqGetWorkTimeVo;
import cn.smarthse.rho.modules.company.model.p.vo.ProtectEqRoomDeviceInfoVo;
import cn.smarthse.rho.modules.company.service.p.IProtectEqService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.d.DDeviceCheckData;
import cn.smarthse.rho.modules.sys.entity.d.DLocationCheckData;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceRay;
import cn.smarthse.rho.modules.sys.entity.e.EMachineRoom;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.entity.x.XPositionDeviceData;
import cn.smarthse.rho.modules.sys.entity.x.XPositionDeviceDataStatistics;
import cn.smarthse.rho.modules.sys.entity.x.XPositionDeviceDataStatisticsDay;
import cn.smarthse.rho.modules.sys.entity.x.XPositionGatewayInfo;
import cn.smarthse.rho.modules.sys.entity.x.XTagInfo;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceDiagnosisTypeEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceProtectEqVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysBusinessOperateLogVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.cn.smarthse.modules.health.exception.BusinessException;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProtectEqServiceImpl
implements IProtectEqService {
    private static final Logger log = LoggerFactory.getLogger(ProtectEqServiceImpl.class);
    private final XPDDMapper xPDDMapper;
    private final XPDDStaMapper xPDDStaMapper;
    private final XPDDStaDayMapper xPDDStaDayMapper;
    private final XTagInfoMapper xTagInfoMapper;
    private final EdeviceMapper eDeviceMapper;
    private final EmachineRoomMapper emachineRoomMapper;
    private final DLocationCheckDataMapper dLocationCheckDataMapper;
    private final DDeviceCheckDataMapper dDeviceCheckDataMapper;
    private final XPGatewayMapper xPGatewayMapper;
    private final EdeviceRayMapper eDeviceRayMapper;
    private final BCompanyMapper bCompanyMapper;
    private final SysBusinessOperateLogMapper sysBusinessOperateLogMapper;
    @DubboReference
    private ISysFileProvider sysFileProvideService;

    @Override
    public ProtectEqGetWorkTimeVo getWorkTime() {
        ProtectEqGetWorkTimeVo vo = new ProtectEqGetWorkTimeVo();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(XPositionGatewayInfo::getCid, (Object)ShiroUtil.getLoginUserOriginalCid());
        XPositionGatewayInfo gatewayInfo = (XPositionGatewayInfo)this.xPGatewayMapper.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotEmpty((Object)gatewayInfo)) {
            vo.setIsSelfWorkTime(gatewayInfo.getIsSelfWorkTime());
            vo.setWorkBegin(gatewayInfo.getWorkBegin());
            vo.setWorkEnd(gatewayInfo.getWorkEnd());
        }
        return vo;
    }

    @Override
    public int setWorkTime(ProtectEqSetWorkTimeParam param) {
        if (param.getIsSelfWorkTime() == 1) {
            if (ObjectUtil.isEmpty((Object)param.getWorkBegin()) || ObjectUtil.isEmpty((Object)param.getWorkEnd())) {
                throw new ServiceException("\u81ea\u5b9a\u4e49\u6761\u4ef6\u4e0b\uff0c\u5f00\u59cb\u65f6\u95f4\u6216\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (param.getWorkEnd() <= param.getWorkBegin()) {
                throw new ServiceException("\u81ea\u5b9a\u4e49\u6761\u4ef6\u4e0b\uff0c\u7ed3\u675f\u65f6\u95f4\u8981\u5927\u4e8e\u5f00\u59cb\u65f6\u95f4");
            }
        }
        LambdaUpdateWrapper luw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)luw.eq(XPositionGatewayInfo::getCid, (Object)ShiroUtil.getLoginUserOriginalCid())).set(XPositionGatewayInfo::getIsSelfWorkTime, (Object)param.getIsSelfWorkTime());
        if (param.getIsSelfWorkTime() == 1) {
            ((LambdaUpdateWrapper)luw.set(XPositionGatewayInfo::getWorkBegin, (Object)param.getWorkBegin())).set(XPositionGatewayInfo::getWorkEnd, (Object)param.getWorkEnd());
        }
        int update = this.xPGatewayMapper.update((Wrapper)luw);
        return update;
    }

    @Override
    public int returnSupportFileById(ProtectEqReturnParam param) {
        LambdaUpdateWrapper luw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)luw.eq(XPositionDeviceDataStatisticsDay::getId, (Object)param.getId())).set(XPositionDeviceDataStatisticsDay::getFileId, null)).set(XPositionDeviceDataStatisticsDay::getIsUploadFile, (Object)0);
        int count = this.xPDDStaDayMapper.update((Wrapper)luw);
        int count2 = this.saveOperationLog(Long.parseLong(param.getId()), Constant.X_PDDS_STA_DAY_LOG_MODEL, SysBusinessOperateLogTypeEnum.BACK.getValue(), param.getReason());
        if (count2 != 1 || count != 1) {
            throw new ServiceException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return count;
    }

    @Override
    public int uploadSupportFile(ProtectEqUploadParam param) {
        LambdaUpdateWrapper luw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)luw.eq(XPositionDeviceDataStatisticsDay::getId, (Object)Long.valueOf(param.getId()))).set(XPositionDeviceDataStatisticsDay::getFileId, (Object)Long.valueOf(param.getFileId()))).set(XPositionDeviceDataStatisticsDay::getIsUploadFile, (Object)1);
        int count = this.xPDDStaDayMapper.update((Wrapper)luw);
        int count2 = this.saveOperationLog(Long.parseLong(param.getId()), Constant.X_PDDS_STA_DAY_LOG_MODEL, SysBusinessOperateLogTypeEnum.SUBMIT.getValue(), String.valueOf(param.getFileId()));
        if (count2 != 1 || count != 1) {
            throw new ServiceException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return count;
    }

    @Override
    public LayuiGridData<SysBusinessOperateLogVo> getExceptionDateLogListById(ProtectEqExceptionDateLogParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<SysBusinessOperateLogVo> voList = this.sysBusinessOperateLogMapper.selectListById(param);
        voList.forEach(i -> {
            if (i.getType() == SysBusinessOperateLogTypeEnum.SUBMIT.getValue() && StringUtils.isNotBlank((CharSequence)i.getReason())) {
                i.setFile(this.sysFileProvideService.getFileById(Long.valueOf(Long.parseLong(i.getReason()))));
            }
        });
        return new LayuiGridData((Page)voList, (LayuiGridParam)param);
    }

    @Override
    public ProtectEqDayListVo getDayList(ProtectEqDayListParam param) {
        ProtectEqDayListVo vo = new ProtectEqDayListVo();
        List<ProtectEqDayListVo.HourData> hourDataList = this.xPDDStaMapper.selectDayList(param);
        this.filterHourDataList(hourDataList, param);
        vo.setHourDataList(hourDataList);
        boolean hasAbnormal = vo.getHourDataList().stream().anyMatch(hourData -> Integer.parseInt(hourData.getAbnormalNum()) > 0);
        vo.setIsAbnormal(hasAbnormal ? (byte)1 : 0);
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lqw.eq(XPositionDeviceDataStatistics::getCid, (Object)param.getCid())).eq(XPositionDeviceDataStatistics::getGatewayId, (Object)param.getGateWayId())).orderByAsc(XPositionDeviceDataStatistics::getDetectionDate)).last("LIMIT 1");
        XPositionDeviceDataStatistics selectOne = (XPositionDeviceDataStatistics)this.xPDDStaMapper.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNotEmpty((Object)selectOne)) {
            vo.setStartDate(selectOne.getDetectionDate());
        }
        return vo;
    }

    private void filterHourDataList(List<ProtectEqDayListVo.HourData> hourDataList, ProtectEqDayListParam param) {
        XPositionGatewayInfo gatewayInfo = (XPositionGatewayInfo)this.xPGatewayMapper.selectById(param.getGateWayId());
        if (gatewayInfo.getIsSelfWorkTime() == 1) {
            Integer beginSlot = gatewayInfo.getWorkBegin() + 1;
            Integer endSlot = gatewayInfo.getWorkEnd();
            Iterator<ProtectEqDayListVo.HourData> iterator = hourDataList.iterator();
            while (iterator.hasNext()) {
                ProtectEqDayListVo.HourData hourData = iterator.next();
                if (hourData.getHourNumber() >= beginSlot && hourData.getHourNumber() <= endSlot) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public List<ProtectEqCoordinateVo> getTrackDiagramList(ProtectEqCoordinateParam param) {
        ArrayList<ProtectEqCoordinateVo> voList = new ArrayList<ProtectEqCoordinateVo>();
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)lqw.eq(XPositionDeviceData::getGatewayId, (Object)param.getGateWayId())).eq(XPositionDeviceData::getCid, (Object)param.getCid());
        if (param.getHourNumber() == null) {
            LocalDateTime beginTime = LocalDateTime.of(param.getDate(), LocalTime.MIN);
            LocalDateTime endTime = LocalDateTime.of(param.getDate(), LocalTime.MAX);
            XPositionGatewayInfo gatewayInfo = (XPositionGatewayInfo)this.xPGatewayMapper.selectById(param.getGateWayId());
            if (gatewayInfo.getIsSelfWorkTime() == 1) {
                Integer begin = gatewayInfo.getWorkBegin();
                Integer n = gatewayInfo.getWorkEnd();
                beginTime = beginTime.withHour(begin).withMinute(0).withSecond(0);
                endTime = endTime.withHour(n - 1).withMinute(59).withSecond(59);
            }
            param.setBeginTime(beginTime);
            param.setEndTime(endTime);
        } else {
            Integer hourNumber = param.getHourNumber();
            if (hourNumber != null && hourNumber >= 1 && hourNumber <= 24) {
                LocalDateTime beginTime = LocalDateTime.of(param.getDate(), LocalTime.of(hourNumber - 1, 0));
                LocalDateTime endTime = LocalDateTime.of(param.getDate(), LocalTime.of(hourNumber - 1, 59, 59));
                param.setBeginTime(beginTime);
                param.setEndTime(endTime);
            } else {
                throw new IllegalArgumentException("\u65e0\u6548\u7684\u5c0f\u65f6\u7f16\u53f7");
            }
        }
        lqw.between(XPositionDeviceData::getUpdatedAtime, (Object)param.getBeginTime(), (Object)param.getEndTime());
        List macList = this.xPDDMapper.selectList((Wrapper)lqw);
        if (CollectionUtil.isEmpty((Collection)macList)) {
            return voList;
        }
        Map macListMap = macList.stream().collect(Collectors.groupingBy(XPositionDeviceData::getMac, LinkedHashMap::new, Collectors.toList()));
        if (CollectionUtil.isEmpty((Map)macListMap)) {
            return voList;
        }
        Set entries = macListMap.entrySet();
        for (Map.Entry entry : entries) {
            String mac = (String)entry.getKey();
            List list = (List)entry.getValue();
            double threshold = 0.5;
            XPositionDeviceData basePoint = (XPositionDeviceData)list.get(0);
            ArrayList<ProtectEqCoordinateVo.Coordinate> coordinateList = new ArrayList<ProtectEqCoordinateVo.Coordinate>();
            coordinateList.add(new ProtectEqCoordinateVo.Coordinate(basePoint.getX(), basePoint.getY(), basePoint.getStatus()));
            if (list.size() > 1) {
                for (int i = 1; i < list.size(); ++i) {
                    double distance;
                    XPositionDeviceData currentPoint = (XPositionDeviceData)list.get(i);
                    if (basePoint.getStatus().equals(Byte.valueOf("0")) && currentPoint.getStatus().equals(Byte.valueOf("1"))) {
                        basePoint = currentPoint;
                        coordinateList.add(new ProtectEqCoordinateVo.Coordinate(currentPoint.getX(), currentPoint.getY(), currentPoint.getStatus()));
                        continue;
                    }
                    if (basePoint.getStatus().equals(Byte.valueOf("1")) && currentPoint.getStatus().equals(Byte.valueOf("1")) || !((distance = this.calculateDistance(basePoint, currentPoint)) > threshold)) continue;
                    basePoint = currentPoint;
                    coordinateList.add(new ProtectEqCoordinateVo.Coordinate(currentPoint.getX(), currentPoint.getY(), currentPoint.getStatus()));
                }
            }
            XTagInfo xTagInfo = this.xTagInfoMapper.selectByMac(mac);
            ProtectEqCoordinateVo protectEqCoordinateVo = new ProtectEqCoordinateVo();
            protectEqCoordinateVo.setId(xTagInfo.getId());
            protectEqCoordinateVo.setName(xTagInfo.getTagName());
            protectEqCoordinateVo.setCoordinateList(coordinateList);
            voList.add(protectEqCoordinateVo);
        }
        double maxX = 5.2;
        double maxY = 4.4;
        int xDivisions = 10;
        int yDivisions = 8;
        double cellWidth = maxX / (double)xDivisions;
        double cellHeight = maxY / (double)yDivisions;
        for (ProtectEqCoordinateVo protectEqCoordinateVo : voList) {
            List<ProtectEqCoordinateVo.Coordinate> coordinateList = protectEqCoordinateVo.getCoordinateList();
            HashMap<String, ProtectEqCoordinateVo.Coordinate> occupiedCells = new HashMap<String, ProtectEqCoordinateVo.Coordinate>();
            Iterator<ProtectEqCoordinateVo.Coordinate> coordinateIterator = coordinateList.iterator();
            while (coordinateIterator.hasNext()) {
                ProtectEqCoordinateVo.Coordinate coordinate = coordinateIterator.next();
                double originalX = Double.parseDouble(coordinate.getX());
                double originalY = Double.parseDouble(coordinate.getY());
                int xIndex = (int)(originalX / cellWidth);
                int yIndex = (int)(originalY / cellHeight);
                xIndex = Math.min(xIndex, xDivisions - 1);
                yIndex = Math.min(yIndex, yDivisions - 1);
                String cellKey = xIndex + "_" + yIndex;
                if (occupiedCells.containsKey(cellKey)) {
                    ProtectEqCoordinateVo.Coordinate existingCoordinate = (ProtectEqCoordinateVo.Coordinate)occupiedCells.get(cellKey);
                    if (coordinate.getStatus() == 1) {
                        existingCoordinate.setStatus((byte)1);
                    }
                    coordinateIterator.remove();
                    continue;
                }
                occupiedCells.put(cellKey, coordinate);
            }
        }
        return voList;
    }

    private int saveOperationLog(Long businessId, Integer model, Integer type, String reason) {
        SysBusinessOperateLog log = new SysBusinessOperateLog();
        log.setModule(model);
        log.setCid(ShiroUtil.getLoginUserOriginalCid());
        log.setBusinessId(Long.valueOf(businessId));
        log.setType(type);
        log.setOperator(ShiroUtil.getLoginUserSuperuserName());
        BCompany bCompany = (BCompany)this.bCompanyMapper.selectById(ShiroUtil.getLoginUserOriginalCid());
        if (ObjectUtil.isNotEmpty((Object)bCompany)) {
            log.setOperatorCompanyName(bCompany.getName());
        }
        log.setReason(reason);
        log.setCreateBy(ShiroUtil.getLoginUserId());
        log.setUpdateBy(ShiroUtil.getLoginUserId());
        log.setCreateDate(new Date());
        return this.sysBusinessOperateLogMapper.insert(log);
    }

    @Override
    public ProtectEqRoomDeviceInfoVo getRoomDeviceInfo(ProtectEqRoomDeviceInfoParam param) throws BusinessException {
        DLocationCheckData dLocationCheckData;
        EMachineRoom eMachineRoom;
        LambdaQueryWrapper lqw = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(XPositionGatewayInfo::getCid, (Object)param.getCid());
        List gatewayInfoList = this.xPGatewayMapper.selectList((Wrapper)lqw);
        XPositionGatewayInfo gatewayInfo = CollectionUtil.isNotEmpty((Collection)gatewayInfoList) ? (XPositionGatewayInfo)gatewayInfoList.get(0) : null;
        ProtectEqRoomDeviceInfoVo vo = new ProtectEqRoomDeviceInfoVo();
        if (ObjectUtil.isEmpty((Object)gatewayInfo)) {
            log.error("\u9632\u62a4\u7528\u54c1\u76d1\u6d4b-\u83b7\u53d6\u673a\u623f\uff0c\u8bbe\u5907\u4fe1\u606f\uff1a\u672a\u627e\u5230\u57fa\u7ad9\u4fe1\u606f");
            return vo;
        }
        vo.setGateWayId(gatewayInfo.getId());
        BCompany bCompany = (BCompany)this.bCompanyMapper.selectById(param.getCid());
        if (ObjectUtil.isNotEmpty((Object)bCompany)) {
            vo.setCompanyName(bCompany.getName());
        }
        if (ObjectUtil.isEmpty((Object)(eMachineRoom = (EMachineRoom)this.emachineRoomMapper.selectById(gatewayInfo.getRoomId())))) {
            log.error("\u9632\u62a4\u7528\u54c1\u76d1\u6d4b-\u83b7\u53d6\u673a\u623f\uff0c\u8bbe\u5907\u4fe1\u606f\uff1a\u672a\u627e\u5230\u673a\u623f\u4fe1\u606f");
            return vo;
        }
        LambdaQueryWrapper lqw4 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DLocationCheckData::getLocationId, (Object)gatewayInfo.getRoomId())).orderByDesc(DLocationCheckData::getCheckTime);
        List locationCheckDataList = this.dLocationCheckDataMapper.selectList((Wrapper)lqw4);
        DLocationCheckData dLocationCheckData2 = dLocationCheckData = CollectionUtil.isNotEmpty((Collection)locationCheckDataList) ? (DLocationCheckData)locationCheckDataList.get(0) : null;
        if (ObjectUtil.isNotEmpty((Object)dLocationCheckData)) {
            vo.setRoomCheckDate(dLocationCheckData.getCheckTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        }
        this.setMachineRoom(vo, eMachineRoom);
        EDevice eDevice = (EDevice)this.eDeviceMapper.selectById(gatewayInfo.getDeviceId());
        if (ObjectUtil.isEmpty((Object)eDevice)) {
            log.error("\u9632\u62a4\u7528\u54c1\u76d1\u6d4b-\u83b7\u53d6\u673a\u623f\uff0c\u8bbe\u5907\u4fe1\u606f\uff1a\u672a\u627e\u5230\u8bbe\u5907\u4fe1\u606f");
            return vo;
        }
        vo.setDeviceName(eDevice.getName());
        EDeviceProtectEqVo ediviceVo = new EDeviceProtectEqVo();
        ediviceVo.setId(eDevice.getId());
        ediviceVo.setStatus(eDevice.getStatus());
        ediviceVo.setLicenseStatus(eDevice.getLicenseStatus());
        ediviceVo.setLicenseStatusType(eDevice.getLicenseStatusType());
        ediviceVo.setName(eDevice.getName());
        ediviceVo.setType(eDevice.getType());
        ediviceVo.setFactory(eDevice.getFactory());
        ediviceVo.setFactoryNo(eDevice.getFactoryNo());
        ediviceVo.setWarningStatus(eDevice.getWarningStatus());
        LambdaQueryWrapper lqw5 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lqw5.eq(DDeviceCheckData::getDeviceId, (Object)eDevice.getId())).eq(DDeviceCheckData::getCid, (Object)param.getCid())).orderByDesc(DDeviceCheckData::getCheckTime)).last("limit 1");
        DDeviceCheckData dDeviceCheckData = (DDeviceCheckData)this.dDeviceCheckDataMapper.selectOne((Wrapper)lqw5);
        if (ObjectUtil.isNotEmpty((Object)dDeviceCheckData)) {
            ediviceVo.setTestingDate(dDeviceCheckData.getCheckTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            ediviceVo.setTestingResult(dDeviceCheckData.getCheckResult());
        }
        LambdaQueryWrapper lqw6 = new LambdaQueryWrapper();
        lqw6.eq(EDeviceRay::getDid, (Object)eDevice.getId());
        EDeviceRay eDeviceRay = (EDeviceRay)this.eDeviceRayMapper.selectOne((Wrapper)lqw6);
        if (ObjectUtil.isNotEmpty((Object)eDeviceRay)) {
            ediviceVo.setModel(eDeviceRay.getModel());
            vo.setDiagnosisType(eDeviceRay.getDiagnosisType());
            vo.setDiagnosisTypeStr(EdeviceDiagnosisTypeEnum.getName((Integer)Integer.parseInt(eDeviceRay.getDiagnosisType())));
        }
        vo.setDevice(ediviceVo);
        return vo;
    }

    private void setMachineRoom(ProtectEqRoomDeviceInfoVo vo, EMachineRoom eMachineRoom) {
        vo.setRoomId(eMachineRoom.getId());
        vo.setRoomName(eMachineRoom.getName());
        vo.setRoomLicenseStatus(eMachineRoom.getLicenseStatus());
        vo.setRoomWarningStatus(eMachineRoom.getWarningStatus());
    }

    @Override
    public ProtectEqExceptionDateListVo getExceptionDateList(ProtectEqExceptionDateListParam param) {
        param.setBeginDate(LocalDate.of((int)param.getYear(), param.getMonth(), 1));
        param.setEndDate(LocalDate.of((int)param.getYear(), param.getMonth(), param.getBeginDate().lengthOfMonth()));
        ProtectEqExceptionDateListVo vo = new ProtectEqExceptionDateListVo();
        List<ProtectEqExceptionDateListVo.DataList> dataList = this.xPDDStaDayMapper.selectExceptionDateList(param);
        Double abnormalRate = (double)((XPositionGatewayInfo)this.xPGatewayMapper.selectById(param.getGateWayId())).getAbnormalRate().intValue() / 100.0;
        List<ProtectEqExceptionDateListVo.DataList> filteredDataList = dataList.stream().filter(item -> {
            Double currentRate = this.getCurentRate((ProtectEqExceptionDateListVo.DataList)item);
            return !ObjectUtil.isNotEmpty((Object)param.getRange()) || !(param.getRange() == 0 && currentRate >= abnormalRate) && (param.getRange() != 1 || !(currentRate < abnormalRate));
        }).peek(item -> {
            Double currentRate = this.getCurentRate((ProtectEqExceptionDateListVo.DataList)item);
            Integer status = currentRate >= abnormalRate ? 1 : 0;
            item.setStatus(Byte.valueOf(status + ""));
            this.setFileObject((ProtectEqExceptionDateListVo.DataList)item);
        }).collect(Collectors.toList());
        vo.setDataList(filteredDataList);
        vo.setTotal(filteredDataList.size());
        return vo;
    }

    private void setFileObject(ProtectEqExceptionDateListVo.DataList item) {
        SysFileVo fileVo;
        Long fileId = item.getFileId();
        if (fileId != null && (fileVo = this.sysFileProvideService.getFileById(fileId)) != null) {
            item.setFile(fileVo);
        }
    }

    private Double getCurentRate(ProtectEqExceptionDateListVo.DataList item) {
        int exceptionNum = item.getExceptionNum();
        int checkNum = item.getCheckNum();
        if (checkNum == 0) {
            return 0.0;
        }
        return (double)exceptionNum / (double)checkNum;
    }

    private double calculateDistance(XPositionDeviceData p1, XPositionDeviceData p2) {
        double xDiff = Double.parseDouble(p1.getX()) - Double.parseDouble(p2.getX());
        double yDiff = Double.parseDouble(p1.getY()) - Double.parseDouble(p2.getY());
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    public ProtectEqServiceImpl(XPDDMapper xPDDMapper, XPDDStaMapper xPDDStaMapper, XPDDStaDayMapper xPDDStaDayMapper, XTagInfoMapper xTagInfoMapper, EdeviceMapper eDeviceMapper, EmachineRoomMapper emachineRoomMapper, DLocationCheckDataMapper dLocationCheckDataMapper, DDeviceCheckDataMapper dDeviceCheckDataMapper, XPGatewayMapper xPGatewayMapper, EdeviceRayMapper eDeviceRayMapper, BCompanyMapper bCompanyMapper, SysBusinessOperateLogMapper sysBusinessOperateLogMapper) {
        this.xPDDMapper = xPDDMapper;
        this.xPDDStaMapper = xPDDStaMapper;
        this.xPDDStaDayMapper = xPDDStaDayMapper;
        this.xTagInfoMapper = xTagInfoMapper;
        this.eDeviceMapper = eDeviceMapper;
        this.emachineRoomMapper = emachineRoomMapper;
        this.dLocationCheckDataMapper = dLocationCheckDataMapper;
        this.dDeviceCheckDataMapper = dDeviceCheckDataMapper;
        this.xPGatewayMapper = xPGatewayMapper;
        this.eDeviceRayMapper = eDeviceRayMapper;
        this.bCompanyMapper = bCompanyMapper;
        this.sysBusinessOperateLogMapper = sysBusinessOperateLogMapper;
    }
}

