/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.g;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.dao.g.GSafetyDeviceSelfCheckMapper;
import cn.smarthse.rho.modules.company.service.g.IGSafetyDevicesWarningSignsService;
import cn.smarthse.rho.modules.company.service.g.IGSelfCheckCommitmentService;
import cn.smarthse.rho.modules.company.service.r.IRKeyFactorAuditService;
import cn.smarthse.rho.modules.sys.entity.g.GSafetyDeviceSelfCheck;
import cn.smarthse.rho.modules.sys.entity.g.GSelfCheckCommitment;
import cn.smarthse.rho.modules.sys.entity.r.RKeyFactorAudit;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.company.SafrtyDeviceStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactorTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.g.param.GSafetyDeviceSelfCheckEditParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSafetyDeviceSelfCheckIdParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSafetyDeviceSelfCheckListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSafetyDeviceSelfCheckStatusLogListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSelfCheckCommitmentEditParam;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckListStatisticsVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckOneVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSafetyDeviceSelfCheckStatusLogListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSelfCheckCommitmentVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysCommonProvider;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GSafetyDevicesWarningSignsServiceImpl
extends ServiceImpl<GSafetyDeviceSelfCheckMapper, GSafetyDeviceSelfCheck>
implements IGSafetyDevicesWarningSignsService {
    @DubboReference
    private ISysCommonProvider sysCommonProvider;
    @DubboReference
    private ICompanyProvider companyProvider;
    @Autowired
    private IRKeyFactorAuditService keyFactorAuditService;
    @DubboReference
    private ISysBusinessOperateLogProvider logProvider;
    @Autowired
    private IGSelfCheckCommitmentService gSelfCheckCommitmentService;

    @Override
    @Transactional
    public void addOrEditOneSelfCheck(GSafetyDeviceSelfCheckEditParam param) {
        GSafetyDeviceSelfCheck selfCheck = (GSafetyDeviceSelfCheck)((GSafetyDeviceSelfCheckMapper)this.baseMapper).selectById(param.getId());
        if (param.getCid() == null) {
            throw new ServiceException("cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            if (selfCheck == null) {
                selfCheck = new GSafetyDeviceSelfCheck().setCid(param.getCid()).setCheckTime(param.getCheckTime()).setCertificateFile(param.getCertificateFile()).setStatus(SafrtyDeviceStatusEnum.DRAFT.getValue());
                ((GSafetyDeviceSelfCheckMapper)this.baseMapper).insert(selfCheck);
                BCompanyVo company = this.companyProvider.getCompany(param.getCid());
                if (ObjectUtil.isEmpty((Object)company)) {
                    throw new ServiceException("\u516c\u53f8\u4e0d\u5b58\u5728");
                }
                RKeyFactorAudit keyFactorAudit = new RKeyFactorAudit();
                keyFactorAudit.setType(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue());
                keyFactorAudit.setStatus(KeyFactoAuditStatusEnum.AUDIT.getCode());
                keyFactorAudit.setBusinessId(selfCheck.getId());
                keyFactorAudit.setCid(company.getId());
                keyFactorAudit.setCompanyName(company.getName());
                keyFactorAudit.setCompanyAddress(company.getAddress());
                this.keyFactorAuditService.saveOrUpdate(keyFactorAudit);
                SysBusinessOperateLog log = new SysBusinessOperateLog();
                log.setBusinessId(keyFactorAudit.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_4.getValue()).setType(SysBusinessOperateLogTypeEnum.SUBMIT.getValue()).setCid(company.getId()).setOperator(ShiroUtil.getLoginUsername()).setOperatorCompanyName(company.getName());
                this.logProvider.addOrUpdateLog(log);
            } else {
                if (!SafrtyDeviceStatusEnum.DRAFT.getValue().equals(selfCheck.getStatus()) && !SafrtyDeviceStatusEnum.REJECTED.getValue().equals(selfCheck.getStatus())) {
                    throw new ServiceException("\u8be5\u72b6\u6001\u65e0\u6cd5\u4fee\u6539\u81ea\u68c0\u4fe1\u606f");
                }
                if (param.getId() == null) {
                    throw new ServiceException("id\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539\u81ea\u68c0\u4fe1\u606f");
                }
                selfCheck.setId(param.getId()).setCheckTime(param.getCheckTime()).setCertificateFile(param.getCertificateFile());
                ((GSafetyDeviceSelfCheckMapper)this.baseMapper).updateById(selfCheck);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public GSafetyDeviceSelfCheckOneVo getOneById(Long id) {
        if (id == null) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a");
        }
        return ((GSafetyDeviceSelfCheckMapper)this.baseMapper).selectVoById(id);
    }

    @Override
    public LayuiGridData<GSafetyDeviceSelfCheckStatusLogListVo> getStatusLogList(GSafetyDeviceSelfCheckStatusLogListParam param) {
        param.setPage(param.getPage() <= 0 ? 1 : param.getPage());
        param.setLimit(param.getLimit() <= 0 ? Integer.MAX_VALUE : param.getLimit());
        List changeLogList = this.sysCommonProvider.getChangeLogList(param.getId(), "g_safety_device_self_check", "status");
        List voList = changeLogList.stream().map(item -> {
            GSafetyDeviceSelfCheckStatusLogListVo vo = new GSafetyDeviceSelfCheckStatusLogListVo();
            BeanUtil.copyProperties((Object)item, (Object)vo, (String[])new String[0]);
            return vo;
        }).collect(Collectors.toList());
        return new LayuiGridData(voList, Integer.valueOf(param.getPage()), Integer.valueOf(param.getLimit()));
    }

    @Override
    public void delSelfCheck(Long id) {
        GSafetyDeviceSelfCheck selfCheck = (GSafetyDeviceSelfCheck)((GSafetyDeviceSelfCheckMapper)this.baseMapper).selectById(id);
        if (selfCheck == null) {
            throw new ServiceException("\u8be5\u81ea\u68c0\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!SafrtyDeviceStatusEnum.DRAFT.getValue().equals(selfCheck.getStatus())) {
            throw new ServiceException("\u975e\u8349\u7a3f\u72b6\u6001\u65e0\u6cd5\u5220\u9664");
        }
        try {
            ((GSafetyDeviceSelfCheckMapper)this.baseMapper).deleteById(id);
        }
        catch (Exception e) {
            throw new ServiceException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public void termination(GSafetyDeviceSelfCheckIdParam param) {
        GSafetyDeviceSelfCheck selfCheck = (GSafetyDeviceSelfCheck)((GSafetyDeviceSelfCheckMapper)this.baseMapper).selectById(param.getId());
        if (selfCheck == null) {
            throw new ServiceException("\u8be5\u81ea\u68c0\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!SafrtyDeviceStatusEnum.REJECTED.getValue().equals(selfCheck.getStatus())) {
            throw new ServiceException("\u975e\u88ab\u9000\u56de\u72b6\u6001\u65e0\u6cd5\u4e2d\u6b62");
        }
        selfCheck.setStatus(SafrtyDeviceStatusEnum.DRAFT.getValue());
        try {
            ((GSafetyDeviceSelfCheckMapper)this.baseMapper).updateById(selfCheck);
        }
        catch (Exception e) {
            throw new ServiceException("\u4e2d\u6b62\u5931\u8d25");
        }
    }

    @Override
    public void addOrEditCommitment(GSelfCheckCommitmentEditParam param) {
        if (!StringUtils.checkPhoneNumber((String)param.getPhone())) {
            throw new ServiceException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
        }
        GSelfCheckCommitmentVo commitmentVo = this.gSelfCheckCommitmentService.getOneByCid(param.getCid(), param.getKeyFactorType());
        try {
            if (commitmentVo == null) {
                GSelfCheckCommitment commitment = new GSelfCheckCommitment().setCid(param.getCid()).setPhone(param.getPhone()).setName(param.getName()).setCommitmentFile(param.getCommitmentFile()).setType(param.getKeyFactorType());
                this.gSelfCheckCommitmentService.save(commitment);
            } else {
                GSelfCheckCommitment commitment = new GSelfCheckCommitment().setId(commitmentVo.getId()).setPhone(param.getPhone()).setName(param.getName()).setCommitmentFile(param.getCommitmentFile());
                this.gSelfCheckCommitmentService.updateById(commitment);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public GSelfCheckCommitmentVo getCommitment() {
        return this.gSelfCheckCommitmentService.getOneByCid(ShiroUtil.getLoginUserCid(), KeyFactorTypeEnum.SD_SELF_CHECK.getCode());
    }

    @Override
    public GSafetyDeviceSelfCheckListStatisticsVo getStatistics(GSafetyDeviceSelfCheckListParam param) {
        GSafetyDeviceSelfCheckListStatisticsVo vo = ((GSafetyDeviceSelfCheckMapper)this.baseMapper).getStatistics(param);
        return vo;
    }

    @Override
    public LayuiGridData<GSafetyDeviceSelfCheckListVo> getSelfCheckList(GSafetyDeviceSelfCheckListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((GSafetyDeviceSelfCheckMapper)this.baseMapper).getSelfCheckList(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }
}

