/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.g;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.dao.g.GEquipmentSelfCheckMapper;
import cn.smarthse.rho.modules.company.service.g.IGProtectiveEquipmentService;
import cn.smarthse.rho.modules.company.service.g.IGSelfCheckCommitmentService;
import cn.smarthse.rho.modules.company.service.r.IRKeyFactorAuditService;
import cn.smarthse.rho.modules.sys.entity.g.GEquipmentSelfCheck;
import cn.smarthse.rho.modules.sys.entity.g.GSelfCheckCommitment;
import cn.smarthse.rho.modules.sys.entity.r.RKeyFactorAudit;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.company.ProtectiveEquipmentStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactorTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckEditParam;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckIdParam;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckStatusLogListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GSelfCheckCommitmentEditParam;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckOneVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckStatusLogListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GSelfCheckCommitmentVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysCommonProvider;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GProtectiveEquipmentServiceImpl
extends ServiceImpl<GEquipmentSelfCheckMapper, GEquipmentSelfCheck>
implements IGProtectiveEquipmentService {
    @DubboReference
    private ISysCommonProvider sysCommonProvider;
    @DubboReference
    private ICompanyProvider companyProvider;
    @DubboReference
    private ISysBusinessOperateLogProvider logProvider;
    private final IRKeyFactorAuditService keyFactorAuditService;
    private final IGSelfCheckCommitmentService selfCheckCommitmentService;

    @Override
    public LayuiGridData<GEquipmentSelfCheckListVo> getSelfCheckList(GEquipmentSelfCheckListParam param) {
        if (param.getBeginDate() != null) {
            param.setBeginDate((Date)DateUtil.beginOfDay((Date)param.getBeginDate()));
        }
        if (param.getEndDate() != null) {
            param.setEndDate((Date)DateUtil.endOfDay((Date)param.getEndDate()));
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((GEquipmentSelfCheckMapper)this.baseMapper).getSelfCheckList(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void addOrEditOneSelfCheck(GEquipmentSelfCheckEditParam param) {
        GEquipmentSelfCheck selfCheck = (GEquipmentSelfCheck)((GEquipmentSelfCheckMapper)this.baseMapper).selectById(param.getId());
        try {
            if (selfCheck == null) {
                selfCheck = new GEquipmentSelfCheck().setCid(param.getCid()).setCheckTime(param.getCheckTime()).setCertificateFile(param.getCertificateFile()).setStatus(ProtectiveEquipmentStatusEnum.DRAFT.getValue());
                ((GEquipmentSelfCheckMapper)this.baseMapper).insert(selfCheck);
                BCompanyVo company = this.companyProvider.getCompany(param.getCid());
                if (ObjectUtil.isEmpty((Object)company)) {
                    throw new ServiceException("\u516c\u53f8\u4e0d\u5b58\u5728");
                }
                RKeyFactorAudit keyFactorAudit = new RKeyFactorAudit();
                keyFactorAudit.setType(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue());
                keyFactorAudit.setStatus(KeyFactoAuditStatusEnum.AUDIT.getCode());
                keyFactorAudit.setBusinessId(selfCheck.getId());
                keyFactorAudit.setCid(company.getId());
                keyFactorAudit.setCompanyName(company.getName());
                keyFactorAudit.setCompanyAddress(company.getAddress());
                this.keyFactorAuditService.saveOrUpdate(keyFactorAudit);
                SysBusinessOperateLog log = new SysBusinessOperateLog();
                log.setBusinessId(keyFactorAudit.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_3.getValue()).setType(SysBusinessOperateLogTypeEnum.SUBMIT.getValue()).setCid(company.getId()).setOperator(ShiroUtil.getLoginUsername()).setOperatorCompanyName(company.getName());
                this.logProvider.addOrUpdateLog(log);
            } else {
                if (!ProtectiveEquipmentStatusEnum.DRAFT.getValue().equals(selfCheck.getStatus()) && !ProtectiveEquipmentStatusEnum.REJECTED.getValue().equals(selfCheck.getStatus())) {
                    throw new ServiceException("\u8be5\u72b6\u6001\u65e0\u6cd5\u4fee\u6539\u81ea\u68c0\u4fe1\u606f");
                }
                if (param.getId() == null) {
                    throw new ServiceException("id\u4e3a\u7a7a\u65e0\u6cd5\u4fee\u6539\u81ea\u68c0\u4fe1\u606f");
                }
                selfCheck.setId(param.getId()).setCheckTime(param.getCheckTime()).setCertificateFile(param.getCertificateFile());
                ((GEquipmentSelfCheckMapper)this.baseMapper).updateById(selfCheck);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @Override
    public LayuiGridData<GEquipmentSelfCheckStatusLogListVo> getStatusLogList(GEquipmentSelfCheckStatusLogListParam param) {
        param.setPage(param.getPage() <= 0 ? 1 : param.getPage());
        param.setLimit(param.getLimit() <= 0 ? Integer.MAX_VALUE : param.getLimit());
        List changeLogList = this.sysCommonProvider.getChangeLogList(param.getId(), "g_equipment_self_check", "status");
        List voList = changeLogList.stream().map(item -> {
            GEquipmentSelfCheckStatusLogListVo vo = new GEquipmentSelfCheckStatusLogListVo();
            BeanUtil.copyProperties((Object)item, (Object)vo, (String[])new String[0]);
            return vo;
        }).collect(Collectors.toList());
        return new LayuiGridData(voList, Integer.valueOf(param.getPage()), Integer.valueOf(param.getLimit()));
    }

    @Override
    public void termination(GEquipmentSelfCheckIdParam param) {
        GEquipmentSelfCheck selfCheck = (GEquipmentSelfCheck)((GEquipmentSelfCheckMapper)this.baseMapper).selectById(param.getId());
        if (selfCheck == null) {
            throw new ServiceException("\u8be5\u81ea\u68c0\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!ProtectiveEquipmentStatusEnum.REJECTED.getValue().equals(selfCheck.getStatus())) {
            throw new ServiceException("\u975e\u88ab\u9000\u56de\u72b6\u6001\u65e0\u6cd5\u4e2d\u6b62");
        }
        selfCheck.setStatus(ProtectiveEquipmentStatusEnum.DRAFT.getValue());
        try {
            ((GEquipmentSelfCheckMapper)this.baseMapper).updateById(selfCheck);
        }
        catch (Exception e) {
            throw new ServiceException("\u4e2d\u6b62\u5931\u8d25");
        }
    }

    @Override
    public void delSelfCheck(Long id) {
        GEquipmentSelfCheck selfCheck = (GEquipmentSelfCheck)((GEquipmentSelfCheckMapper)this.baseMapper).selectById(id);
        if (selfCheck == null) {
            throw new ServiceException("\u8be5\u81ea\u68c0\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!ProtectiveEquipmentStatusEnum.DRAFT.getValue().equals(selfCheck.getStatus())) {
            throw new ServiceException("\u975e\u8349\u7a3f\u72b6\u6001\u65e0\u6cd5\u5220\u9664");
        }
        try {
            ((GEquipmentSelfCheckMapper)this.baseMapper).deleteById(id);
        }
        catch (Exception e) {
            throw new ServiceException("\u5220\u9664\u5931\u8d25");
        }
    }

    @Override
    public GEquipmentSelfCheckOneVo getOneById(Long id) {
        if (id == null) {
            throw new ServiceException("\u53c2\u6570\u4e3a\u7a7a");
        }
        return ((GEquipmentSelfCheckMapper)this.baseMapper).selectVoById(id);
    }

    @Override
    public GSelfCheckCommitmentVo getCommitment() {
        Long cid = ShiroUtil.getLoginUserCid();
        return this.selfCheckCommitmentService.getOneByCid(cid, KeyFactorTypeEnum.PPE_SELF_CHECK.getCode());
    }

    @Override
    public void addOrEditCommitment(GSelfCheckCommitmentEditParam param) {
        if (!StringUtils.checkPhoneNumber((String)param.getPhone())) {
            throw new ServiceException("\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef");
        }
        GSelfCheckCommitmentVo commitmentVo = this.selfCheckCommitmentService.getOneByCid(param.getCid(), KeyFactorTypeEnum.PPE_SELF_CHECK.getCode());
        try {
            if (commitmentVo == null) {
                GSelfCheckCommitment commitment = new GSelfCheckCommitment().setCid(param.getCid()).setPhone(param.getPhone()).setName(param.getName()).setCommitmentFile(param.getCommitmentFile()).setType(param.getKeyFactorType());
                this.selfCheckCommitmentService.save(commitment);
            } else {
                GSelfCheckCommitment commitment = new GSelfCheckCommitment().setId(commitmentVo.getId()).setPhone(param.getPhone()).setName(param.getName()).setCommitmentFile(param.getCommitmentFile());
                this.selfCheckCommitmentService.updateById(commitment);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public GProtectiveEquipmentServiceImpl(IRKeyFactorAuditService keyFactorAuditService, IGSelfCheckCommitmentService selfCheckCommitmentService) {
        this.keyFactorAuditService = keyFactorAuditService;
        this.selfCheckCommitmentService = selfCheckCommitmentService;
    }
}

