/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.f;

import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.dao.f.FProjectMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceService;
import cn.smarthse.rho.modules.company.service.f.IFProjectDetailService;
import cn.smarthse.rho.modules.company.service.f.IFProjectService;
import cn.smarthse.rho.modules.company.service.r.IRKeyFactorAuditService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.f.FProject;
import cn.smarthse.rho.modules.sys.entity.f.FProjectDetail;
import cn.smarthse.rho.modules.sys.entity.r.RKeyFactorAudit;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.f.FProjectDetailStatusEnum;
import cn.smarthse.rho.modules.sys.enums.f.FProjectStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import cn.smarthse.rho.modules.sys.model.f.param.FThreeTimesProjectAddParam;
import cn.smarthse.rho.modules.sys.model.f.param.FThreeTimesProjectEditParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectDetailQueryParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectQueryParam;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectDetailVo;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Arrays;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FProjectServiceImpl
extends ServiceImpl<FProjectMapper, FProject>
implements IFProjectService {
    @Autowired
    private IFProjectDetailService projectDetailService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IRKeyFactorAuditService keyFactorAuditService;
    @Autowired
    private IBCompanyService companyService;
    @DubboReference
    private ISysBusinessOperateLogProvider logProvider;

    @Override
    public LayuiGridData<FThreeTimesProjectVo> getThreeProjectList(ThreeProjectQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((FProjectMapper)this.baseMapper).getThreeProjectList(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    @Override
    public FThreeTimesProjectDetailVo getDetailByProjectId(ThreeProjectDetailQueryParam param) {
        EDevice device;
        FThreeTimesProjectDetailVo result = new FThreeTimesProjectDetailVo();
        RKeyFactorAudit keyFactorAudit = this.keyFactorAuditService.getOneByBusinessId(param.getProjectId());
        if (keyFactorAudit != null) {
            result.setKeyFactorAuditId(keyFactorAudit.getId());
        }
        result.setBaseInfo((FProject)this.getById(param.getProjectId()));
        if (result.getBaseInfo() != null && (device = (EDevice)((IEdeviceService)this.applicationContext.getBean(IEdeviceService.class)).getById(result.getBaseInfo().getDeviceId())) != null) {
            result.getBaseInfo().setDeviceType(device.getType());
            result.getBaseInfo().setDeviceNo(device.getFactoryNo());
        }
        result.setProjectDetail1((FProjectDetail)this.projectDetailService.getById(param.getDetail1Id()));
        result.setProjectDetail2((FProjectDetail)this.projectDetailService.getById(param.getDetail2Id()));
        return result;
    }

    @Override
    @Transactional
    public void editThreeTimesProject(FThreeTimesProjectEditParam param) {
        FProject fProject = param.getBaseInfo();
        fProject.setCid(ShiroUtil.getLoginUserCid());
        fProject.setStatus(FProjectStatusEnum.DRAFT.getValue());
        this.saveOrUpdate(fProject);
        this.setThreeTimesProjectPreAndCvaStatus(param.getProjectDetail1());
        this.setThreeTimesProjectPreAndCvaStatus(param.getProjectDetail2());
        this.projectDetailService.saveOrUpdate(param.getProjectDetail1());
        this.projectDetailService.saveOrUpdate(param.getProjectDetail2());
    }

    @Override
    @Transactional
    public void submitThreeTimesProject(FThreeTimesProjectEditParam param) {
        FProject fProject = param.getBaseInfo();
        fProject.setCid(ShiroUtil.getLoginUserCid());
        this.setThreeTimesProjectPreAndCvaStatus(param.getProjectDetail1());
        this.setThreeTimesProjectPreAndCvaStatus(param.getProjectDetail2());
        if (param.getProjectDetail2().getType() == 2 && param.getProjectDetail2().getFillType() == 2) {
            fProject.setStatus(FProjectStatusEnum.AUDIT.getValue());
            RKeyFactorAudit keyFactorAudit = new RKeyFactorAudit();
            keyFactorAudit.setType(RiskTypeEnum.THREE.getValue());
            keyFactorAudit.setStatus(KeyFactoAuditStatusEnum.AUDIT.getCode());
            keyFactorAudit.setBusinessId(fProject.getId());
            keyFactorAudit.setCid(fProject.getCid());
            keyFactorAudit.setCompanyName(fProject.getCname());
            keyFactorAudit.setCompanyAddress(fProject.getAddress());
            if (param.getKeyFactorAuditId() != null) {
                keyFactorAudit.setId(param.getKeyFactorAuditId());
            }
            this.keyFactorAuditService.saveOrUpdate(keyFactorAudit);
            SysBusinessOperateLog log = new SysBusinessOperateLog();
            log.setBusinessId(param.getKeyFactorAuditId() != null ? param.getKeyFactorAuditId() : keyFactorAudit.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_2.getValue()).setType(SysBusinessOperateLogTypeEnum.SUBMIT.getValue()).setCid(fProject.getCid()).setOperator(ShiroUtil.getLoginUsername()).setOperatorCompanyName(fProject.getCbranch());
            this.logProvider.addOrUpdateLog(log);
        } else if (param.getProjectDetail1().getPreStatus() == 2 && param.getProjectDetail2().getPreStatus() == 2 && param.getProjectDetail1().getCvaStatus() == 2 && param.getProjectDetail2().getCvaStatus() == 2) {
            fProject.setStatus(FProjectStatusEnum.NOT_NEED_AUDIT.getValue());
        }
        this.saveOrUpdate(fProject);
        this.projectDetailService.saveOrUpdate(param.getProjectDetail1());
        this.projectDetailService.saveOrUpdate(param.getProjectDetail2());
    }

    void setThreeTimesProjectPreAndCvaStatus(FProjectDetail detail) {
        if (StringUtils.isNotEmpty((String)detail.getPreReportNo()) && StringUtils.isNotEmpty((String)detail.getPreTechName()) && detail.getPreReportDate() != null) {
            detail.setPreStatus(FProjectDetailStatusEnum.FINISHED.getValue());
        } else {
            detail.setPreStatus(FProjectDetailStatusEnum.UN_FINISH.getValue());
        }
        if (StringUtils.isNotEmpty((String)detail.getCvaReportNo()) && StringUtils.isNotEmpty((String)detail.getCvaTechName()) && StringUtils.isNotEmpty((String)detail.getCheckReportNo()) && detail.getCvaReportDate() != null) {
            detail.setCvaStatus(FProjectDetailStatusEnum.FINISHED.getValue());
        } else {
            detail.setCvaStatus(FProjectDetailStatusEnum.UN_FINISH.getValue());
        }
    }

    @Override
    @Transactional
    public FProject generateThreeTimesProject(FThreeTimesProjectAddParam param) {
        FProject fProject = new FProject();
        fProject.setCid(param.getCid());
        fProject.setName(param.getDeviceName());
        fProject.setDeviceId(param.getDeviceId());
        fProject.setDeviceNo(param.getDeviceNo());
        fProject.setRoomId(param.getRoomIds());
        fProject.setRoomName(param.getRoomNames());
        fProject.setBeginDate(new Date());
        fProject.setStatus(FProjectStatusEnum.DRAFT.getValue());
        BCompany company = (BCompany)this.companyService.getById(param.getCid());
        if (company != null) {
            fProject.setCname(company.getName());
            fProject.setAddress(company.getAddress());
            fProject.setCbranch(company.getHospitalName());
        }
        this.save(fProject);
        FProjectDetail projectDetail1 = new FProjectDetail();
        projectDetail1.setProjectId(fProject.getId());
        projectDetail1.setType(Integer.valueOf(1));
        FProjectDetail projectDetail2 = new FProjectDetail();
        projectDetail2.setProjectId(fProject.getId());
        projectDetail2.setType(Integer.valueOf(2));
        this.projectDetailService.saveBatch(Arrays.asList(projectDetail1, projectDetail2));
        return fProject;
    }
}

