/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.e.manage;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.model.ResponseStateEnum;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.EMachineRoomConverter;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.e.IEmachineRoomService;
import cn.smarthse.rho.modules.company.service.e.manage.IEMachineRoomManageService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.enums.lock.DistributedLockEnum;
import cn.smarthse.rho.modules.sys.model.e.param.EMachineRoomDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.MachineRoomImportDto;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EMachineRoomManageServiceImpl
implements IEMachineRoomManageService {
    private static final Logger log = LoggerFactory.getLogger(EMachineRoomManageServiceImpl.class);
    private final RedissonClient redissonClient;
    @Autowired
    private IEmachineRoomService machineRoomService;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private EMachineRoomConverter machineRoomConverter;

    @Override
    @Transactional
    public void importMachineRoom(List<MachineRoomImportDto> importDataList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_MACHINE_ROOM_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.importMachineRoomLock(importDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb.toString());
            throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
        }
    }

    @Transactional
    public void importMachineRoomLock(List<MachineRoomImportDto> importDataList) {
        this.checkMachineRoomImportInfoList(importDataList);
        List<EMachineRoomDto> machineRoomDtoList = this.transformImportInfoList(importDataList);
        for (EMachineRoomDto machineRoomDto : machineRoomDtoList) {
            this.machineRoomService.addMachineRoomDetail(machineRoomDto);
        }
    }

    public void checkMachineRoomImportInfoList(List<MachineRoomImportDto> importList) {
        ArrayList<MachineRoomImportDto> errorInfoList = new ArrayList<MachineRoomImportDto>();
        int rowIndex = 4;
        for (MachineRoomImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u673a\u623f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getCompanyName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6240\u5728\u9644\u5c5e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", rowIndex));
            } else {
                BCompany company = this.judgeCompanyExistByName(importDto.getCompanyName());
                if (company == null) {
                    sb.append(String.format("\u7b2c%s\u884c\uff0c\u6240\u5728\u9644\u5c5e\u5bf9\u8c61\u4e0d\u5b58\u5728", rowIndex));
                } else {
                    importDto.setCid(company.getId());
                }
            }
            if (StrUtil.isBlank((CharSequence)importDto.getIsOnboardStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u662f\u5426\u4e3a\u8f66\u8f7d\u673a\u623f\u4e0d\u80fd\u4e3a\u7a7a", rowIndex));
            }
            if (sb.length() > 0) {
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\u00b7\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    public List<EMachineRoomDto> transformImportInfoList(List<MachineRoomImportDto> importList) {
        ArrayList<EMachineRoomDto> resultList = new ArrayList<EMachineRoomDto>();
        for (MachineRoomImportDto importDto : importList) {
            EMachineRoomDto machineRoomDto = this.machineRoomConverter.importDto2AddDto(importDto);
            machineRoomDto.setId(Long.valueOf(IdWorker.getId()));
            resultList.add(machineRoomDto);
        }
        return resultList;
    }

    public BCompany judgeCompanyExistByName(String companyName) {
        return this.companyService.getByNameAndBranchCid(companyName, ShiroUtil.getLoginUserCid());
    }

    public EMachineRoomManageServiceImpl(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

