/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.e.manage;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.ResponseStateEnum;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.EDeviceConverter;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRayService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceSourceService;
import cn.smarthse.rho.modules.company.service.e.IEsourceNonSealedService;
import cn.smarthse.rho.modules.company.service.e.IEsourceSealedService;
import cn.smarthse.rho.modules.company.service.e.manage.IEDeviceManageService;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceRay;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceSource;
import cn.smarthse.rho.modules.sys.entity.e.ESourceNonSealed;
import cn.smarthse.rho.modules.sys.entity.e.ESourceSealed;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceLicenseStatusEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceLicenseStatusTypeEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.enums.lock.DistributedLockEnum;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.DeviceRayImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.DeviceSourceImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.SourceNonSealedImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.SourceSealedImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.TransformedDeviceImportDto;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysParamProvider;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EDeviceManageServiceImpl
implements IEDeviceManageService {
    private static final Logger log = LoggerFactory.getLogger(EDeviceManageServiceImpl.class);
    private final RedissonClient redissonClient;
    @Autowired
    private EDeviceConverter deviceConverter;
    @Autowired
    private IEdeviceService deviceService;
    @Autowired
    private IEdeviceRayService rayService;
    @Autowired
    private IEdeviceSourceService deviceSourceService;
    @Autowired
    private IEsourceNonSealedService sourceNonSealedService;
    @Autowired
    private IEsourceSealedService sourceSealedService;
    @DubboReference
    private ISysParamProvider sysParamProvider;
    private static final String DATE_PATTERN = "^\\d{4}[-/]\\d{1,2}[-/]\\d{1,2}$";
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};

    @Override
    public Boolean judgeDeviceExistByFactoryNo(String factoryNo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(EDevice::getFactoryNo, (Object)factoryNo)).eq(BaseEntity::getIsValid, (Object)1)).last("limit 1")).select(new SFunction[]{EDevice::getId});
        EDevice device = (EDevice)this.deviceService.getOne((Wrapper)wrapper);
        return device != null;
    }

    @Override
    @Transactional
    public void importDeviceRay(List<DeviceRayImportDto> importDataList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_DEVICE_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.importDeviceRayLock(importDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb.toString());
            throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
        }
    }

    @Transactional
    public void importDeviceRayLock(List<DeviceRayImportDto> importList) {
        this.checkDeviceRayImportInfoList(importList);
        List<TransformedDeviceImportDto> transformedDataList = this.transformImportInfoList(importList);
        transformedDataList.stream().forEach(transformedDto -> {
            EDevice deviceBase = transformedDto.getDeviceBase();
            this.deviceService.save(deviceBase);
            EDeviceRay deviceRay = transformedDto.getDeviceRay();
            this.rayService.save(deviceRay);
        });
    }

    public void checkDeviceRayImportInfoList(List<DeviceRayImportDto> importList) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, List<DeviceRayImportDto>> noMap = importList.stream().filter(v -> StrUtil.isNotBlank((CharSequence)v.getFactoryNo())).collect(Collectors.groupingBy(v -> v.getFactoryNo()));
        noMap.forEach((no, list) -> {
            if (list.size() >= 2) {
                stringBuilder.append("\u8bbe\u5907\u7f16\u53f7").append((String)no).append("\u5728excel\u4e2d\u91cd\u590d\u5b58\u5728\uff0c\u5220\u9664\u91cd\u590d\u586b\u5199\u7684\u8bbe\u5907\u7f16\u53f7\u3002");
            }
        });
        if (stringBuilder.length() > 0) {
            throw new ServiceException(stringBuilder.toString());
        }
        ArrayList<DeviceRayImportDto> errorInfoList = new ArrayList<DeviceRayImportDto>();
        int rowIndex = 4;
        for (DeviceRayImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactoryNo())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactory())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getModel())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getStatusStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getStatusStr().equals("\u6b63\u5e38") || importDto.getStatusStr().equals("\u6682\u505c\u4f7f\u7528") || importDto.getStatusStr().equals("\u9000\u5f79\u62a5\u5e9f"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u72b6\u6001\u53ea\u80fd\u4e3a\"\u6b63\u5e38\u3001\u6682\u505c\u4f7f\u7528\u3001\u9000\u5f79\u62a5\u5e9f\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            if (importDto.getProductionDate() != null && !this.isValidDateForImport(importDto.getProductionDate())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u6309\u7167\u6a21\u677f\u4e2d\u63d0\u4f9b\u7684\u683c\u5f0f\u8fdb\u884c\u586b\u5199\n", rowIndex));
            }
            if (this.judgeDeviceExistByFactoryNo(importDto.getFactoryNo()).booleanValue()) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u5df2\u5b58\u5728\u5f53\u524d\u8bbe\u5907\u7f16\u53f7\u7684\u8bbe\u5907\n", rowIndex));
            }
            if (sb.length() > 0) {
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    public List<TransformedDeviceImportDto> transformImportInfoList(List<DeviceRayImportDto> importList) {
        ArrayList<TransformedDeviceImportDto> resultList = new ArrayList<TransformedDeviceImportDto>();
        for (DeviceRayImportDto importDto : importList) {
            TransformedDeviceImportDto transformedDto = new TransformedDeviceImportDto();
            EDevice deviceBase = this.deviceConverter.importDto2BaseEntity(importDto);
            deviceBase.setId(Long.valueOf(IdWorker.getId()));
            deviceBase.setCid(ShiroUtil.getLoginUserCid());
            deviceBase.setType(EdeviceTypeEnum.DEVICE_RAY.getValue());
            deviceBase.setLicenseStatus(EdeviceLicenseStatusEnum.UNAUTHORIZED.getValue());
            deviceBase.setLicenseStatusType(EdeviceLicenseStatusTypeEnum.NONE.getValue());
            deviceBase.setCreateBy(ShiroUtil.getLoginUserId());
            EDeviceRay deviceRay = this.deviceConverter.importDto2RayEntity(importDto);
            deviceRay.setId(Long.valueOf(IdWorker.getId()));
            deviceRay.setDid(deviceBase.getId());
            deviceRay.setCid(ShiroUtil.getLoginUserCid());
            deviceRay.setCreateBy(ShiroUtil.getLoginUserId());
            deviceRay.setProductionDate(EDeviceManageServiceImpl.convertStringToDateForImport(importDto.getProductionDate()));
            transformedDto.setDeviceBase(deviceBase);
            transformedDto.setDeviceRay(deviceRay);
            resultList.add(transformedDto);
        }
        return resultList;
    }

    @Override
    @Transactional
    public void importDeviceSource(List<DeviceSourceImportDto> importDataList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_DEVICE_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.importDeviceSourceLock(importDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb.toString());
            throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
        }
    }

    @Transactional
    public void importDeviceSourceLock(List<DeviceSourceImportDto> importList) {
        this.checkDeviceSourceImportData(importList);
        List<TransformedDeviceImportDto> transformedDataList = this.transformDeviceSourceImportData(importList);
        transformedDataList.stream().forEach(transformedDto -> {
            EDevice deviceBase = transformedDto.getDeviceBase();
            this.deviceService.save(deviceBase);
            EDeviceSource deviceSource = transformedDto.getDeviceSource();
            this.deviceSourceService.save(deviceSource);
        });
    }

    public void checkDeviceSourceImportData(List<DeviceSourceImportDto> importList) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, List<DeviceSourceImportDto>> noMap = importList.stream().filter(v -> StrUtil.isNotBlank((CharSequence)v.getFactoryNo())).collect(Collectors.groupingBy(DeviceSourceImportDto::getFactoryNo));
        noMap.forEach((no, list) -> {
            if (list.size() >= 2) {
                stringBuilder.append("\u8bbe\u5907\u7f16\u53f7").append((String)no).append("\u5728excel\u4e2d\u91cd\u590d\u5b58\u5728\uff0c\u5220\u9664\u91cd\u590d\u586b\u5199\u7684\u8bbe\u5907\u7f16\u53f7\u3002");
            }
        });
        if (stringBuilder.length() > 0) {
            throw new ServiceException(stringBuilder.toString());
        }
        ArrayList<DeviceSourceImportDto> errorInfoList = new ArrayList<DeviceSourceImportDto>();
        int rowIndex = 4;
        for (DeviceSourceImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactoryNo())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getModel())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactory())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getStatusStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getStatusStr().equals("\u6b63\u5e38") || importDto.getStatusStr().equals("\u6682\u505c\u4f7f\u7528") || importDto.getStatusStr().equals("\u9000\u5f79\u62a5\u5e9f"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u72b6\u6001\u53ea\u80fd\u4e3a\"\u6b63\u5e38\u3001\u6682\u505c\u4f7f\u7528\u3001\u9000\u5f79\u62a5\u5e9f\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getPersonInCharge())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (this.judgeDeviceExistByFactoryNo(importDto.getFactoryNo()).booleanValue()) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u5df2\u5b58\u5728\u5f53\u524d\u8bbe\u5907\u7f16\u53f7\u7684\u8bbe\u5907\n", rowIndex));
            }
            if (sb.length() > 0) {
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    public List<TransformedDeviceImportDto> transformDeviceSourceImportData(List<DeviceSourceImportDto> importList) {
        ArrayList<TransformedDeviceImportDto> resultList = new ArrayList<TransformedDeviceImportDto>();
        for (DeviceSourceImportDto importDto : importList) {
            TransformedDeviceImportDto transformedDto = new TransformedDeviceImportDto();
            EDevice deviceBase = this.deviceConverter.importDto2BaseEntity(importDto);
            deviceBase.setId(Long.valueOf(IdWorker.getId()));
            deviceBase.setCid(ShiroUtil.getLoginUserCid());
            deviceBase.setType(EdeviceTypeEnum.DEVICE_SOURCE.getValue());
            deviceBase.setLicenseStatus(EdeviceLicenseStatusEnum.UNAUTHORIZED.getValue());
            deviceBase.setLicenseStatusType(EdeviceLicenseStatusTypeEnum.NONE.getValue());
            deviceBase.setCreateBy(ShiroUtil.getLoginUserId());
            EDeviceSource deviceSource = this.deviceConverter.importDto2DeviceSourceEntity(importDto);
            deviceSource.setId(Long.valueOf(IdWorker.getId()));
            deviceSource.setDid(deviceBase.getId());
            deviceSource.setCid(ShiroUtil.getLoginUserCid());
            deviceSource.setCreateBy(ShiroUtil.getLoginUserId());
            transformedDto.setDeviceBase(deviceBase);
            transformedDto.setDeviceSource(deviceSource);
            resultList.add(transformedDto);
        }
        return resultList;
    }

    @Override
    @Transactional
    public void importSourceNonSealed(List<SourceNonSealedImportDto> importDataList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_DEVICE_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.importSourceNonSealedLock(importDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb.toString());
            throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
        }
    }

    @Transactional
    public void importSourceNonSealedLock(List<SourceNonSealedImportDto> importDataList) {
        this.checkSourceNonSealedImportData(importDataList);
        List<TransformedDeviceImportDto> transformedDataList = this.transformSourceNonSealedImportData(importDataList);
        transformedDataList.stream().forEach(transformedDto -> {
            EDevice deviceBase = transformedDto.getDeviceBase();
            this.deviceService.save(deviceBase);
            ESourceNonSealed sourceNonSealed = transformedDto.getSourceNonSealed();
            this.sourceNonSealedService.save(sourceNonSealed);
        });
    }

    public void checkSourceNonSealedImportData(List<SourceNonSealedImportDto> importList) {
        ArrayList<SourceNonSealedImportDto> errorInfoList = new ArrayList<SourceNonSealedImportDto>();
        int rowIndex = 4;
        for (SourceNonSealedImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!this.judgeSourceName(importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u6838\u7d20\u540d\u79f0\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getPhysicalStateStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u7269\u7406\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getPhysicalStateStr().equals("\u56fa\u6001") || importDto.getPhysicalStateStr().equals("\u6db2\u6001") || importDto.getPhysicalStateStr().equals("\u6c14\u6001"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u7269\u7406\u72b6\u6001\u53ea\u80fd\u4e3a\"\u56fa\u6001\u3001\u6db2\u6001\u3001\u6c14\u6001\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactoryActivity())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u6d3b\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!importDto.getFactoryActivity().contains("\u00d710^")) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u6d3b\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\"\u6570\u5b57\u00d710^\u6570\u5b57\"\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getMaxDailyDose())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6700\u5927\u7b49\u6548\u65e5\u64cd\u4f5c\u91cf\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!importDto.getMaxDailyDose().contains("\u00d710^")) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6700\u5927\u7b49\u6548\u65e5\u64cd\u4f5c\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\"\u6570\u5b57\u00d710^\u6570\u5b57\"\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getMaxDailyDose())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6700\u5927\u7b49\u6548\u5e74\u64cd\u4f5c\u91cf\u4e0d\u80fd\u4e3a\u7a7a", rowIndex));
            } else if (!importDto.getMaxDailyDose().contains("\u00d710^")) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6700\u5927\u7b49\u6548\u5e74\u64cd\u4f5c\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\"\u6570\u5b57\u00d710^\u6570\u5b57\"\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactory())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getPersonInCharge())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (sb.length() > 0) {
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    public List<TransformedDeviceImportDto> transformSourceNonSealedImportData(List<SourceNonSealedImportDto> importList) {
        ArrayList<TransformedDeviceImportDto> resultList = new ArrayList<TransformedDeviceImportDto>();
        List paramList = this.sysParamProvider.getList(Long.valueOf(201L));
        Map<String, String> paramSourceNameMap = paramList.stream().collect(Collectors.toMap(vo -> vo.getName().replaceAll("[^a-zA-Z]", ""), SysParamVo::getName));
        for (SourceNonSealedImportDto importDto : importList) {
            TransformedDeviceImportDto transformedDto = new TransformedDeviceImportDto();
            EDevice deviceBase = this.deviceConverter.importDto2BaseEntity(importDto);
            deviceBase.setId(Long.valueOf(IdWorker.getId()));
            deviceBase.setCid(ShiroUtil.getLoginUserCid());
            deviceBase.setName(paramSourceNameMap.get(importDto.getName()));
            deviceBase.setType(EdeviceTypeEnum.SOURCE_NON_SEALED.getValue());
            deviceBase.setLicenseStatus(EdeviceLicenseStatusEnum.UNAUTHORIZED.getValue());
            deviceBase.setLicenseStatusType(EdeviceLicenseStatusTypeEnum.NONE.getValue());
            deviceBase.setCreateBy(ShiroUtil.getLoginUserId());
            ESourceNonSealed sourceNonSealed = this.deviceConverter.importDto2SourceNonSealedEntity(importDto);
            sourceNonSealed.setId(Long.valueOf(IdWorker.getId()));
            sourceNonSealed.setDid(deviceBase.getId());
            sourceNonSealed.setCid(ShiroUtil.getLoginUserCid());
            sourceNonSealed.setCreateBy(ShiroUtil.getLoginUserId());
            transformedDto.setDeviceBase(deviceBase);
            transformedDto.setSourceNonSealed(sourceNonSealed);
            resultList.add(transformedDto);
        }
        return resultList;
    }

    @Override
    @Transactional
    public void importSourceSealed(List<SourceSealedImportDto> importDataList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_DEVICE_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.importSourceSealedLock(importDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb.toString());
            throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
        }
    }

    @Transactional
    public void importSourceSealedLock(List<SourceSealedImportDto> importDataList) {
        this.checkSourceSealedImportData(importDataList);
        List<TransformedDeviceImportDto> transformedDataList = this.transformSourceSealedImportData(importDataList);
        transformedDataList.stream().forEach(transformedDto -> {
            EDevice deviceBase = transformedDto.getDeviceBase();
            this.deviceService.save(deviceBase);
            ESourceSealed sourceSealed = transformedDto.getSourceSealed();
            this.sourceSealedService.save(sourceSealed);
        });
    }

    public void checkSourceSealedImportData(List<SourceSealedImportDto> importList) {
        ArrayList<SourceSealedImportDto> errorInfoList = new ArrayList<SourceSealedImportDto>();
        int rowIndex = 4;
        for (SourceSealedImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!this.judgeSourceName(importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u6838\u7d20\u540d\u79f0\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getNuclideUniqueCode())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u56fd\u5bb6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactory())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getStatusStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u653e\u5c04\u6e90\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getStatusStr().equals("\u6b63\u5e38") || importDto.getStatusStr().equals("\u6682\u505c\u4f7f\u7528") || importDto.getStatusStr().equals("\u9000\u5f79\u62a5\u5e9f"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u653e\u5c04\u6e90\u72b6\u6001\u53ea\u80fd\u4e3a\"\u6b63\u5e38\u3001\u6682\u505c\u4f7f\u7528\u3001\u9000\u5f79\u62a5\u5e9f\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getUseTo())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactoryActivity())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u6d3b\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!importDto.getFactoryActivity().contains("\u00d710^")) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u6d3b\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\"\u6570\u5b57\u00d710^\u6570\u5b57\"\n", rowIndex));
            }
            if (importDto.getMeasurementDate() == null) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6d3b\u5ea6\u6d4b\u91cf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!this.isValidDateForImport(importDto.getMeasurementDate())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6d3b\u5ea6\u6d4b\u91cf\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6309\u7167\u6a21\u677f\u4e2d\u63d0\u4f9b\u7684\u683c\u5f0f\u8fdb\u884c\u586b\u5199\n", rowIndex));
            }
            if (importDto.getProductionDate() == null) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!this.isValidDateForImport(importDto.getProductionDate())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6309\u7167\u6a21\u677f\u4e2d\u63d0\u4f9b\u7684\u683c\u5f0f\u8fdb\u884c\u586b\u5199\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getPersonInCharge())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (sb.length() > 0) {
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    private boolean judgeSourceName(String name) {
        List paramList = this.sysParamProvider.getList(Long.valueOf(201L));
        Set sourceNameSet = paramList.stream().map(SysParamVo::getName).map(str -> str.replaceAll("[^a-zA-Z]", "")).collect(Collectors.toSet());
        return sourceNameSet.contains(name);
    }

    public List<TransformedDeviceImportDto> transformSourceSealedImportData(List<SourceSealedImportDto> importList) {
        ArrayList<TransformedDeviceImportDto> resultList = new ArrayList<TransformedDeviceImportDto>();
        List paramList = this.sysParamProvider.getList(Long.valueOf(201L));
        Map<String, String> paramSourceNameMap = paramList.stream().collect(Collectors.toMap(vo -> vo.getName().replaceAll("[^a-zA-Z]", ""), SysParamVo::getName));
        for (SourceSealedImportDto importDto : importList) {
            TransformedDeviceImportDto transformedDto = new TransformedDeviceImportDto();
            EDevice deviceBase = this.deviceConverter.importDto2BaseEntity(importDto);
            deviceBase.setId(Long.valueOf(IdWorker.getId()));
            deviceBase.setCid(ShiroUtil.getLoginUserCid());
            deviceBase.setName(paramSourceNameMap.get(importDto.getName()));
            deviceBase.setType(EdeviceTypeEnum.SOURCE_SEALED.getValue());
            deviceBase.setLicenseStatus(EdeviceLicenseStatusEnum.UNAUTHORIZED.getValue());
            deviceBase.setLicenseStatusType(EdeviceLicenseStatusTypeEnum.NONE.getValue());
            deviceBase.setCreateBy(ShiroUtil.getLoginUserId());
            ESourceSealed sourceSealed = this.deviceConverter.importDto2SourceSealedEntity(importDto);
            sourceSealed.setId(Long.valueOf(IdWorker.getId()));
            sourceSealed.setDid(deviceBase.getId());
            sourceSealed.setCid(ShiroUtil.getLoginUserCid());
            sourceSealed.setCreateBy(ShiroUtil.getLoginUserId());
            sourceSealed.setMeasurementDate(EDeviceManageServiceImpl.convertStringToDateForImport(importDto.getMeasurementDate()));
            sourceSealed.setProductionDate(EDeviceManageServiceImpl.convertStringToDateForImport(importDto.getProductionDate()));
            transformedDto.setDeviceBase(deviceBase);
            transformedDto.setSourceSealed(sourceSealed);
            resultList.add(transformedDto);
        }
        return resultList;
    }

    public boolean isValidDateForImport(String dateStr) {
        Pattern pattern = Pattern.compile(DATE_PATTERN);
        Matcher matcher = pattern.matcher(dateStr);
        return matcher.matches();
    }

    public static Date convertStringToDateForImport(String dateStr) {
        Boolean isSuccess = true;
        for (String format : DATE_FORMATS) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            try {
                return sdf.parse(dateStr);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    public EDeviceManageServiceImpl(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

