/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.e;

import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.dao.e.ErelationMapper;
import cn.smarthse.rho.modules.company.service.e.IErelationService;
import cn.smarthse.rho.modules.sys.entity.e.ERelation;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceDetailParam;
import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import cn.smarthse.rho.modules.sys.model.e.vo.ERelationVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class ErelationServiceImpl
extends ServiceImpl<ErelationMapper, ERelation>
implements IErelationService {
    @Override
    public void addRelationForDevice(ERelation newRelation) {
        this.save(newRelation);
    }

    @Override
    @Transactional
    public void freeRoomRelationForDevice(Long deviceId) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ERelation::getIsCur, (Object)0)).isNotNull(ERelation::getRoomId)).isNull(ERelation::getSourceId)).eq(ERelation::getDeviceId, (Object)deviceId)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void freeSourceRelationForDevice(Long deviceId) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ERelation::getIsCur, (Object)0)).isNotNull(ERelation::getSourceId)).eq(ERelation::getDeviceId, (Object)deviceId)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void freeBatchRelationById(List<Long> relationIdList) {
        if (CollectionUtils.isEmpty(relationIdList)) {
            return;
        }
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.set(ERelation::getIsCur, (Object)0)).in(ERelation::getId, relationIdList)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        this.update((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void addAssociationForSource(ERelation newRelation) {
        if (newRelation.getSourceId() == null) {
            throw new RuntimeException("\u7f3a\u5c11\u6838\u7d20\u4fe1\u606f\uff01");
        }
        newRelation.setId(null);
        newRelation.setIsCur(Integer.valueOf(1));
        this.save(newRelation);
    }

    @Override
    public void changeSourceOfRoomRelationForDevice(Long beforeRoomId, Long deviceId, Long afterRoomId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(ERelation::getRoomId, (Object)afterRoomId)).eq(ERelation::getRoomId, (Object)beforeRoomId)).eq(ERelation::getDeviceId, (Object)deviceId)).eq(ERelation::getIsCur, (Object)1)).isNotNull(ERelation::getSourceId)).eq(BaseEntity::getIsValid, (Object)1);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void delAssociationByRelationId(ERelationDto param) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ERelation::getSourceId, (Object)param.getSourceId())).eq(ERelation::getRoomId, (Object)param.getRoomId())).eq(ERelation::getIsCur, (Object)1);
        if (param.getDeviceId() == null) {
            queryWrapper.isNull(ERelation::getDeviceId);
        } else {
            queryWrapper.eq(ERelation::getDeviceId, (Object)param.getDeviceId());
        }
        ERelation relation = (ERelation)this.getOne((Wrapper)queryWrapper);
        relation.setIsCur(Integer.valueOf(0));
        this.updateById(relation);
        relation.setId(null);
        relation.setBeforeChangeName(relation.getAfterChangeName());
        relation.setAfterChangeName("-");
        relation.setChangeDate(LocalDateTime.now());
        relation.setOperatorName(ShiroUtil.getLoginUsername());
        this.save(relation);
    }

    @Override
    @Transactional
    public void disassociateByDeviceIdAndType(Long deviceId, Integer type) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(ERelation::getIsCur, (Object)0)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        if (type == EdeviceTypeEnum.DEVICE_RAY.getValue() || type == EdeviceTypeEnum.DEVICE_SOURCE.getValue()) {
            updateWrapper.eq(ERelation::getDeviceId, (Object)deviceId);
        } else if (type == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue() || type == EdeviceTypeEnum.SOURCE_SEALED.getValue()) {
            updateWrapper.eq(ERelation::getSourceId, (Object)deviceId);
        }
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public void disassociateBySourceId(Long sourceId) {
    }

    @Override
    @Transactional
    public void updateAssociationForSource(Long sourceId, List<ERelation> newRelationList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ERelation::getSourceId, (Object)sourceId)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        List curRelationList = this.list((Wrapper)queryWrapper);
        ArrayList<ERelation> needDisassociateRelation = new ArrayList<ERelation>();
        block0: for (ERelation curRelation : curRelationList) {
            for (ERelation newRelation : newRelationList) {
                if (curRelation.getRoomId() == newRelation.getRoomId() || curRelation.getDeviceId() == newRelation.getDeviceId()) continue;
                curRelation.setIsCur(Integer.valueOf(0));
                needDisassociateRelation.add(curRelation);
                continue block0;
            }
        }
        this.updateBatchById(needDisassociateRelation);
        if (!CollectionUtils.isEmpty(newRelationList)) {
            ArrayList<ERelation> establishRelation = new ArrayList<ERelation>();
            block2: for (ERelation newRelation : newRelationList) {
                for (ERelation curRelation : curRelationList) {
                    if (newRelation.getRoomId() == curRelation.getRoomId() || newRelation.getDeviceId() == curRelation.getDeviceId()) continue;
                    newRelation.setId(null);
                    newRelation.setIsCur(Integer.valueOf(1));
                    establishRelation.add(newRelation);
                    continue block2;
                }
            }
            this.saveBatch(establishRelation);
        }
    }

    @Override
    public LayuiGridData<ERelationVo> listRoomChangeRecordForDevice(EDeviceDetailParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ERelationVo> rst = ((ErelationMapper)this.baseMapper).listRoomChangeRecordForDevice(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public List<ERelationDto> listRoomRelationByDeviceId(Long deviceId) {
        return ((ErelationMapper)this.baseMapper).listRoomRelationByDeviceId(deviceId);
    }

    @Override
    public String getRoomNameForMobilityDevice(Long deviceId) {
        return ((ErelationMapper)this.baseMapper).getRoomNameForMobilityDevice(deviceId);
    }

    @Override
    public List<ERelationDto> listCurRelationByType(Integer type, Long businessId) {
        return ((ErelationMapper)this.baseMapper).listCurRelationByType(type, businessId);
    }
}

