/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.e;

import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.EMachineRoomConverter;
import cn.smarthse.rho.modules.company.dao.e.EdeviceMapper;
import cn.smarthse.rho.modules.company.dao.e.EmachineRoomMapper;
import cn.smarthse.rho.modules.company.service.e.IEmachineRoomService;
import cn.smarthse.rho.modules.sys.entity.e.EMachineRoom;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.model.e.param.EMachineRoomDto;
import cn.smarthse.rho.modules.sys.model.e.param.EMachineSearchParam;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceCurBindSourceVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomCheckDataVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomDetailVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomDeviceVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomLevelStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomListVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomSourceVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class EmachinRoomServiceImpl
extends ServiceImpl<EmachineRoomMapper, EMachineRoom>
implements IEmachineRoomService {
    @Autowired(required=false)
    private EdeviceMapper deviceMapper;
    @Autowired
    private EMachineRoomConverter machineRoomConverter;
    @Autowired
    private RedissonClient redissonClient;

    @Override
    public LayuiGridData<EMachineRoomListVo> listMachineRoom(EMachineSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EMachineRoomListVo> rst = ((EmachineRoomMapper)this.baseMapper).listMachineRoom(param);
        if (!CollectionUtils.isEmpty(rst)) {
            for (EMachineRoomListVo room : rst) {
                room.setDiagnosisType(((EmachineRoomMapper)this.baseMapper).getMachineRoomDiagnosisType(room.getId()));
            }
        }
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public EMachineRoomDetailVo getMachineRoomDetail(EMachineSearchParam param) {
        EMachineRoomDetailVo rst = ((EmachineRoomMapper)this.baseMapper).getMachineRoomById(param.getId());
        if (rst == null) {
            return null;
        }
        rst.setDiagnosisType(((EmachineRoomMapper)this.baseMapper).getMachineRoomDiagnosisType(rst.getId()));
        List<EMachineRoomDeviceVo> deviceList = ((EmachineRoomMapper)this.baseMapper).listDeviceByRoomId(param);
        if (!CollectionUtils.isEmpty(deviceList)) {
            deviceList.stream().forEach(device -> {
                EDeviceCurBindSourceVo curBindingSource;
                if (device.getType() == EdeviceTypeEnum.DEVICE_SOURCE.getValue() && (curBindingSource = this.deviceMapper.getCurBindingSource(device.getId())) != null) {
                    device.setSealName(curBindingSource.getName());
                    device.setData1(curBindingSource.getData1());
                    device.setData2(curBindingSource.getData2());
                    device.setMeasurementDate(curBindingSource.getMeasurementDate());
                }
            });
            rst.setDeviceList(deviceList);
        }
        List<EMachineRoomSourceVo> sourceList = ((EmachineRoomMapper)this.baseMapper).listSourceByRoomId(param.getId());
        rst.setSourceList(sourceList);
        return rst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public Long addMachineRoomDetail(EMachineRoomDto param) {
        EMachineRoom machineRoom = this.machineRoomConverter.baseDto2Entity(param);
        String lock_key = String.format("genMachineRoomSerialNo:%s", ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(lock_key);
        try {
            if (lock.tryLock(2L, TimeUnit.MINUTES)) {
                this.handleSerialNoAndSaveMachineRoom(machineRoom);
            }
        }
        catch (Exception e) {
            this.log.error("exception \uff1a{}", (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return machineRoom.getId();
    }

    public void handleSerialNoAndSaveMachineRoom(EMachineRoom machineRoom) {
        machineRoom.setId(null);
        machineRoom.setLicenseStatus(Integer.valueOf(0));
        machineRoom.setLicenseStatusType(Integer.valueOf(0));
        machineRoom.setWarningStatus(Integer.valueOf(0));
        String medicalNucode = ShiroUtil.getLoginMedicalNucode();
        Integer maxSerialNo = ((EmachineRoomMapper)this.baseMapper).getMaxSerialNoByCid(ShiroUtil.getLoginUserCid());
        if (maxSerialNo == null) {
            maxSerialNo = 0;
        }
        int newSerialNo = maxSerialNo + 1;
        machineRoom.setRoomCode(medicalNucode + String.format("%06d", newSerialNo));
        machineRoom.setSerialNo(Integer.valueOf(newSerialNo));
        this.save(machineRoom);
    }

    @Override
    @Transactional
    public void editMachineRoomDetail(EMachineRoomDto param) {
        if (param.getId() == null) {
            return;
        }
        EMachineRoom machineRoom = this.machineRoomConverter.baseDto2Entity(param);
        this.updateById(machineRoom);
    }

    @Override
    @Transactional
    public void delMachineRoom(EMachineSearchParam param) {
        if (param.getId() == null) {
            return;
        }
        Integer relationNum = ((EmachineRoomMapper)this.baseMapper).getRelationNumByRoomId(param.getId());
        if (relationNum != null && relationNum > 0) {
            throw new ServiceException("\u8be5\u673a\u623f\u5df2\u4e0e\u8bbe\u5907\u5173\u8054\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)param.getId())).eq((Object)"is_valid", (Object)1)).set((Object)"is_valid", (Object)0);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public EMachineRoomLevelStatisticsVo getLevelStatistics(Long cid, Integer deviceType) {
        return ((EmachineRoomMapper)this.baseMapper).getLevelStatistics(cid, deviceType);
    }

    @Override
    public String getNameById(Long id) {
        String rst = "";
        if (id == null) {
            return rst;
        }
        EMachineRoom room = (EMachineRoom)this.getById(id);
        rst = room.getName();
        return rst;
    }

    @Override
    public LayuiGridData<EMachineRoomDeviceVo> listUnselectedDeviceByRoomId(EMachineSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EMachineRoomDeviceVo> rst = ((EmachineRoomMapper)this.baseMapper).listUnselectedDeviceByRoomId(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<EMachineRoomCheckDataVo> listCheckDataByRoomId(EMachineSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EMachineRoomCheckDataVo> rst = ((EmachineRoomMapper)this.baseMapper).listCheckDataByRoomId(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<EMachineRoomListVo> listMachineRoomForDevice(EMachineSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EMachineRoomListVo> rst = ((EmachineRoomMapper)this.baseMapper).listMachineRoomForDevice(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }
}

