/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.d;

import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.company.dao.d.DDeviceCheckMapper;
import cn.smarthse.rho.modules.company.service.d.IDDeviceCheckDataService;
import cn.smarthse.rho.modules.company.service.d.IDDeviceCheckService;
import cn.smarthse.rho.modules.sys.entity.d.DDeviceCheck;
import cn.smarthse.rho.modules.sys.entity.d.DDeviceCheckData;
import cn.smarthse.rho.modules.sys.model.d.param.DDeviceCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.d.vo.AddDeviceCheckVo;
import cn.smarthse.rho.modules.sys.model.d.vo.DDeviceCheckVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DDeviceCheckServiceImpl
extends ServiceImpl<DDeviceCheckMapper, DDeviceCheck>
implements IDDeviceCheckService {
    @Autowired
    private IDDeviceCheckDataService deviceCheckDataService;

    @Override
    public LayuiGridData<DDeviceCheckVo> getCheckList(DDeviceCheckQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((DDeviceCheckMapper)this.baseMapper).getCheckList(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    @Override
    public DDeviceCheck getCheckDetail(Long checkId) {
        return (DDeviceCheck)this.getById(checkId);
    }

    @Override
    @Transactional
    public void addDeviceCheckByManual(AddDeviceCheckVo param) {
        DDeviceCheck deviceCheck = param.getDeviceCheck();
        if (deviceCheck.getCid() == null || deviceCheck.getCheckTime() == null || deviceCheck.getHospitalCode() == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff01cid/checkTime/hospitalCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        deviceCheck.setId(null);
        this.save(deviceCheck);
        List deviceCheckDataList = param.getDeviceCheckDataList();
        for (DDeviceCheckData deviceCheckData : deviceCheckDataList) {
            if (deviceCheckData.getDeviceId() == null) {
                throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff01deviceId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            deviceCheckData.setId(null);
            deviceCheckData.setCheckId(deviceCheck.getId());
            deviceCheckData.setCid(deviceCheck.getCid());
            deviceCheckData.setHospitalCode(deviceCheck.getHospitalCode());
            deviceCheckData.setHospital(deviceCheck.getHospital());
            deviceCheckData.setCheckTime(deviceCheck.getCheckTime());
        }
        this.deviceCheckDataService.saveBatch(deviceCheckDataList);
    }
}

