/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.c;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.CTrainingCertConverter;
import cn.smarthse.rho.modules.company.dao.c.CTrainingCertMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.company.service.r.IRKeyFactorAuditService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.entity.r.RKeyFactorAudit;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffCertSourceEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertResultEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertSourceEnum;
import cn.smarthse.rho.modules.sys.model.c.param.CTrainingCertPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingCertEditParam;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CTrainingCertServiceImpl
extends ServiceImpl<CTrainingCertMapper, CTrainingCert>
implements ICTrainingCertService {
    @Autowired
    private CTrainingCertConverter converter;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IRKeyFactorAuditService keyFactorAuditService;
    @DubboReference
    private ISysBusinessOperateLogProvider logProvider;

    @Override
    public LayuiGridData<CTrainingCert> getListForArchive(CTrainingCertPageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CTrainingCert> list = ((CTrainingCertMapper)this.baseMapper).getListForArchive(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<CTrainingCert> getListForKeyFactor(CTrainingCertPageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CTrainingCert> list = ((CTrainingCertMapper)this.baseMapper).getListForKeyFactor(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void addOrEditCert(TrainingCertEditParam param) {
        if (!param.getIfDraft().booleanValue() && (StringUtils.isEmpty((CharSequence)param.getStaffName()) || StringUtils.isEmpty((CharSequence)param.getIdcard()))) {
            throw new ServiceException("\u4eba\u5458\u59d3\u540d\u6216\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CTrainingCert cert = this.converter.param2Entity(param);
        cert.setSource(StaffCertSourceEnum.HOSPITAL.getValue());
        cert.setIdcard(param.getIdcard());
        cert.setResult(TrainingCertResultEnum.QUALIFIED.getValue());
        BCompany company = (BCompany)this.companyService.getById(cert.getCid());
        if (company != null) {
            cert.setCompName(company.getName());
        }
        if (!param.getIfDraft().booleanValue()) {
            cert.setAuditStatus(TrainingCertAuditStatusEnum.WAIT_AUDIT.getValue());
        } else {
            cert.setAuditStatus(TrainingCertAuditStatusEnum.DRAFT.getValue());
        }
        this.saveOrUpdate(cert);
        if (!param.getIfDraft().booleanValue()) {
            RKeyFactorAudit keyFactorAudit = new RKeyFactorAudit();
            keyFactorAudit.setType(RiskTypeEnum.TRAINING.getValue());
            keyFactorAudit.setStatus(KeyFactoAuditStatusEnum.AUDIT.getCode());
            keyFactorAudit.setBusinessId(cert.getId());
            keyFactorAudit.setCid(cert.getCid());
            if (param.getKeyFactorAuditId() != null) {
                keyFactorAudit.setId(param.getKeyFactorAuditId());
            }
            if (company != null) {
                keyFactorAudit.setCompanyName(company.getName());
                keyFactorAudit.setCompanyAddress(company.getAddress());
            }
            this.keyFactorAuditService.saveOrUpdate(keyFactorAudit);
            SysBusinessOperateLog log = new SysBusinessOperateLog();
            log.setBusinessId(param.getKeyFactorAuditId() != null ? param.getKeyFactorAuditId() : keyFactorAudit.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_1.getValue()).setType(SysBusinessOperateLogTypeEnum.SUBMIT.getValue()).setCid(param.getCid()).setOperator(ShiroUtil.getLoginUsername()).setOperatorCompanyName(param.getCompName());
            this.logProvider.addOrUpdateLog(log);
        }
    }

    @Override
    public CTrainingCert getLastData(Long staffBaseInfoId) {
        return ((CTrainingCertMapper)this.baseMapper).getLastData(staffBaseInfoId);
    }

    @Override
    public CTrainingCert getTrainingCertDetailById(Long id) {
        return ((CTrainingCertMapper)this.baseMapper).getTrainingCertDetailById(id);
    }

    @Override
    @Transactional
    public void suspendApplication(Long id) {
        this.updateStatusById(id, TrainingCertAuditStatusEnum.TERMINATED.getValue());
        List<Integer> statusList = Arrays.asList(KeyFactoAuditStatusEnum.AUDIT.getCode(), KeyFactoAuditStatusEnum.BACK.getCode());
        List<RKeyFactorAudit> lists = this.keyFactorAuditService.getListsByBusinessId(id, statusList);
        if (!CollectionUtils.isEmpty(lists)) {
            lists.forEach(item -> {
                item.setStatus(KeyFactoAuditStatusEnum.CLOSED.getCode());
                item.setUpdateBy(ShiroUtil.getLoginUserOriginalCid());
                item.setUpdateDate(new Date());
            });
            this.keyFactorAuditService.updateBatchById(lists);
        }
        ArrayList logs = new ArrayList();
        if (!CollectionUtils.isEmpty(lists)) {
            lists.forEach(item -> {
                SysBusinessOperateLog log = new SysBusinessOperateLog();
                log.setBusinessId(item.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_1.getValue()).setType(SysBusinessOperateLogTypeEnum.TERMINATED.getValue()).setCid(item.getCid()).setOperator(ShiroUtil.getLoginFullName()).setOperatorCompanyName(ShiroUtil.getLoginUsername());
                logs.add(log);
            });
            this.logProvider.addBatchLog(logs);
        }
    }

    @Override
    public void updateStatusById(Long id, Integer status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(CTrainingCert::getId, (Object)id)).set(CTrainingCert::getAuditStatus, (Object)status);
        ((CTrainingCertMapper)this.baseMapper).update((Wrapper)wrapper);
    }

    @Override
    public void delById(Long id) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(CTrainingCert::getId, (Object)id)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).eq(CTrainingCert::getSource, (Object)TrainingCertSourceEnum.UNIT.getValue())).eq(CTrainingCert::getAuditStatus, (Object)TrainingCertAuditStatusEnum.DRAFT.getValue())).set(BaseEntity::getIsValid, (Object)Constant.ACTIVE_NO);
        ((CTrainingCertMapper)this.baseMapper).update((Wrapper)wrapper);
    }
}

