/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.c;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.CStaffConverter;
import cn.smarthse.rho.modules.company.dao.c.CStaffMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBOrgService;
import cn.smarthse.rho.modules.company.service.c.ICStaffService;
import cn.smarthse.rho.modules.company.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.BPostVo;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffPostPre2OnParam;
import cn.smarthse.rho.modules.sys.provider.company.IPostProvider;
import cn.smarthse.rho.modules.sys.utils.staff.StaffUniqueReferenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class CStaffServiceImpl
extends ServiceImpl<CStaffMapper, CStaff>
implements ICStaffService {
    private static final Logger log = LoggerFactory.getLogger(CStaffServiceImpl.class);
    @Autowired
    private CStaffConverter converter;
    @Autowired
    private ICStaffWorkExperienceService cStaffWorkExperienceService;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IBOrgService orgService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private RedissonClient redissonClient;
    private static final String LOCK_KEY = "CStaffServiceImpl";
    @DubboReference
    private IPostProvider postProvider;

    @Override
    @Transactional
    public void editInfo(CStaffEditParam param) {
        if (param == null) {
            return;
        }
        CStaff cStaff = this.converter.param2Entity(param);
        cStaff.setSource(null);
        if (cStaff == null) {
            return;
        }
        if (cStaff.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        if (cStaff.getCid() != null && !this.companyService.isSameHospital(cStaff.getCid(), ShiroUtil.getLoginUserCid())) {
            throw new ServiceException("\u516c\u53f8\u4fe1\u606f\u4e0d\u660e\u786e\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        CStaff oldStaff = (CStaff)this.getById(param.getId());
        Long cid = cStaff.getCid() != null ? cStaff.getCid() : oldStaff.getCid();
        BCompany company = (BCompany)this.companyService.getById(cid);
        if (company == null) {
            throw new ServiceException("\u516c\u53f8\u4fe1\u606f\u4e0d\u660e\u786e");
        }
        if (param.getOrgId() != null) {
            BOrg org = (BOrg)this.orgService.getById(param.getOrgId());
            if (org == null) {
                throw new ServiceException("\u90e8\u95e8\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u90e8\u95e8");
            }
            if (!org.getCid().equals(cid)) {
                throw new ServiceException("\u6240\u5728\u90e8\u95e8\u4e0d\u5c5e\u4e8e\u5f53\u524d\u6240\u5728\u9662\u533a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u90e8\u95e8\u6216\u8005\u9662\u533a");
            }
        }
        CStaffBaseInfo staffBaseInfo = ((CStaffMapper)this.baseMapper).getBaseInfoById(oldStaff.getBaseId());
        cStaff.setEditTime(LocalDateTime.now());
        cStaff.setUniqueReference(StaffUniqueReferenceUtil.genUniqueReference((String)company.getCreditCode(), (Long)oldStaff.getBaseId()));
        this.updateById(cStaff);
        CStaff newestStaff = (CStaff)this.getById(param.getId());
        this.recordWorkExperience(oldStaff, newestStaff, staffBaseInfo, param);
    }

    @Override
    @Transactional
    public void addInfo(CStaffEditParam param) {
        CStaff cStaff = this.converter.param2Entity(param);
        cStaff.setEditTime(LocalDateTime.now());
        if (cStaff == null) {
            return;
        }
        if (cStaff.getId() != null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        if (cStaff.getBaseId() == null) {
            throw new ServiceException("\u57fa\u7840\u4fe1\u606f\u53c2\u6570\u9519\u8bef\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        if (cStaff.getCid() == null) {
            throw new ServiceException("\u7f3a\u5931\u533b\u9662\u4fe1\u606f");
        }
        BCompany company = (BCompany)this.companyService.getById(cStaff.getCid());
        if (company == null) {
            throw new ServiceException("\u533b\u9662\u4fe1\u606f\u4e0d\u660e\u786e");
        }
        if (cStaff.getCid() != null && !this.companyService.isSameHospital(cStaff.getCid(), ShiroUtil.getLoginUserCid())) {
            throw new ServiceException("\u516c\u53f8\u4fe1\u606f\u4e0d\u660e\u786e\uff0c\u53ef\u5c1d\u8bd5\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5");
        }
        CStaff db = this.getByBaseIdAndCid(cStaff.getBaseId(), cStaff.getCid());
        if (db != null) {
            throw new ServiceException("\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
        }
        CStaff branchStaff = this.getByBaseIdAndBranchCid(cStaff.getBaseId(), cStaff.getCid());
        if (branchStaff != null) {
            throw new ServiceException("\u5df2\u5728\u8be5\u533b\u9662\u5176\u4ed6\u9662\u533a\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
        }
        cStaff.setUniqueReference(StaffUniqueReferenceUtil.genUniqueReference((String)company.getCreditCode(), (Long)cStaff.getBaseId()));
        if (cStaff.getSource() == null) {
            throw new ServiceException("\u7f3a\u5c11\u6570\u636e\u6765\u6e90\uff01");
        }
        this.save(cStaff);
        CStaffBaseInfo staffBaseInfo = ((CStaffMapper)this.baseMapper).getBaseInfoById(param.getBaseId());
        this.recordWorkExperience(cStaff, cStaff, staffBaseInfo, param);
    }

    @Override
    public CStaff getByBaseIdAndCid(Long baseId, Long cid) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CStaff::getBaseId, (Object)baseId)).eq(CStaff::getCid, (Object)cid)).last("limit 1");
        return (CStaff)this.getOne((Wrapper)wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void pre2On(StaffPostPre2OnParam param) {
        log.debug("\u5c97\u4f4d\u7ef4\u62a4\uff1a\u6682\u79bb\uff08\u9884\u4e0a\u5c97\uff09\u8f6c\u4e0a\u5c97 pre2On() start");
        StringBuilder sb = new StringBuilder(LOCK_KEY);
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.pre2OnLock(param);
                log.debug("\u5c97\u4f4d\u7ef4\u62a4\uff1a\u6682\u79bb\uff08\u9884\u4e0a\u5c97\uff09\u8f6c\u4e0a\u5c97 pre2On( end");
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:pre2On()", (Object)LOCK_KEY);
        }
    }

    @Transactional
    public void pre2OnLock(StaffPostPre2OnParam param) {
        List<CStaff> dbList = ((CStaffMapper)this.baseMapper).getNeedPre2OnList(param);
        ArrayList<CStaffEditParam> paramList = new ArrayList<CStaffEditParam>();
        for (CStaff entity : dbList) {
            CStaffEditParam editParam = new CStaffEditParam();
            editParam.setId(entity.getId());
            editParam.setType(Integer.valueOf(1));
            editParam.setPostStatus(PostStatusEnum.ON_POST.getValue());
            editParam.setPostStartTime(entity.getPostStartTime());
            paramList.add(editParam);
        }
        CStaffServiceImpl self = (CStaffServiceImpl)this.context.getBean(this.getClass());
        if (CollUtil.isNotEmpty(paramList)) {
            for (CStaffEditParam editParam : paramList) {
                self.editInfo(editParam);
            }
        }
    }

    @Override
    public CStaff getByBaseIdAndBranchCid(Long staffBaseInfoId, Long branchCid) {
        return ((CStaffMapper)this.baseMapper).getByBaseIdAndBranchCid(staffBaseInfoId, branchCid);
    }

    @Override
    public CStaff getMaxTime(Long staffBaseInfoId, Long branchCid) {
        return ((CStaffMapper)this.baseMapper).getMaxTime(staffBaseInfoId, branchCid);
    }

    @Transactional
    public void recordWorkExperience(CStaff oldData, CStaff newestData, CStaffBaseInfo baseInfo, CStaffEditParam param) {
        BPostVo postInfo = this.postProvider.getPostInfo(newestData.getPost());
        BPostVo bPostVo = postInfo = postInfo == null ? new BPostVo() : postInfo;
        if (param.getType() == null) {
            return;
        }
        if (param.getType() == 0) {
            CStaffWorkExperience newestWorkExperienceInfo = this.cStaffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
            if (newestWorkExperienceInfo != null && (PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus()) || PostStatusEnum.TP_NON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus()))) {
                newestWorkExperienceInfo.setPostDepartureTime(param.getPostDepartureTime());
                newestWorkExperienceInfo.setPostStatus(PostStatusEnum.NON_POST.getValue());
                this.cStaffWorkExperienceService.updateById(newestWorkExperienceInfo);
            } else {
                CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
                staffWorkExperience.setCid(newestData.getCid());
                staffWorkExperience.setOrgId(newestData.getOrgId());
                staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
                staffWorkExperience.setPost(newestData.getPost());
                staffWorkExperience.setPostName(postInfo.getName());
                staffWorkExperience.setPostStatus(PostStatusEnum.NON_POST.getValue());
                staffWorkExperience.setType(param.getType());
                staffWorkExperience.setRaType(baseInfo.getRaType());
                staffWorkExperience.setPostStartTime(param.getPostStartTime());
                staffWorkExperience.setPostDepartureTime(param.getPostDepartureTime());
                this.cStaffWorkExperienceService.save(staffWorkExperience);
            }
        } else if (param.getType() == 1) {
            CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
            staffWorkExperience.setCid(newestData.getCid());
            staffWorkExperience.setOrgId(newestData.getOrgId());
            staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
            staffWorkExperience.setPost(newestData.getPost());
            staffWorkExperience.setPostName(postInfo.getName());
            staffWorkExperience.setPostStatus(PostStatusEnum.ON_POST.getValue());
            staffWorkExperience.setType(param.getType());
            staffWorkExperience.setRaType(baseInfo.getRaType());
            staffWorkExperience.setPostStartTime(param.getPostStartTime());
            this.cStaffWorkExperienceService.save(staffWorkExperience);
        } else if (param.getType() == 2) {
            CStaffWorkExperience staffWorkExperience;
            CStaffWorkExperience newestWorkExperienceInfo = this.cStaffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
            if (newestWorkExperienceInfo != null && PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus())) {
                staffWorkExperience = new CStaffWorkExperience();
                staffWorkExperience.setId(newestWorkExperienceInfo.getId());
                staffWorkExperience.setPostStatus(PostStatusEnum.NON_POST.getValue());
                staffWorkExperience.setType(param.getType());
                staffWorkExperience.setPostDepartureTime(param.getPostDepartureTime());
                this.cStaffWorkExperienceService.updateById(staffWorkExperience);
            }
            staffWorkExperience = new CStaffWorkExperience();
            staffWorkExperience.setCid(newestData.getCid());
            staffWorkExperience.setOrgId(newestData.getOrgId());
            staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
            staffWorkExperience.setPost(newestData.getPost());
            staffWorkExperience.setPostName(postInfo.getName());
            staffWorkExperience.setPostStatus(PostStatusEnum.ON_POST.getValue());
            staffWorkExperience.setType(param.getType());
            staffWorkExperience.setRaType(baseInfo.getRaType());
            staffWorkExperience.setPostStartTime(param.getPostStartTime());
            this.cStaffWorkExperienceService.save(staffWorkExperience);
        } else if (param.getType() == 3) {
            CStaffWorkExperience newestWorkExperienceInfo = this.cStaffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
            if (newestWorkExperienceInfo != null && PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus())) {
                newestWorkExperienceInfo.setTpPostDepartureTime(param.getTpPostDepartureTime());
                newestWorkExperienceInfo.setPrePostStartTime(param.getPrePostStartTime());
                newestWorkExperienceInfo.setPostStatus(PostStatusEnum.TP_NON_POST.getValue());
                this.cStaffWorkExperienceService.updateById(newestWorkExperienceInfo);
            } else {
                CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
                staffWorkExperience.setCid(newestData.getCid());
                staffWorkExperience.setOrgId(newestData.getOrgId());
                staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
                staffWorkExperience.setPost(newestData.getPost());
                staffWorkExperience.setPostName(postInfo.getName());
                staffWorkExperience.setPostStatus(PostStatusEnum.TP_NON_POST.getValue());
                staffWorkExperience.setType(param.getType());
                staffWorkExperience.setRaType(baseInfo.getRaType());
                staffWorkExperience.setTpPostDepartureTime(param.getTpPostDepartureTime());
                staffWorkExperience.setPrePostStartTime(param.getPrePostStartTime());
                this.cStaffWorkExperienceService.save(staffWorkExperience);
            }
        } else {
            return;
        }
    }
}

