/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.c;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.CStaffBaseInfoConverter;
import cn.smarthse.rho.modules.company.dao.c.CStaffBaseInfoMapper;
import cn.smarthse.rho.modules.company.model.home.HomeData31;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBStatisticService;
import cn.smarthse.rho.modules.company.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.company.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICStaffService;
import cn.smarthse.rho.modules.company.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.company.service.c.ICStatisticService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.enums.lock.DistributedLockEnum;
import cn.smarthse.rho.modules.sys.model.b.param.RayStaffQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffBaseInfoEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffAcInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCmPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffStatisticsParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CertConditionVo;
import cn.smarthse.rho.modules.sys.model.c.vo.CompanyStaffArchiveStatisticsVo;
import cn.smarthse.rho.modules.sys.model.c.vo.OrgStaffListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.RayStaffListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffAcVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveStatisticsCMVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.StaffImportDto;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CStaffBaseInfoServiceImpl
extends ServiceImpl<CStaffBaseInfoMapper, CStaffBaseInfo>
implements ICStaffBaseInfoService {
    private static final Logger log = LoggerFactory.getLogger(CStaffBaseInfoServiceImpl.class);
    @Autowired
    private CStaffBaseInfoConverter cStaffBaseInfoConverter;
    @Autowired
    private ICStaffService cStaffService;
    @Autowired
    private IBCompanyService bCompanyService;
    @Autowired
    private ICStatisticService cStatisticService;
    @Autowired
    private IBStatisticService bStatisticService;
    @Autowired
    private ICStaffWorkExperienceService staffWorkExperienceService;
    @Autowired
    private ICHealthCheckDataService healthCheckDataService;
    @Autowired
    private ICDoseDataService doseDataService;
    @Autowired
    private ICTrainingCertService trainingCertService;
    @Autowired
    private RedissonClient redissonClient;
    @DubboReference
    private ISysFileProvider fileProvider;

    @Override
    public LayuiGridData<List<OrgStaffListVo>> getListForOrg(StaffCmPageParam param) {
        boolean sameHospital = this.bCompanyService.isSameHospital(param.getCid(), ShiroUtil.getLoginUserCid());
        if (!sameHospital) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b\u5176\u4ed6\u533b\u9662\u4fe1\u606f");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<OrgStaffListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getListForOrg(param);
        for (OrgStaffListVo vo : list) {
            vo.genAge();
            vo.genSex();
            vo.genIdcard();
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<StaffArchiveListVo> getStaffArchiveList(StaffCmPageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffArchiveListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getStaffArchiveList(param);
        if (CollectionUtil.isEmpty(list)) {
            return new LayuiGridData((Page)list, (LayuiGridParam)param);
        }
        List<Long> staffBaseInfoIdList = list.stream().map(v -> v.getId()).collect(Collectors.toList());
        List<CertConditionVo> certConditionList = this.getCertCondition(staffBaseInfoIdList);
        Map<Long, CertConditionVo> certConditionVoMap = certConditionList.stream().collect(Collectors.toMap(v -> v.getStaffBaseInfoId(), v -> v));
        for (StaffArchiveListVo vo : list) {
            if (!certConditionVoMap.containsKey(vo.getId())) continue;
            CertConditionVo certConditionVo = certConditionVoMap.get(vo.getId());
            vo.setCertConditionVo(certConditionVo);
        }
        for (StaffArchiveListVo vo : list) {
            vo.setThresholdTime(this.getThresholdTime(vo.getId(), param.getCid()));
            vo.setHasRelatedData(Integer.valueOf(this.hasRelatedData(vo.getId()) != false ? 1 : 0));
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<StaffArchiveListVo> getPostStaffArchiveList(StaffCmPageParam param) {
        if (param.getPost() == null) {
            throw new ServiceException("\u7f3a\u5c11\u53c2\u6570");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffArchiveListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getPostStaffArchiveList(param);
        if (CollectionUtil.isEmpty(list)) {
            return new LayuiGridData((Page)list, (LayuiGridParam)param);
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public StaffArchiveListVo editInfo(CStaffBaseInfoEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        CStaffBaseInfo cStaffBaseInfo = this.cStaffBaseInfoConverter.param2Entity(param);
        cStaffBaseInfo.setEditTime(LocalDateTime.now());
        cStaffBaseInfo.setUpdateBy(param.getLoginUserId());
        cStaffBaseInfo.setSourceId(null);
        if (StrUtil.isNotBlank((CharSequence)param.getIdcard()) && StrUtil.contains((CharSequence)param.getIdcard(), (CharSequence)"*")) {
            throw new ServiceException("\u8eab\u4efd\u8bc1\u4e0d\u80fd\u5305\u542b*\u53f7");
        }
        if (StrUtil.isNotBlank((CharSequence)param.getPhone()) && StrUtil.contains((CharSequence)param.getPhone(), (CharSequence)"*")) {
            throw new ServiceException("\u624b\u673a\u4e0d\u80fd\u5305\u542b*\u53f7");
        }
        if (this.hasIdCardConflict(param.getId(), param.getIdcard())) {
            throw new ServiceException("\u8eab\u4efd\u8bc1\u5df2\u88ab\u4f7f\u7528");
        }
        if (StrUtil.isNotBlank((CharSequence)cStaffBaseInfo.getIdcard()) && IdcardUtil.isValidCard((String)cStaffBaseInfo.getIdcard())) {
            cStaffBaseInfo.setSex(Integer.valueOf(IdcardUtil.getGenderByIdCard((String)cStaffBaseInfo.getIdcard())));
            cStaffBaseInfo.setAge(Integer.valueOf(IdcardUtil.getAgeByIdCard((String)cStaffBaseInfo.getIdcard())));
        }
        this.updateById(cStaffBaseInfo);
        this.cStaffService.editInfo(param.getStaffEditParam());
        return this.cStaffBaseInfoConverter.entity2ArchiveVo(cStaffBaseInfo);
    }

    @Override
    @Transactional
    public StaffArchiveListVo add(CStaffBaseInfoEditParam param) {
        this.checkForAdd(param);
        StringBuilder sb = new StringBuilder(DistributedLockEnum.EDIT_STAFF_INFO.getKey()).append(param.getIdcard());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                StaffArchiveListVo e = this.addLock(param);
                return e;
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ServiceException("\u5931\u8d25");
            }
            finally {
                lock.unlock();
            }
        }
        log.error("{}\uff1aPending lock timeout\uff0cmethod:\u65b0\u589e\u4eba\u5458\u65b9\u6cd5", (Object)sb.toString());
        throw new ServiceException("\u5931\u8d25");
    }

    @Transactional
    public StaffArchiveListVo addLock(CStaffBaseInfoEditParam param) {
        this.checkForAdd(param);
        CStaffBaseInfo db = null;
        if (param.getId() == null) {
            if (param.getIdcard() == null) {
                throw new ServiceException("\u7f3a\u5c11\u8eab\u4efd\u8bc1");
            }
            db = this.getOneByIdCard(param.getIdcard());
            if (db == null) {
                CStaffBaseInfo addEntity = this.cStaffBaseInfoConverter.param2Entity(param);
                addEntity.setEditTime(LocalDateTime.now());
                addEntity.setCreateBy(param.getLoginUserId());
                addEntity.setUpdateBy(param.getLoginUserId());
                this.save(addEntity);
                db = addEntity;
            }
        } else {
            db = (CStaffBaseInfo)this.getById(param.getId());
            if (db == null) {
                throw new ServiceException("\u6240\u9009\u7528\u6237\u4e0d\u5b58\u5728");
            }
        }
        param.getStaffEditParam().setBaseId(db.getId());
        this.cStaffService.addInfo(param.getStaffEditParam());
        return this.cStaffBaseInfoConverter.entity2ArchiveVo(db);
    }

    public void checkForAdd(CStaffBaseInfoEditParam param) {
        if (param.getId() == null) {
            if (StrUtil.isBlank((CharSequence)param.getIdcard())) {
                throw new ServiceException("\u7f3a\u5c11\u8eab\u4efd\u8bc1\u4fe1\u606f");
            }
            if (StrUtil.contains((CharSequence)param.getIdcard(), (CharSequence)"*")) {
                throw new ServiceException("\u8eab\u4efd\u8bc1\u4fe1\u606f\u683c\u5f0f\u9519\u8bef");
            }
            if (StrUtil.contains((CharSequence)param.getPhone(), (CharSequence)"*")) {
                throw new ServiceException("\u624b\u673a\u53f7\u4fe1\u606f\u683c\u5f0f\u9519\u8bef");
            }
            if (param.getSource() == null) {
                throw new ServiceException("\u7f3a\u5c11\u6570\u636e\u6765\u6e90");
            }
        } else {
            CStaffBaseInfo db = this.getOneByIdCard(param.getIdcard());
            if (db == null) {
                throw new ServiceException("\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
        }
    }

    @Override
    @Transactional
    public void delete(CStaffBaseInfoEditParam param) {
        if (param.getId() == null) {
            return;
        }
        CStaff staff = this.cStaffService.getByBaseIdAndCid(param.getId(), ShiroUtil.getLoginUserCid());
        if (staff == null) {
            return;
        }
        if (this.hasRelatedData(staff.getBaseId()).booleanValue()) {
            throw new ServiceException("\u4eba\u5458\u65e0\u6cd5\u5220\u9664");
        }
        staff.setUniqueReference(String.valueOf(staff.getId()));
        this.cStaffService.updateById(staff);
        this.cStaffService.removeById(staff.getId());
    }

    @Override
    public StaffArchiveListVo getInfo(StaffInfoParam param) {
        List<CertConditionVo> certConditionVoList;
        SysFileVo sysFileVo;
        StaffArchiveListVo vo = ((CStaffBaseInfoMapper)this.baseMapper).getInfoById(param);
        if (vo == null) {
            return null;
        }
        if (vo.getHeadId() != null && (sysFileVo = this.fileProvider.getFileById(vo.getHeadId())) != null) {
            vo.setHeadFileName(sysFileVo.getFileName());
            vo.setHeadFileUrl(sysFileVo.getFullOssUrl());
        }
        if (CollectionUtil.isNotEmpty(certConditionVoList = this.getCertCondition(CollectionUtil.toList((Object[])new Long[]{vo.getId()})))) {
            CertConditionVo certConditionVo = certConditionVoList.get(0);
            vo.setCertConditionVo(certConditionVo);
        }
        vo.setThresholdTime(this.getThresholdTime(param.getId(), param.getCid()));
        vo.setHasRelatedData(Integer.valueOf(this.hasRelatedData(param.getId()) != false ? 1 : 0));
        return vo;
    }

    @Override
    public Boolean hasRelatedData(Long staffBaseInfo) {
        CHealthCheckData lastData1 = this.healthCheckDataService.getLastData(staffBaseInfo);
        CDoseData lastData2 = this.doseDataService.getLastData(staffBaseInfo);
        CTrainingCert lastData3 = this.trainingCertService.getLastData(staffBaseInfo);
        return lastData1 != null || lastData2 != null || lastData3 != null;
    }

    @Override
    public StaffArchiveListVo getRayManagerInfo(StaffInfoParam param) {
        StaffArchiveListVo result = new StaffArchiveListVo();
        StaffArchiveListVo db = ((CStaffBaseInfoMapper)this.baseMapper).getInfoById(param);
        result.setName(db.getName());
        result.setIfRaManager(db.getIfRaManager());
        result.setStaffType(db.getStaffType());
        result.setPhone(db.getPhone());
        return result;
    }

    private LocalDateTime getThresholdTime(Long staffBaseInfoId, Long cid) {
        CStaff staff = this.cStaffService.getMaxTime(staffBaseInfoId, cid);
        if (staff == null) {
            return null;
        }
        ArrayList<LocalDateTime> list = new ArrayList<LocalDateTime>();
        LocalDateTime postStartTime = staff.getPostStartTime();
        LocalDateTime postDepartureTime = staff.getPostDepartureTime();
        LocalDateTime tpPostDepartureTime = staff.getTpPostDepartureTime();
        if (postStartTime != null) {
            list.add(postStartTime);
        }
        if (postDepartureTime != null) {
            list.add(postDepartureTime);
        }
        if (tpPostDepartureTime != null) {
            list.add(tpPostDepartureTime);
        }
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        CollUtil.sort(list, Comparator.reverseOrder());
        return (LocalDateTime)list.get(0);
    }

    @Override
    public StaffArchiveStatisticsCMVo getStaffArchiveStatistics(StaffStatisticsParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffArchiveStatistics(param);
    }

    @Override
    public List<CertConditionVo> getCertCondition(List<Long> staffBaseInfoIdList) {
        ArrayList<CertConditionVo> list = new ArrayList<CertConditionVo>();
        if (CollUtil.isEmpty(staffBaseInfoIdList)) {
            return list;
        }
        for (Long id : staffBaseInfoIdList) {
            CertConditionVo certCondition = this.getCertCondition(id);
            if (certCondition == null) {
                certCondition = new CertConditionVo();
                certCondition.setStaffBaseInfoId(id);
                certCondition.setProfilePictureInfo(Integer.valueOf(0));
                certCondition.setHealthCheckInfo(Integer.valueOf(-1));
                certCondition.setHealthCheckResult(null);
                certCondition.setTrainingInfo(Integer.valueOf(-1));
            }
            list.add(certCondition);
        }
        return list;
    }

    @Override
    public CertConditionVo getCertCondition(Long staffBaseInfoId) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCertCondition(staffBaseInfoId);
    }

    @Override
    public LayuiGridData<StaffChooseListVo> getChooseList(StaffCmPageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffChooseListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getChooseList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<RayStaffListVo> rayStaffList(RayStaffQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RayStaffListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).rayStaffList(param);
        for (RayStaffListVo vo : list) {
            vo.setThresholdTime(this.getThresholdTime(vo.getId(), param.getCid()));
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public HomeData31 getHomeData31(Long cid) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getHomeData31(cid);
    }

    @Override
    public StaffAcVo getAcInfo(StaffAcInfoParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getAcInfo(param);
    }

    @Override
    public CompanyStaffArchiveStatisticsVo getCMStaffArchiveStatistics(StaffStatisticsParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCMStaffArchiveStatistics(param);
    }

    @Override
    public boolean hasIdCardConflict(Long id, String idCard) {
        if (StrUtil.isEmpty((CharSequence)idCard)) {
            return false;
        }
        CStaffBaseInfo entity = this.getOneByIdCard(idCard);
        return entity != null && !entity.getId().equals(id);
    }

    @Override
    public CStaffBaseInfo getOneByIdCard(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CStaffBaseInfo::getIdcard, (Object)idCard)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).last("limit 1");
        return (CStaffBaseInfo)this.getOne((Wrapper)wrapper);
    }

    @Override
    public Long getStaffCid(Long staffBaseInfoId, Long loginUserCid) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffCid(staffBaseInfoId, loginUserCid);
    }

    @Override
    public void importStaff(List<StaffImportDto> cachedDataList) {
    }
}

