/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.b;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.company.converter.BRayManageConverter;
import cn.smarthse.rho.modules.company.dao.b.BRayManageMapper;
import cn.smarthse.rho.modules.company.service.b.IBOrgService;
import cn.smarthse.rho.modules.company.service.b.IBRayManageService;
import cn.smarthse.rho.modules.sys.entity.b.BRayManage;
import cn.smarthse.rho.modules.sys.model.b.param.BRayManageEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BRayManageInfoParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BOrgVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BRayManageVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BRayManageServiceImpl
extends ServiceImpl<BRayManageMapper, BRayManage>
implements IBRayManageService {
    private final BRayManageConverter bRayManageConverter;
    private final IBOrgService bOrgService;
    @DubboReference
    private ISysFileProvider sysFileProvider;

    @Override
    public BRayManageVo getInfo(BRayManageInfoParam param) {
        PageHelper.clearPage();
        BRayManageVo info = ((BRayManageMapper)this.baseMapper).getInfo(param);
        if (info != null && StrUtil.isNotEmpty((CharSequence)info.getFile())) {
            List fileVoByIds = this.sysFileProvider.getFileVoByIds(info.getFile());
            info.setSysFileVos(fileVoByIds);
        }
        if (info != null && StrUtil.isNotEmpty((CharSequence)info.getOrgIds())) {
            List<Long> orgIdList = StrUtil.split((CharSequence)info.getOrgIds(), (CharSequence)",").stream().map(v -> Long.valueOf(v)).collect(Collectors.toList());
            List<BOrgVo> bOrgVoList = this.bOrgService.getByIds(orgIdList);
            info.setOrgVos(bOrgVoList);
        }
        return info;
    }

    @Override
    @Transactional
    public BRayManageVo add(BRayManageEditParam param) {
        if (param.getId() != null) {
            throw new ServiceException("\u5b58\u50a8\u6570\u636e\u5f02\u5e38");
        }
        BRayManageVo info = this.getInfo(new BRayManageInfoParam().setCid(param.getCid()));
        if (info != null) {
            throw new ServiceException("\u5df2\u7ecf\u5b58\u5728\u9886\u5bfc\u5c0f\u7ec4\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0\uff0c\u82e5\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u7f16\u8f91");
        }
        BRayManage bRayManage = this.bRayManageConverter.param2Entity(param);
        bRayManage.setCreateBy(param.getLoginUserId());
        bRayManage.setUpdateBy(param.getLoginUserId());
        this.save(bRayManage);
        return this.bRayManageConverter.entity2Vo(bRayManage);
    }

    @Override
    @Transactional
    public BRayManageVo edit(BRayManageEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u7f3a\u5c11id");
        }
        BRayManage db = (BRayManage)this.getById(param.getId());
        if (!param.getCid().equals(db.getCid())) {
            throw new ServiceException("\u5f02\u5e38!");
        }
        BRayManage bRayManage = this.bRayManageConverter.param2Entity(param);
        bRayManage.setEditTime(LocalDateTime.now());
        bRayManage.setCreateBy(param.getLoginUserId());
        bRayManage.setUpdateBy(param.getLoginUserId());
        this.updateById(bRayManage);
        return this.bRayManageConverter.entity2Vo(bRayManage);
    }

    public BRayManageServiceImpl(BRayManageConverter bRayManageConverter, IBOrgService bOrgService) {
        this.bRayManageConverter = bRayManageConverter;
        this.bOrgService = bOrgService;
    }
}

