/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.b;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.model.BaseEntity;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.LayuiGridParam;
import cn.smarthse.core.framework.service.ServiceImpl;
import cn.smarthse.rho.modules.company.bootstrap.security.model.vo.LoginByCreditCodeVo;
import cn.smarthse.rho.modules.company.converter.BCompanyConverter;
import cn.smarthse.rho.modules.company.dao.b.BCompanyMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.sys.ISysChangeLogService;
import cn.smarthse.rho.modules.company.sync.Rho2HseSyncService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.model.b.CompanyBatchVo;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyInfoParam;
import cn.smarthse.rho.modules.sys.model.b.param.CompanyInfoChangeLogParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyCampusVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CompanyChangeLogVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyPushProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysParamProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BCompanyServiceImpl
extends ServiceImpl<BCompanyMapper, BCompany>
implements IBCompanyService {
    private final BCompanyConverter bCompanyConverter;
    private final Rho2HseSyncService rho2HseSyncService;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final ISysChangeLogService sysChangeLogService;
    @DubboReference
    private ICompanyPushProvider companyPushProvider;
    @DubboReference
    private ISysParamProvider sysParamProvider;
    @DubboReference
    private ISysAreaProvider areaProvider;

    @Override
    public BCompanyVo getBaseInfoById(BCompanyInfoParam param) {
        BCompanyVo result = ((BCompanyMapper)this.baseMapper).getBaseInfo(param.getCid());
        if (result == null) {
            return new BCompanyVo();
        }
        result.setWorkArea(this.areaProvider.getAreaById(result.getAreaId()));
        result.setRegisteredArea(this.areaProvider.getAreaById(result.getRegisteredAreaId()));
        if (result.getType() != null) {
            result.setTypeName(this.sysParamProvider.getName(result.getType()));
        }
        if (result.getEconomyCode() != null) {
            result.setEconomyCodeName(this.sysParamProvider.getName(result.getEconomyCode()));
        }
        if (result.getUnitLevel() != null) {
            result.setUnitLevelName(this.sysParamProvider.getName(result.getUnitLevel()));
        }
        if (result.getBusinessType() != null) {
            result.setBusinessTypeName(this.sysParamProvider.getName(result.getBusinessType()));
        }
        return result;
    }

    @Override
    @Transactional
    public BCompany editBaseInfo(BCompanyEditParam param) {
        BCompany companyByName;
        if (param.getId() == null) {
            throw new ServiceException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BCompany db = (BCompany)this.getById(param.getId());
        BCompany old = (BCompany)ObjectUtil.cloneByStream((Object)db);
        if (!param.getId().equals(db.getId())) {
            throw new ServiceException("\u5f02\u5e38!");
        }
        BCompany bCompany = this.bCompanyConverter.editParam2Entity(param);
        bCompany.setCreateBy(param.getLoginUserId());
        bCompany.setUpdateBy(param.getLoginUserId());
        if (StrUtil.isNotEmpty((CharSequence)bCompany.getName()) && (companyByName = this.getCompanyByName(bCompany.getName())) != null && !companyByName.getId().equals(bCompany.getId())) {
            throw new ServiceException("\u533b\u9662\u540d\u79f0\u5df2\u5b58\u5728");
        }
        this.updateById(bCompany);
        BCompany newest = (BCompany)this.getById(param.getId());
        this.addPushInfo(old, newest);
        return bCompany;
    }

    public void addPushInfo(BCompany old, BCompany newest) {
        this.companyPushProvider.pushCompanyInfo(old, newest);
    }

    @Override
    public LayuiGridData<CompanyChangeLogVo> getChangeLog(CompanyInfoChangeLogParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CompanyChangeLogVo> changeLogVoList = ((BCompanyMapper)this.baseMapper).getChangeLog(param);
        return new LayuiGridData((Page)changeLogVoList, (LayuiGridParam)param);
    }

    @Override
    public List<CompanyBatchVo> getCompanyBatchChooseList(Long cid) {
        return ((BCompanyMapper)this.baseMapper).getCompanyBatchChooseList(cid);
    }

    @Override
    public List<BCompanyCampusVo> getBranchListForCompany(BCompanyInfoParam param) {
        return ((BCompanyMapper)this.baseMapper).getBranchList(param);
    }

    @Override
    public List<BCompanyCampusVo> getBranchListForStaffArchive(Long cid) {
        return ((BCompanyMapper)this.baseMapper).getBranchListForStaffArchive(cid);
    }

    @Override
    public boolean isSameHospital(Long targetCid, Long sourceCid) {
        if (targetCid == null) {
            return false;
        }
        List<Object> list = this.getBranchListForStaffArchive(sourceCid);
        list = list.stream().filter(v -> targetCid.equals(v.getId())).collect(Collectors.toList());
        return CollUtil.isNotEmpty(list);
    }

    @Override
    public BCompany getByNameAndBranchCid(String name, Long branchCid) {
        return ((BCompanyMapper)this.baseMapper).getByNameAndBranchCid(name, branchCid);
    }

    @Override
    public BCompany getCompanyByName(String name) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(BCompany::getName, (Object)name)).eq(BaseEntity::getIsValid, (Object)1)).last("limit 1");
        return (BCompany)this.getOne((Wrapper)wrapper);
    }

    @Override
    public List<LoginByCreditCodeVo> getLoginByCreditCode(String creditCode) {
        return ((BCompanyMapper)this.baseMapper).getLoginByCreditCode(creditCode);
    }

    public BCompanyServiceImpl(BCompanyConverter bCompanyConverter, Rho2HseSyncService rho2HseSyncService, ThreadPoolTaskExecutor taskExecutor, ISysChangeLogService sysChangeLogService) {
        this.bCompanyConverter = bCompanyConverter;
        this.rho2HseSyncService = rho2HseSyncService;
        this.taskExecutor = taskExecutor;
        this.sysChangeLogService = sysChangeLogService;
    }
}

