/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.manage.staff;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.model.ResponseStateEnum;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.lock.DistributedLockEnum;
import cn.smarthse.rho.modules.sys.enums.staff.RayCodeEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.model.easyexcel.StaffImportDto;
import cn.smarthse.rho.modules.sys.utils.staff.StaffUniqueReferenceUtil;
import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(readOnly=true)
public class StaffImportManager {
    private static final Logger log = LoggerFactory.getLogger(StaffImportManager.class);
    private final RedissonClient redissonClient;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final IBCompanyService companyService;
    public static final String IMPORT_ONE_STAFF_SUCCESS = "\u6210\u529f";

    @Transactional
    public String importStaff(List<StaffImportDto> importInfoList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_STAFF_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                String e = this.importStaffLock(importInfoList);
                return e;
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock != null && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
        log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb.toString());
        throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
    }

    @Transactional
    public String importStaffLock(List<StaffImportDto> importInfoList) {
        this.checkImportInfoList(importInfoList);
        ArrayList<StaffImportDto> errorInfoList = new ArrayList<StaffImportDto>();
        for (StaffImportDto staffImportDto : importInfoList) {
            String result = this.importOneStaff(staffImportDto);
            if (result.equals(IMPORT_ONE_STAFF_SUCCESS)) continue;
            staffImportDto.setHaveError(Boolean.valueOf(true));
            staffImportDto.setErrorReason(result);
            errorInfoList.add(staffImportDto);
        }
        return errorInfoList.size() > 0 ? JSON.toJSONString(errorInfoList) : null;
    }

    private void checkImportInfoList(List<StaffImportDto> importInfoList) {
        Long currentCid = ShiroUtil.getLoginUserCid();
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, List<StaffImportDto>> idcardMap = importInfoList.stream().filter(v -> StrUtil.isNotBlank((CharSequence)v.getIdcard())).collect(Collectors.groupingBy(v -> v.getIdcard()));
        idcardMap.forEach((idCard, list) -> {
            if (list.size() >= 2) {
                stringBuilder.append("\u8eab\u4efd\u8bc1").append((String)idCard).append("\u5728excel\u4e2d\u91cd\u590d\u5b58\u5728\uff0c\u5220\u9664\u91cd\u590d\u586b\u5199\u7684\u4eba\u5458\u4fe1\u606f\u3002");
            }
        });
        if (stringBuilder.length() > 0) {
            throw new ServiceException(stringBuilder.toString());
        }
        BCompany company = null;
        ArrayList<StaffImportDto> errorInfoList = new ArrayList<StaffImportDto>();
        for (StaffImportDto dto : importInfoList) {
            CStaff staff;
            CStaffBaseInfo staffBaseInfo;
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)dto.getCompanyName())) {
                sb.append("\u9662\u533a\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else {
                company = this.companyService.getByNameAndBranchCid(dto.getCompanyName(), currentCid);
                if (company == null) {
                    sb.append("\u6240\u5728\u533b\u9662\u4e0d\u5b58\u5728\u8be5\u9662\u533a\u3002");
                } else if (StrUtil.isBlank((CharSequence)company.getCreditCode())) {
                    sb.append("\u8be5\u9662\u533a\u7f3a\u5931\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\uff0c\u65e0\u6cd5\u5bfc\u5165\u4eba\u5458\u3002");
                }
            }
            if (StrUtil.isBlank((CharSequence)dto.getName())) {
                sb.append("\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (StrUtil.isBlank((CharSequence)dto.getIdcard())) {
                sb.append("\u8eab\u4efd\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else if (company != null && StrUtil.isNotBlank((CharSequence)company.getCreditCode()) && (staffBaseInfo = this.staffBaseInfoService.getOneByIdCard(dto.getIdcard())) != null && (staff = this.staffService.getByBaseIdAndBranchCid(staffBaseInfo.getId(), company.getId())) != null && !staff.getCid().equals(company.getId())) {
                sb.append("\u8be5\u4eba\u5458\u5df2\u7ecf\u5728\u5176\u4ed6\u9662\u533a\u3002");
            }
            if (StrUtil.isBlank((CharSequence)dto.getRaType())) {
                sb.append("\u804c\u4e1a\u7167\u5c04\u79cd\u7c7b\u53ca\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else {
                String rayType;
                List split = StrUtil.split((CharSequence)dto.getRaType(), (CharSequence)"\uff1a");
                String string = CollUtil.isEmpty((Collection)split) ? null : (rayType = split.size() >= 2 ? (String)split.get(1) : (String)split.get(0));
                if (StrUtil.isBlank((CharSequence)RayCodeEnum.getCode(rayType))) {
                    sb.append("\u804c\u4e1a\u7167\u5c04\u79cd\u7c7b\u53ca\u4ee3\u7801\u9519\u8bef\u3002");
                }
            }
            if (sb.length() <= 0) continue;
            dto.setHaveError(Boolean.valueOf(true));
            dto.setErrorReason(sb.toString());
            errorInfoList.add(dto);
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\u00b7\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    @Transactional
    public String importOneStaff(StaffImportDto staffImportDto) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.EDIT_STAFF_INFO.getKey()).append(staffImportDto.getIdcard());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(5L, 5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                String e = this.importOneStaffLock(staffImportDto);
                return e;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
        StringBuilder errInfo = new StringBuilder();
        errInfo.append("\u5bfc\u5165\u8d85\u65f6");
        log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb.toString());
        return errInfo.toString();
    }

    @Transactional
    public String importOneStaffLock(StaffImportDto dto) {
        CStaffBaseInfo db = this.staffBaseInfoService.getOneByIdCard(dto.getIdcard());
        if (db == null) {
            String idcard = dto.getIdcard();
            boolean validCard = IdcardUtil.isValidCard((String)idcard);
            Integer sex = StrUtil.isBlank((CharSequence)dto.getSex()) ? null : Integer.valueOf("\u7537".equals(dto.getSex()) ? 1 : 0);
            Integer n = sex = validCard ? Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idcard)) : sex;
            Integer age = validCard ? Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idcard)) : (NumberUtil.isInteger((String)dto.getAge()) ? Integer.valueOf(dto.getAge()) : null);
            LocalDate birthday = validCard ? LocalDate.from(DateUtil.toLocalDateTime((Date)IdcardUtil.getBirthDate((String)idcard))) : null;
            List split = StrUtil.split((CharSequence)dto.getRaType(), (CharSequence)"\uff1a");
            String rayType = CollUtil.isEmpty((Collection)split) ? null : (split.size() >= 2 ? (String)split.get(1) : (String)split.get(0));
            String rayTypeCode = RayCodeEnum.getCode(rayType);
            CStaffBaseInfo staffBaseInfo = new CStaffBaseInfo();
            staffBaseInfo.setName(dto.getName());
            staffBaseInfo.setPhone(dto.getPhone());
            staffBaseInfo.setIdcard(dto.getIdcard());
            staffBaseInfo.setAge(age);
            staffBaseInfo.setSex(sex);
            staffBaseInfo.setBirthday(birthday);
            staffBaseInfo.setRaType(rayTypeCode);
            staffBaseInfo.setEditTime(LocalDateTime.now());
            staffBaseInfo.setSource(StaffSourceEnum.UNIT_IMPORT.getValue());
            this.staffBaseInfoService.save(staffBaseInfo);
            db = staffBaseInfo;
        }
        BCompany company = this.companyService.getByNameAndBranchCid(dto.getCompanyName(), ShiroUtil.getLoginUserCid());
        CStaff staffDB = this.staffService.getByBaseIdAndCid(db.getId(), company.getId());
        if (staffDB != null) {
            return "\u8be5\u5458\u5de5\u5df2\u5728\u9662\u533a\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u5bfc\u5165";
        }
        CStaff staff = new CStaff();
        staff.setBaseId(db.getId());
        staff.setCid(company.getId());
        staff.setWorkNo(dto.getWorkNo());
        staff.setStaffType(Integer.valueOf(1));
        staff.setEditTime(LocalDateTime.now());
        staff.setSource(StaffSourceEnum.UNIT_IMPORT.getValue());
        staff.setUniqueReference(StaffUniqueReferenceUtil.genUniqueReference((String)company.getCreditCode(), (Long)staff.getBaseId()));
        this.staffService.save(staff);
        return IMPORT_ONE_STAFF_SUCCESS;
    }

    public StaffImportManager(RedissonClient redissonClient, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, IBCompanyService companyService) {
        this.redissonClient = redissonClient;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.companyService = companyService;
    }
}

