/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.manage.home;

import cn.smarthse.rho.modules.company.converter.BStatisticConverter;
import cn.smarthse.rho.modules.company.model.home.HomeData1;
import cn.smarthse.rho.modules.company.model.home.HomeData2;
import cn.smarthse.rho.modules.company.model.home.HomeData31;
import cn.smarthse.rho.modules.company.model.home.HomeData32;
import cn.smarthse.rho.modules.company.model.home.HomeData33;
import cn.smarthse.rho.modules.company.model.home.HomeData34;
import cn.smarthse.rho.modules.company.model.home.HomeData41;
import cn.smarthse.rho.modules.company.model.home.HomeData42;
import cn.smarthse.rho.modules.company.model.home.HomeData42Detail1;
import cn.smarthse.rho.modules.company.service.b.IBCertService;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBStatisticService;
import cn.smarthse.rho.modules.company.service.c.ICDoseDataService;
import cn.smarthse.rho.modules.company.service.c.ICHealthCheckDataService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRayService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceSourceService;
import cn.smarthse.rho.modules.company.service.e.IEmachineRoomService;
import cn.smarthse.rho.modules.company.service.e.IEsourceNonSealedService;
import cn.smarthse.rho.modules.company.service.e.IEsourceSealedService;
import cn.smarthse.rho.modules.sys.entity.b.BStatistic;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyInfoParam;
import cn.smarthse.rho.modules.sys.model.e.vo.CmEDeviceRayStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmEDeviceStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmESourceNonSealedStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomLevelStatisticsVo;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HomeManage {
    private static final Logger log = LoggerFactory.getLogger(HomeManage.class);
    private final IBCompanyService companyService;
    private final IBStatisticService bStatisticService;
    private final ICStaffBaseInfoService cStaffService;
    private final ICTrainingService cTrainingService;
    private final ICHealthCheckDataService healthCheckDataService;
    private final ICDoseDataService doseDataService;
    private final IBCertService certService;
    private final IEdeviceRayService deviceRayService;
    private final IEmachineRoomService machineRoomService;
    private final IEsourceSealedService sourceSealedService;
    private final IEdeviceSourceService deviceSourceService;
    private final IEsourceNonSealedService sourceNonSealedService;
    private final BStatisticConverter converter;

    public HomeData1 getBaseInfo(Long cid) {
        BCompanyInfoParam param = new BCompanyInfoParam();
        param.setCid(cid);
        HomeData1 result = this.converter.BCompanyVo2HomeData1(this.companyService.getBaseInfoById(param));
        if (result == null) {
            return new HomeData1();
        }
        BStatistic bStatistic = this.bStatisticService.getByCid(cid, LocalDate.now().getYear());
        if (bStatistic != null) {
            result.setSuperviseTimes(bStatistic.getSuperviseTimes());
            result.setEnforcementTimes(bStatistic.getEnforcementTimes());
            result.setDiseaseAddNum(bStatistic.getDiseaseAddNum());
            result.setDiseaseNum(bStatistic.getDiseaseNum());
        }
        return result;
    }

    public HomeData2 getHomeData2(Long cid) {
        int year = LocalDate.now().getYear();
        BStatistic bStatistic = this.bStatisticService.getByCid(cid, year);
        if (bStatistic == null) {
            return new HomeData2();
        }
        return this.converter.BStatistic2HomeData2(bStatistic);
    }

    public HomeData31 getHomeData31(Long cid) {
        return this.cStaffService.getHomeData31(cid);
    }

    public HomeData32 getHomeData32(Long cid) {
        return this.cTrainingService.getHomeData32(cid);
    }

    public HomeData33 getHomeData33(Long cid) {
        return this.healthCheckDataService.getHomeData33(cid);
    }

    public HomeData34 getHomeData34(Long cid) {
        return this.doseDataService.getHomeData34(cid);
    }

    public HomeData41 getHomeData41(Long cid) {
        return this.certService.getHomeData41ByCid(cid);
    }

    public HomeData42 getHomeData42(Long cid) {
        HomeData42 result = new HomeData42();
        CmEDeviceRayStatisticsVo deviceRayStatisticsVo = this.deviceRayService.deviceRayStatisticsForCompany(new BCompanyInfoParam().setCid(cid));
        result.setNum1(deviceRayStatisticsVo.getRadiationTherapyNum());
        result.setNum2(deviceRayStatisticsVo.getNuclearNum());
        result.setNum3(deviceRayStatisticsVo.getInterventionalNum());
        result.setNum4(deviceRayStatisticsVo.getXrayNum());
        try {
            CmESourceNonSealedStatisticsVo nonSealedStatisticsVo = this.sourceNonSealedService.sourceNonSealedStatisticsForCompany(new BCompanyInfoParam().setCid(cid));
            result.setNum5_1(nonSealedStatisticsVo.getData1());
            result.setNum5_2(nonSealedStatisticsVo.getData2());
            result.setNum6_1(nonSealedStatisticsVo.getData3());
            result.setNum6_2(nonSealedStatisticsVo.getData4());
            result.setNum5(result.getNum5_1() + "E+" + result.getNum5_2());
            result.setNum6(result.getNum6_1() + "E+" + result.getNum6_2());
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        EMachineRoomLevelStatisticsVo machineRoomLevelVo = this.machineRoomService.getLevelStatistics(cid, EdeviceTypeEnum.SOURCE_NON_SEALED.getValue());
        result.setNum7(machineRoomLevelVo.getGradeANum());
        result.setNum8(machineRoomLevelVo.getGradeBNum());
        result.setNum9(machineRoomLevelVo.getGradeCNum());
        try {
            List<CmEDeviceStatisticsVo> sealedSourceStatistics = this.sourceSealedService.sealedSourceStatistics(new BCompanyInfoParam().setCid(cid));
            List<CmEDeviceStatisticsVo> includeSealedSourceStatistics = this.sourceSealedService.includeSealedSourceStatistics(new BCompanyInfoParam().setCid(cid));
            ArrayList<HomeData42Detail1> sourceSealedStatisticsList = new ArrayList<HomeData42Detail1>();
            for (CmEDeviceStatisticsVo t : sealedSourceStatistics) {
                HomeData42Detail1 detail42_1 = new HomeData42Detail1();
                detail42_1.setName(t.getName());
                detail42_1.setNum(t.getTotal());
                detail42_1.setData1Total(t.getData1Total());
                detail42_1.setData2Total(t.getData2Total());
                sourceSealedStatisticsList.add(detail42_1);
            }
            result.setSealedSources(sourceSealedStatisticsList);
            ArrayList<HomeData42Detail1> sealedDeviceSourceStatisticsList = new ArrayList<HomeData42Detail1>();
            for (CmEDeviceStatisticsVo t : includeSealedSourceStatistics) {
                HomeData42Detail1 detail42_1 = new HomeData42Detail1();
                detail42_1.setName(t.getName());
                detail42_1.setNum(t.getTotal());
                detail42_1.setData1Total(t.getData1Total());
                detail42_1.setData2Total(t.getData2Total());
                sealedDeviceSourceStatisticsList.add(detail42_1);
            }
            result.setSealedSourceDevices(sealedDeviceSourceStatisticsList);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return result;
    }

    public HomeManage(IBCompanyService companyService, IBStatisticService bStatisticService, ICStaffBaseInfoService cStaffService, ICTrainingService cTrainingService, ICHealthCheckDataService healthCheckDataService, ICDoseDataService doseDataService, IBCertService certService, IEdeviceRayService deviceRayService, IEmachineRoomService machineRoomService, IEsourceSealedService sourceSealedService, IEdeviceSourceService deviceSourceService, IEsourceNonSealedService sourceNonSealedService, BStatisticConverter converter) {
        this.companyService = companyService;
        this.bStatisticService = bStatisticService;
        this.cStaffService = cStaffService;
        this.cTrainingService = cTrainingService;
        this.healthCheckDataService = healthCheckDataService;
        this.doseDataService = doseDataService;
        this.certService = certService;
        this.deviceRayService = deviceRayService;
        this.machineRoomService = machineRoomService;
        this.sourceSealedService = sourceSealedService;
        this.deviceSourceService = deviceSourceService;
        this.sourceNonSealedService = sourceNonSealedService;
        this.converter = converter;
    }
}

