/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.easyexcel;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.company.manage.staff.StaffImportManagerV2;
import cn.smarthse.rho.modules.sys.model.easyexcel.StaffImportDtoV2;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaffImportListenerV2
extends AnalysisEventListener<StaffImportDtoV2> {
    private static final Logger log = LoggerFactory.getLogger(StaffImportListenerV2.class);
    private static final int BATCH_COUNT = 3000;
    private List<StaffImportDtoV2> cachedDataList = new ArrayList<StaffImportDtoV2>();
    private List<String> resultInfo;
    private StaffImportManagerV2 staffManage;

    public StaffImportListenerV2(StaffImportManagerV2 staffManage, List<String> resultInfo) {
        this.staffManage = staffManage;
        this.resultInfo = resultInfo;
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        super.onException(exception, context);
    }

    public void invoke(StaffImportDtoV2 data, AnalysisContext context) {
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSON.toJSONString((Object)data));
        data.setRowIndex(Integer.valueOf(context.readRowHolder().getRowIndex() + 1));
        data.setExcelRowIndex(context.readRowHolder().getRowIndex());
        this.trim(data);
        data.setPostStartTime(this.dealTime(data.getPostStartTime()));
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 3000) {
            this.saveData();
            this.cachedDataList = new ArrayList<StaffImportDtoV2>();
        }
    }

    private void trim(StaffImportDtoV2 data) {
        data.setName(StrUtil.trim((CharSequence)data.getName()));
        data.setPhone(StrUtil.trim((CharSequence)data.getPhone()));
        data.setIdcard(StrUtil.trim((CharSequence)data.getIdcard()));
        data.setSex(StrUtil.trim((CharSequence)data.getSex()));
        data.setAge(StrUtil.trim((CharSequence)data.getAge()));
        data.setRaType(StrUtil.trim((CharSequence)data.getRaType()));
        data.setCompanyName(StrUtil.trim((CharSequence)data.getCompanyName()));
        data.setOrgName(StrUtil.trim((CharSequence)data.getOrgName()));
        data.setPostName(StrUtil.trim((CharSequence)data.getPostName()));
        data.setPostStartTime(StrUtil.trim((CharSequence)data.getPostStartTime()));
        data.setWorkNo(StrUtil.trim((CharSequence)data.getWorkNo()));
    }

    private void saveData() {
        log.info("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.cachedDataList.size());
        String s = this.staffManage.importStaff(this.cachedDataList);
        if (StrUtil.isNotBlank((CharSequence)s)) {
            this.resultInfo.add(s);
        }
        log.info("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.saveData();
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }

    public String dealTime(String time) {
        if (StrUtil.isBlank((CharSequence)time)) {
            return null;
        }
        List split = StrUtil.split((CharSequence)time, (CharSequence)"/");
        if (split.size() != 3) {
            return time;
        }
        String year = (String)split.get(0);
        String month = (String)split.get(1);
        String day = (String)split.get(2);
        month = StrUtil.length((CharSequence)month) != 2 ? "0" + month : month;
        day = StrUtil.length((CharSequence)day) != 2 ? "0" + day : day;
        return year + "/" + month + "/" + day;
    }
}

